/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsUtils;

public class SignatureAndHashAlgorithm {
    public static final SignatureAndHashAlgorithm ecdsa_brainpoolP256r1tls13_sha256 = SignatureAndHashAlgorithm.create(2074);
    public static final SignatureAndHashAlgorithm ecdsa_brainpoolP384r1tls13_sha384 = SignatureAndHashAlgorithm.create(2075);
    public static final SignatureAndHashAlgorithm ecdsa_brainpoolP512r1tls13_sha512 = SignatureAndHashAlgorithm.create(2076);
    public static final SignatureAndHashAlgorithm ed25519 = SignatureAndHashAlgorithm.create(2055);
    public static final SignatureAndHashAlgorithm ed448 = SignatureAndHashAlgorithm.create(2056);
    public static final SignatureAndHashAlgorithm gostr34102012_256 = SignatureAndHashAlgorithm.create((short)8, (short)64);
    public static final SignatureAndHashAlgorithm gostr34102012_512 = SignatureAndHashAlgorithm.create((short)8, (short)65);
    public static final SignatureAndHashAlgorithm mldsa44 = SignatureAndHashAlgorithm.create(2308);
    public static final SignatureAndHashAlgorithm mldsa65 = SignatureAndHashAlgorithm.create(2309);
    public static final SignatureAndHashAlgorithm mldsa87 = SignatureAndHashAlgorithm.create(2310);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha256 = SignatureAndHashAlgorithm.create(2052);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha384 = SignatureAndHashAlgorithm.create(2053);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha512 = SignatureAndHashAlgorithm.create(2054);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha256 = SignatureAndHashAlgorithm.create(2057);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha384 = SignatureAndHashAlgorithm.create(2058);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha512 = SignatureAndHashAlgorithm.create(2059);
    public static final SignatureAndHashAlgorithm slhdsa_sha2_128s = SignatureAndHashAlgorithm.create(2321);
    public static final SignatureAndHashAlgorithm slhdsa_sha2_128f = SignatureAndHashAlgorithm.create(2322);
    public static final SignatureAndHashAlgorithm slhdsa_sha2_192s = SignatureAndHashAlgorithm.create(2323);
    public static final SignatureAndHashAlgorithm slhdsa_sha2_192f = SignatureAndHashAlgorithm.create(2324);
    public static final SignatureAndHashAlgorithm slhdsa_sha2_256s = SignatureAndHashAlgorithm.create(2325);
    public static final SignatureAndHashAlgorithm slhdsa_sha2_256f = SignatureAndHashAlgorithm.create(2326);
    public static final SignatureAndHashAlgorithm slhdsa_shake_128s = SignatureAndHashAlgorithm.create(2327);
    public static final SignatureAndHashAlgorithm slhdsa_shake_128f = SignatureAndHashAlgorithm.create(2328);
    public static final SignatureAndHashAlgorithm slhdsa_shake_192s = SignatureAndHashAlgorithm.create(2329);
    public static final SignatureAndHashAlgorithm slhdsa_shake_192f = SignatureAndHashAlgorithm.create(2330);
    public static final SignatureAndHashAlgorithm slhdsa_shake_256s = SignatureAndHashAlgorithm.create(2331);
    public static final SignatureAndHashAlgorithm slhdsa_shake_256f = SignatureAndHashAlgorithm.create(2332);
    protected final short hash;
    protected final short signature;

    public static SignatureAndHashAlgorithm getInstance(short hashAlgorithm, short signatureAlgorithm) {
        switch (hashAlgorithm) {
            case 8: {
                return SignatureAndHashAlgorithm.getInstanceIntrinsic(signatureAlgorithm);
            }
        }
        return SignatureAndHashAlgorithm.create(hashAlgorithm, signatureAlgorithm);
    }

    private static SignatureAndHashAlgorithm getInstanceIntrinsic(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 7: {
                return ed25519;
            }
            case 8: {
                return ed448;
            }
            case 64: {
                return gostr34102012_256;
            }
            case 65: {
                return gostr34102012_512;
            }
            case 4: {
                return rsa_pss_rsae_sha256;
            }
            case 5: {
                return rsa_pss_rsae_sha384;
            }
            case 6: {
                return rsa_pss_rsae_sha512;
            }
            case 9: {
                return rsa_pss_pss_sha256;
            }
            case 10: {
                return rsa_pss_pss_sha384;
            }
            case 11: {
                return rsa_pss_pss_sha512;
            }
            case 26: {
                return ecdsa_brainpoolP256r1tls13_sha256;
            }
            case 27: {
                return ecdsa_brainpoolP384r1tls13_sha384;
            }
            case 28: {
                return ecdsa_brainpoolP512r1tls13_sha512;
            }
        }
        return SignatureAndHashAlgorithm.create((short)8, signatureAlgorithm);
    }

    private static SignatureAndHashAlgorithm create(int signatureScheme) {
        short hashAlgorithm = SignatureScheme.getHashAlgorithm(signatureScheme);
        short signatureAlgorithm = SignatureScheme.getSignatureAlgorithm(signatureScheme);
        return SignatureAndHashAlgorithm.create(hashAlgorithm, signatureAlgorithm);
    }

    private static SignatureAndHashAlgorithm create(short hashAlgorithm, short signatureAlgorithm) {
        return new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
    }

    public SignatureAndHashAlgorithm(short hash, short signature) {
        if ((hash & 0xFF) != hash) {
            throw new IllegalArgumentException("'hash' should be a uint8");
        }
        if ((signature & 0xFF) != signature) {
            throw new IllegalArgumentException("'signature' should be a uint8");
        }
        this.hash = hash;
        this.signature = signature;
    }

    public short getHash() {
        return this.hash;
    }

    public short getSignature() {
        return this.signature;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.getHash(), output);
        TlsUtils.writeUint8(this.getSignature(), output);
    }

    public static SignatureAndHashAlgorithm parse(InputStream input) throws IOException {
        short hash = TlsUtils.readUint8(input);
        short signature = TlsUtils.readUint8(input);
        return SignatureAndHashAlgorithm.getInstance(hash, signature);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SignatureAndHashAlgorithm)) {
            return false;
        }
        SignatureAndHashAlgorithm other = (SignatureAndHashAlgorithm)obj;
        return other.getHash() == this.getHash() && other.getSignature() == this.getSignature();
    }

    public int hashCode() {
        return this.getHash() << 16 | this.getSignature();
    }

    public String toString() {
        return "{" + HashAlgorithm.getText(this.hash) + "," + SignatureAlgorithm.getText(this.signature) + "}";
    }
}

