/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import org.bouncycastle.jcajce.spec.RawEncodedKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

class XDHUtil {
    XDHUtil() {
    }

    static PublicKey decodePublicKey(JcaTlsCrypto crypto, String keyFactoryAlgorithm, ASN1ObjectIdentifier algorithmOID, byte[] encoding) throws TlsFatalAlert {
        try {
            KeyFactory kf = crypto.getHelper().createKeyFactory(keyFactoryAlgorithm);
            if (kf.getProvider() instanceof BouncyCastleProvider) {
                try {
                    RawEncodedKeySpec keySpec = new RawEncodedKeySpec(encoding);
                    return kf.generatePublic((KeySpec)keySpec);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            X509EncodedKeySpec keySpec = XDHUtil.createX509EncodedKeySpec(algorithmOID, encoding);
            return kf.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    static byte[] encodePublicKey(PublicKey publicKey) throws TlsFatalAlert {
        if (publicKey instanceof XDHPublicKey) {
            return ((XDHPublicKey)publicKey).getUEncoding();
        }
        if (!"X.509".equals(publicKey.getFormat())) {
            throw new TlsFatalAlert(80, "Public key format unrecognized");
        }
        try {
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            return spki.getPublicKeyData().getOctets();
        }
        catch (Exception e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    private static X509EncodedKeySpec createX509EncodedKeySpec(ASN1ObjectIdentifier oid, byte[] encoding) throws IOException {
        AlgorithmIdentifier algID = new AlgorithmIdentifier(oid);
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(algID, encoding);
        return new X509EncodedKeySpec(spki.getEncoded("DER"));
    }
}

