/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDH;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;

public class JceTlsECDomain
implements TlsECDomain {
    protected final JcaTlsCrypto crypto;
    protected ECNamedCurveGenParameterSpec ecGenSpec;
    protected ECParameterSpec ecParameterSpec;
    protected ECCurve ecCurve;

    public JceTlsECDomain(JcaTlsCrypto crypto, TlsECConfig ecConfig) {
        this.crypto = crypto;
        this.init(ecConfig.getNamedGroup());
    }

    public JceTlsSecret calculateECDHAgreement(ECPrivateKey privateKey, ECPublicKey publicKey) throws IOException {
        try {
            byte[] secret = this.crypto.calculateKeyAgreement("ECDH", (PrivateKey)privateKey, (PublicKey)publicKey, "TlsPremasterSecret");
            return this.crypto.adoptLocalSecret(secret);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot calculate secret", e);
        }
    }

    public TlsAgreement createECDH() {
        return new JceTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] encoding) throws IOException {
        return this.ecCurve.decodePoint(encoding);
    }

    public ECPublicKey decodePublicKey(byte[] encoding) throws IOException {
        try {
            KeyFactory keyFact = this.crypto.getHelper().createKeyFactory("EC");
            ECPoint point = this.decodePoint(encoding);
            ECPublicKeySpec keySpec = new ECPublicKeySpec(this.ecParameterSpec.getCurve().createPoint(point.getAffineXCoord().toBigInteger(), point.getAffineYCoord().toBigInteger()), this.ecParameterSpec);
            return (ECPublicKey)keyFact.generatePublic((KeySpec)keySpec);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    public byte[] encodePoint(ECPoint point) throws IOException {
        return point.getEncoded(false);
    }

    public byte[] encodePublicKey(ECPublicKey publicKey) throws IOException {
        ECPoint w = publicKey.getQ();
        return this.encodePoint(this.ecCurve.createPoint(w.getAffineXCoord().toBigInteger(), w.getAffineYCoord().toBigInteger()));
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("EC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)this.ecGenSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to create key pair: " + e.getMessage(), e);
        }
    }

    private void init(int namedGroup) {
        this.ecCurve = null;
        this.ecGenSpec = null;
        this.ecParameterSpec = null;
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            return;
        }
        String curveName = NamedGroup.getName(namedGroup);
        if (curveName == null) {
            return;
        }
        try {
            AlgorithmParameters ecDomain = this.crypto.getHelper().createAlgorithmParameters("EC");
            this.ecGenSpec = new ECNamedCurveGenParameterSpec(curveName);
            try {
                ecDomain.init((AlgorithmParameterSpec)this.ecGenSpec);
                ECParameterSpec ecSpec = (ECParameterSpec)ecDomain.getParameterSpec(ECParameterSpec.class);
                this.ecCurve = ecSpec.getCurve();
                this.ecParameterSpec = ecSpec;
            }
            catch (Exception e) {
                KeyPairGenerator kpGen = this.crypto.getHelper().createKeyPairGenerator("EC");
                kpGen.initialize((AlgorithmParameterSpec)this.ecGenSpec, this.crypto.getSecureRandom());
                KeyPair kp = kpGen.generateKeyPair();
                ECParameterSpec ecSpec = (ECParameterSpec)ecDomain.getParameterSpec(ECParameterSpec.class);
                this.ecCurve = ecSpec.getCurve();
                this.ecParameterSpec = ecSpec;
            }
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to create key pair: " + e.getMessage(), e);
        }
    }

    private static int[] convertMidTerms(int[] k) {
        int[] res = new int[3];
        if (k.length == 1) {
            res[0] = k[0];
        } else {
            if (k.length != 3) {
                throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
            }
            if (k[0] < k[1] && k[0] < k[2]) {
                res[0] = k[0];
                if (k[1] < k[2]) {
                    res[1] = k[1];
                    res[2] = k[2];
                } else {
                    res[1] = k[2];
                    res[2] = k[1];
                }
            } else if (k[1] < k[2]) {
                res[0] = k[1];
                if (k[0] < k[2]) {
                    res[1] = k[0];
                    res[2] = k[2];
                } else {
                    res[1] = k[2];
                    res[2] = k[0];
                }
            } else {
                res[0] = k[2];
                if (k[0] < k[1]) {
                    res[1] = k[0];
                    res[2] = k[1];
                } else {
                    res[1] = k[1];
                    res[2] = k[0];
                }
            }
        }
        return res;
    }
}

