/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.interfaces.DHPublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.Tls13Verifier;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.LegacyTls13Verifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSAVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSAVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAEncryptor;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAPSSVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;

public class JcaTlsCertificate
implements TlsCertificate {
    protected static final int KU_DIGITAL_SIGNATURE = 0;
    protected static final int KU_NON_REPUDIATION = 1;
    protected static final int KU_KEY_ENCIPHERMENT = 2;
    protected static final int KU_DATA_ENCIPHERMENT = 3;
    protected static final int KU_KEY_AGREEMENT = 4;
    protected static final int KU_KEY_CERT_SIGN = 5;
    protected static final int KU_CRL_SIGN = 6;
    protected static final int KU_ENCIPHER_ONLY = 7;
    protected static final int KU_DECIPHER_ONLY = 8;
    protected final JcaTlsCrypto crypto;
    protected final X509Certificate certificate;
    protected DHPublicKey pubKeyDH = null;
    protected ECPublicKey pubKeyEC = null;
    protected PublicKey pubKeyRSA = null;

    public static JcaTlsCertificate convert(JcaTlsCrypto crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof JcaTlsCertificate) {
            return (JcaTlsCertificate)certificate;
        }
        return new JcaTlsCertificate(crypto, certificate.getEncoded());
    }

    public static X509Certificate parseCertificate(JcaJceHelper helper, byte[] encoding) throws IOException {
        try {
            ASN1Primitive asn1 = TlsUtils.readASN1Object(encoding);
            byte[] derEncoding = Certificate.getInstance((Object)asn1).getEncoded("DER");
            ByteArrayInputStream input = new ByteArrayInputStream(derEncoding);
            X509Certificate certificate = (X509Certificate)helper.createCertificateFactory("X.509").generateCertificate(input);
            if (input.available() != 0) {
                throw new IOException("Extra data detected in stream");
            }
            return certificate;
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("unable to decode certificate", e);
        }
    }

    public JcaTlsCertificate(JcaTlsCrypto crypto, byte[] encoding) throws IOException {
        this(crypto, JcaTlsCertificate.parseCertificate(crypto.getHelper(), encoding));
    }

    public JcaTlsCertificate(JcaTlsCrypto crypto, X509Certificate certificate) {
        this.crypto = crypto;
        this.certificate = certificate;
    }

    public TlsEncryptor createEncryptor(int tlsCertificateRole) throws IOException {
        this.validateKeyUsageBit(2);
        switch (tlsCertificateRole) {
            case 3: {
                this.pubKeyRSA = this.getPubKeyRSA();
                return new JcaTlsRSAEncryptor(this.crypto, this.pubKeyRSA);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        switch (signatureAlgorithm) {
            case 7: 
            case 8: {
                int signatureScheme = SignatureScheme.from((short)8, signatureAlgorithm);
                Tls13Verifier tls13Verifier = this.createVerifier(signatureScheme);
                return new LegacyTls13Verifier(signatureScheme, tls13Verifier);
            }
        }
        this.validateKeyUsageBit(0);
        switch (signatureAlgorithm) {
            case 2: {
                return new JcaTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new JcaTlsECDSAVerifier(this.crypto, (PublicKey)this.getPubKeyEC());
            }
            case 1: {
                this.validateRSA_PKCS1();
                return new JcaTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 9: 
            case 10: 
            case 11: {
                this.validateRSA_PSS_PSS(signatureAlgorithm);
                int signatureScheme = SignatureScheme.from((short)8, signatureAlgorithm);
                return new JcaTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), signatureScheme);
            }
            case 4: 
            case 5: 
            case 6: {
                this.validateRSA_PSS_RSAE();
                int signatureScheme = SignatureScheme.from((short)8, signatureAlgorithm);
                return new JcaTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), signatureScheme);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public Tls13Verifier createVerifier(int signatureScheme) throws IOException {
        this.validateKeyUsageBit(0);
        switch (signatureScheme) {
            case 515: 
            case 1027: 
            case 1283: 
            case 1539: 
            case 2074: 
            case 2075: 
            case 2076: {
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                String digestName = this.crypto.getDigestName(cryptoHashAlgorithm);
                String sigName = RSAUtil.getDigestSigAlgName(digestName) + "WITHECDSA";
                return this.crypto.createTls13Verifier(sigName, null, (PublicKey)this.getPubKeyEC());
            }
            case 2055: {
                return this.crypto.createTls13Verifier("Ed25519", null, this.getPubKeyEd25519());
            }
            case 2056: {
                return this.crypto.createTls13Verifier("Ed448", null, this.getPubKeyEd448());
            }
            case 513: 
            case 1025: 
            case 1281: 
            case 1537: {
                this.validateRSA_PKCS1();
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                String digestName = this.crypto.getDigestName(cryptoHashAlgorithm);
                String sigName = RSAUtil.getDigestSigAlgName(digestName) + "WITHRSA";
                return this.crypto.createTls13Verifier(sigName, null, this.getPubKeyRSA());
            }
            case 2057: 
            case 2058: 
            case 2059: {
                this.validateRSA_PSS_PSS(SignatureScheme.getSignatureAlgorithm(signatureScheme));
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                String digestName = this.crypto.getDigestName(cryptoHashAlgorithm);
                String sigName = RSAUtil.getDigestSigAlgName(digestName) + "WITHRSAANDMGF1";
                AlgorithmParameterSpec pssSpec = RSAUtil.getPSSParameterSpec(cryptoHashAlgorithm, digestName, this.crypto.getHelper());
                return this.crypto.createTls13Verifier(sigName, pssSpec, this.getPubKeyRSA());
            }
            case 2052: 
            case 2053: 
            case 2054: {
                this.validateRSA_PSS_RSAE();
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                String digestName = this.crypto.getDigestName(cryptoHashAlgorithm);
                String sigName = RSAUtil.getDigestSigAlgName(digestName) + "WITHRSAANDMGF1";
                AlgorithmParameterSpec pssSpec = RSAUtil.getPSSParameterSpec(cryptoHashAlgorithm, digestName, this.crypto.getHelper());
                return this.crypto.createTls13Verifier(sigName, pssSpec, this.getPubKeyRSA());
            }
            case 2308: 
            case 2309: 
            case 2310: {
                return this.crypto.createTls13Verifier("ML-DSA", null, this.getPubKeyMLDSA());
            }
        }
        throw new TlsFatalAlert(80);
    }

    public byte[] getEncoded() throws IOException {
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new TlsCryptoException("unable to encode certificate: " + e.getMessage(), e);
        }
    }

    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        byte[] encoding = this.certificate.getExtensionValue(extensionOID.getId());
        return encoding == null ? null : ((ASN1OctetString)ASN1Primitive.fromByteArray((byte[])encoding)).getOctets();
    }

    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber();
    }

    public String getSigAlgOID() {
        return this.certificate.getSigAlgOID();
    }

    public ASN1Encodable getSigAlgParams() throws IOException {
        byte[] derEncoding = this.certificate.getSigAlgParams();
        if (null == derEncoding) {
            return null;
        }
        ASN1Primitive asn1 = TlsUtils.readASN1Object(derEncoding);
        TlsUtils.requireDEREncoding((ASN1Object)asn1, derEncoding);
        return asn1;
    }

    DHPublicKey getPubKeyDH() throws IOException {
        try {
            return (DHPublicKey)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not DH", e);
        }
    }

    DSAPublicKey getPubKeyDSS() throws IOException {
        try {
            return (DSAPublicKey)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not DSS", e);
        }
    }

    ECPublicKey getPubKeyEC() throws IOException {
        try {
            return (ECPublicKey)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, "Public key not EC", e);
        }
    }

    PublicKey getPubKeyEd25519() throws IOException {
        PublicKey publicKey = this.getPublicKey();
        if (!("Ed25519".equals(publicKey.getAlgorithm()) || "EdDSA".equals(publicKey.getAlgorithm()) && publicKey.toString().indexOf("Ed25519") >= 0)) {
            throw new TlsFatalAlert(46, "Public key not Ed25519");
        }
        return publicKey;
    }

    PublicKey getPubKeyEd448() throws IOException {
        PublicKey publicKey = this.getPublicKey();
        if (!("Ed448".equals(publicKey.getAlgorithm()) || "EdDSA".equals(publicKey.getAlgorithm()) && publicKey.toString().indexOf("Ed448") >= 0)) {
            throw new TlsFatalAlert(46, "Public key not Ed448");
        }
        return publicKey;
    }

    PublicKey getPubKeyRSA() throws IOException {
        return this.getPublicKey();
    }

    PublicKey getPubKeyMLDSA() throws IOException {
        return this.getPublicKey();
    }

    public short getLegacySignatureAlgorithm() throws IOException {
        PublicKey publicKey = this.getPublicKey();
        if (!this.supportsKeyUsageBit(0)) {
            return -1;
        }
        if (publicKey instanceof RSAPublicKey) {
            return 1;
        }
        if (publicKey instanceof DSAPublicKey) {
            return 2;
        }
        if (publicKey instanceof ECPublicKey) {
            return 3;
        }
        return -1;
    }

    public boolean supportsSignatureAlgorithm(short signatureAlgorithm) throws IOException {
        if (!this.supportsKeyUsageBit(0)) {
            return false;
        }
        return this.implSupportsSignatureAlgorithm(signatureAlgorithm);
    }

    public boolean supportsSignatureAlgorithmCA(short signatureAlgorithm) throws IOException {
        return this.implSupportsSignatureAlgorithm(signatureAlgorithm);
    }

    public TlsCertificate checkUsageInRole(int tlsCertificateRole) throws IOException {
        switch (tlsCertificateRole) {
            case 1: {
                this.validateKeyUsageBit(4);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 2: {
                this.validateKeyUsageBit(4);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected boolean implSupportsSignatureAlgorithm(short signatureAlgorithm) throws IOException {
        PublicKey publicKey = this.getPublicKey();
        switch (signatureAlgorithm) {
            case 1: {
                return this.supportsRSA_PKCS1() && publicKey instanceof RSAPublicKey;
            }
            case 2: {
                return publicKey instanceof DSAPublicKey;
            }
            case 3: 
            case 26: 
            case 27: 
            case 28: {
                return publicKey instanceof ECPublicKey;
            }
            case 7: {
                return "Ed25519".equals(publicKey.getAlgorithm());
            }
            case 8: {
                return "Ed448".equals(publicKey.getAlgorithm());
            }
            case 4: 
            case 5: 
            case 6: {
                return this.supportsRSA_PSS_RSAE() && publicKey instanceof RSAPublicKey;
            }
            case 9: 
            case 10: 
            case 11: {
                return this.supportsRSA_PSS_PSS(signatureAlgorithm) && publicKey instanceof RSAPublicKey;
            }
        }
        return false;
    }

    protected PublicKey getPublicKey() throws IOException {
        try {
            return this.certificate.getPublicKey();
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(42, (Throwable)e);
        }
    }

    protected SubjectPublicKeyInfo getSubjectPublicKeyInfo() throws IOException {
        return SubjectPublicKeyInfo.getInstance((Object)this.getPublicKey().getEncoded());
    }

    public X509Certificate getX509Certificate() {
        return this.certificate;
    }

    protected boolean supportsKeyUsageBit(int keyUsageBit) {
        boolean[] keyUsage = this.certificate.getKeyUsage();
        return null == keyUsage || keyUsage.length > keyUsageBit && keyUsage[keyUsageBit];
    }

    protected boolean supportsRSA_PKCS1() throws IOException {
        AlgorithmIdentifier pubKeyAlgID = this.getSubjectPublicKeyInfo().getAlgorithm();
        return org.bouncycastle.tls.crypto.impl.RSAUtil.supportsPKCS1(pubKeyAlgID);
    }

    protected boolean supportsRSA_PSS_PSS(short signatureAlgorithm) throws IOException {
        AlgorithmIdentifier pubKeyAlgID = this.getSubjectPublicKeyInfo().getAlgorithm();
        return org.bouncycastle.tls.crypto.impl.RSAUtil.supportsPSS_PSS(signatureAlgorithm, pubKeyAlgID);
    }

    protected boolean supportsRSA_PSS_RSAE() throws IOException {
        AlgorithmIdentifier pubKeyAlgID = this.getSubjectPublicKeyInfo().getAlgorithm();
        return org.bouncycastle.tls.crypto.impl.RSAUtil.supportsPSS_RSAE(pubKeyAlgID);
    }

    protected void validateKeyUsageBit(int keyUsageBit) throws IOException {
        if (!this.supportsKeyUsageBit(keyUsageBit)) {
            switch (keyUsageBit) {
                case 128: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow digital signatures");
                }
                case 8: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow key agreement");
                }
                case 32: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow key encipherment");
                }
            }
            throw new TlsFatalAlert(80);
        }
    }

    protected void validateRSA_PKCS1() throws IOException {
        if (!this.supportsRSA_PKCS1()) {
            throw new TlsFatalAlert(46, "No support for rsa_pkcs1 signature schemes");
        }
    }

    protected void validateRSA_PSS_PSS(short signatureAlgorithm) throws IOException {
        if (!this.supportsRSA_PSS_PSS(signatureAlgorithm)) {
            throw new TlsFatalAlert(46, "No support for rsa_pss_pss signature schemes");
        }
    }

    protected void validateRSA_PSS_RSAE() throws IOException {
        if (!this.supportsRSA_PSS_RSAE()) {
            throw new TlsFatalAlert(46, "No support for rsa_pss_rsae signature schemes");
        }
    }
}

