/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKemDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.KemUtil;

public class JceTlsMLKem
implements TlsAgreement {
    protected final JceTlsMLKemDomain domain;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected TlsSecret secret;

    public JceTlsMLKem(JceTlsMLKemDomain domain) {
        this.domain = domain;
    }

    public byte[] generateEphemeral() throws IOException {
        if (this.domain.isServer()) {
            SecretKeyWithEncapsulation encap = this.domain.encapsulate(this.publicKey);
            this.publicKey = null;
            this.secret = this.domain.adoptLocalSecret(encap.getEncoded());
            return encap.getEncapsulation();
        }
        KeyPair kp = this.domain.generateKeyPair();
        this.privateKey = kp.getPrivate();
        return KemUtil.encodePublicKey(kp.getPublic());
    }

    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (this.domain.isServer()) {
            this.publicKey = this.domain.decodePublicKey(peerValue);
        } else {
            this.secret = this.domain.decapsulate(this.privateKey, peerValue);
            this.privateKey = null;
        }
    }

    public TlsSecret calculateSecret() throws IOException {
        TlsSecret secret = this.secret;
        this.secret = null;
        return secret;
    }
}

