/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESCFBModePacketCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESNativeCFBPacketCipher
implements AESCFBModePacketCipher {
    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        this.checkCFBParameter(cipherParameters);
        return AESNativeCFBPacketCipher.getOutputSize(n);
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        int n4;
        byte[] byArray3;
        ParametersWithIV parametersWithIV;
        if (cipherParameters instanceof ParametersWithIV) {
            parametersWithIV = (ParametersWithIV)cipherParameters;
            if (parametersWithIV.getParameters() == null) {
                throw new IllegalArgumentException("CFB cipher unitialized");
            }
            byArray3 = ((KeyParameter)parametersWithIV.getParameters()).getKey();
        } else {
            throw new IllegalArgumentException("CFB cipher unitialized");
        }
        byte[] byArray4 = (byte[])parametersWithIV.getIV().clone();
        try {
            n4 = AESNativeCFBPacketCipher.processPacket(bl, byArray3, byArray4, byArray, n, n2, byArray2, n3, byArray2.length - n3);
        }
        catch (Exception exception) {
            throw PacketCipherException.from(exception);
        }
        return n4;
    }

    static native int getOutputSize(int var0);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    public String toString() {
        return "CFB-PS[Native](AES[Native])";
    }
}

