/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.FPREngine;
import org.bouncycastle.pqc.crypto.falcon.FalconFPR;
import org.bouncycastle.pqc.crypto.falcon.FalconRNG;
import org.bouncycastle.pqc.crypto.falcon.SamplerCtx;

class SamplerZ {
    FPREngine fpr = new FPREngine();

    SamplerZ() {
    }

    int sample(SamplerCtx ctx, FalconFPR mu, FalconFPR iSigma) {
        return this.sampler(ctx, mu, iSigma);
    }

    int gaussian0_sampler(FalconRNG p) {
        int[] dist = new int[]{10745844, 3068844, 3741698, 5559083, 1580863, 8248194, 2260429, 13669192, 2736639, 708981, 4421575, 10046180, 169348, 7122675, 4136815, 30538, 13063405, 7650655, 4132, 14505003, 7826148, 417, 16768101, 11363290, 31, 8444042, 8086568, 1, 12844466, 265321, 0, 1232676, 13644283, 0, 38047, 9111839, 0, 870, 6138264, 0, 14, 12545723, 0, 0, 3104126, 0, 0, 28824, 0, 0, 198, 0, 0, 1};
        long lo = p.prng_get_u64();
        int hi = p.prng_get_u8() & 0xFF;
        int v0 = (int)lo & 0xFFFFFF;
        int v1 = (int)(lo >>> 24) & 0xFFFFFF;
        int v2 = (int)(lo >>> 48) | hi << 16;
        int z = 0;
        for (int u = 0; u < dist.length; u += 3) {
            int w0 = dist[u + 2];
            int w1 = dist[u + 1];
            int w2 = dist[u + 0];
            int cc = v0 - w0 >>> 31;
            cc = v1 - w1 - cc >>> 31;
            cc = v2 - w2 - cc >>> 31;
            z += cc;
        }
        return z;
    }

    int BerExp(FalconRNG p, FalconFPR x, FalconFPR ccs) {
        int w;
        int s = (int)this.fpr.fpr_trunc(this.fpr.fpr_mul(x, this.fpr.fpr_inv_log2));
        FalconFPR r = this.fpr.fpr_sub(x, this.fpr.fpr_mul(this.fpr.fpr_of(s), this.fpr.fpr_log2));
        int sw = s;
        sw ^= (sw ^ 0x3F) & -(63 - sw >>> 31);
        s = sw;
        long z = (this.fpr.fpr_expm_p63(r, ccs) << 1) - 1L >>> s;
        int i = 64;
        while ((w = (p.prng_get_u8() & 0xFF) - ((int)(z >>> (i -= 8)) & 0xFF)) == 0 && i > 0) {
        }
        return w >>> 31;
    }

    int sampler(SamplerCtx ctx, FalconFPR mu, FalconFPR isigma) {
        int z;
        int z0;
        FalconFPR x;
        SamplerCtx spc = ctx;
        int s = (int)this.fpr.fpr_floor(mu);
        FalconFPR r = this.fpr.fpr_sub(mu, this.fpr.fpr_of(s));
        FalconFPR dss = this.fpr.fpr_half(this.fpr.fpr_sqr(isigma));
        FalconFPR ccs = this.fpr.fpr_mul(isigma, spc.sigma_min);
        do {
            z0 = this.gaussian0_sampler(spc.p);
            int b = spc.p.prng_get_u8() & 0xFF & 1;
            z = b + ((b << 1) - 1) * z0;
            x = this.fpr.fpr_mul(this.fpr.fpr_sqr(this.fpr.fpr_sub(this.fpr.fpr_of(z), r)), dss);
        } while (this.BerExp(spc.p, x = this.fpr.fpr_sub(x, this.fpr.fpr_mul(this.fpr.fpr_of(z0 * z0), this.fpr.fpr_inv_2sqrsigma0)), ccs) == 0);
        return s + z;
    }
}

