/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import java.security.SecureRandom;
import org.bouncycastle.pqc.legacy.crypto.sike.Fpx;
import org.bouncycastle.pqc.legacy.crypto.sike.PointProj;
import org.bouncycastle.pqc.legacy.crypto.sike.PointProjFull;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;
import org.bouncycastle.util.Arrays;

class SIDH_Compressed {
    private SIKEEngine engine;
    private static final int t_points = 2;

    public SIDH_Compressed(SIKEEngine engine) {
        this.engine = engine;
    }

    protected void init_basis(long[] gen, long[][] XP, long[][] XQ, long[][] XR) {
        this.engine.fpx.fpcopy(gen, 0, XP[0]);
        this.engine.fpx.fpcopy(gen, this.engine.params.NWORDS_FIELD, XP[1]);
        this.engine.fpx.fpcopy(gen, 2 * this.engine.params.NWORDS_FIELD, XQ[0]);
        this.engine.fpx.fpcopy(gen, 3 * this.engine.params.NWORDS_FIELD, XQ[1]);
        this.engine.fpx.fpcopy(gen, 4 * this.engine.params.NWORDS_FIELD, XR[0]);
        this.engine.fpx.fpcopy(gen, 5 * this.engine.params.NWORDS_FIELD, XR[1]);
    }

    protected void FormatPrivKey_B(byte[] skB) {
        int n = this.engine.params.SECRETKEY_B_BYTES - 2;
        skB[n] = (byte)(skB[n] & this.engine.params.MASK3_BOB);
        int n2 = this.engine.params.SECRETKEY_B_BYTES - 1;
        skB[n2] = (byte)(skB[n2] & this.engine.params.MASK2_BOB);
        this.engine.fpx.mul3(skB);
    }

    protected void random_mod_order_A(byte[] random_digits, SecureRandom random) {
        byte[] temp = new byte[this.engine.params.SECRETKEY_A_BYTES];
        random.nextBytes(temp);
        System.arraycopy(temp, 0, random_digits, 0, this.engine.params.SECRETKEY_A_BYTES);
        random_digits[0] = (byte)(random_digits[0] & 0xFE);
        int n = this.engine.params.SECRETKEY_A_BYTES - 1;
        random_digits[n] = (byte)(random_digits[n] & this.engine.params.MASK_ALICE);
    }

    protected void random_mod_order_B(byte[] random_digits, SecureRandom random) {
        byte[] temp = new byte[this.engine.params.SECRETKEY_B_BYTES];
        random.nextBytes(temp);
        System.arraycopy(temp, 0, random_digits, 0, this.engine.params.SECRETKEY_A_BYTES);
        this.FormatPrivKey_B(random_digits);
    }

    protected void Ladder3pt_dual(PointProj[] Rs, long[] m, int AliceOrBob, PointProj R, long[][] A24) {
        long mask;
        int swap;
        PointProj R0 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj R2 = new PointProj(this.engine.params.NWORDS_FIELD);
        int prevbit = 0;
        int nbits = AliceOrBob == this.engine.params.ALICE ? this.engine.params.OALICE_BITS : this.engine.params.OBOB_BITS;
        this.engine.fpx.fp2copy(Rs[1].X, R0.X);
        this.engine.fpx.fp2copy(Rs[1].Z, R0.Z);
        this.engine.fpx.fp2copy(Rs[2].X, R2.X);
        this.engine.fpx.fp2copy(Rs[2].Z, R2.Z);
        this.engine.fpx.fp2copy(Rs[0].X, R.X);
        this.engine.fpx.fp2copy(Rs[0].Z, R.Z);
        for (int i = 0; i < nbits; ++i) {
            int bit = (int)(m[i >>> 6] >>> (i & 0x3F) & 1L);
            swap = bit ^ prevbit;
            prevbit = bit;
            mask = 0L - (long)swap;
            this.engine.isogeny.swap_points(R, R2, mask);
            this.engine.isogeny.xDBLADD(R0, R2, R.X, A24);
            this.engine.fpx.fp2mul_mont(R2.X, R.Z, R2.X);
        }
        swap = 0 ^ prevbit;
        mask = 0L - (long)swap;
        this.engine.isogeny.swap_points(R, R2, mask);
    }

    protected void Elligator2(long[][] a24, int[] r, int rIndex, long[][] x, byte[] bit, int bitOffset, int COMPorDEC) {
        long[] one_fp = new long[this.engine.params.NWORDS_FIELD];
        long[] a2 = new long[this.engine.params.NWORDS_FIELD];
        long[] b2 = new long[this.engine.params.NWORDS_FIELD];
        long[] N = new long[this.engine.params.NWORDS_FIELD];
        long[] temp0 = new long[this.engine.params.NWORDS_FIELD];
        long[] temp1 = new long[this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] y2 = new long[2][this.engine.params.NWORDS_FIELD];
        int t_ptr = 0;
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, one_fp);
        this.engine.fpx.fp2add(a24, a24, A);
        this.engine.fpx.fpsubPRIME(A[0], one_fp, A[0]);
        this.engine.fpx.fp2add(A, A, A);
        t_ptr = r[rIndex];
        this.engine.fpx.fp2mul_mont(A, this.engine.params.v_3_torsion[t_ptr], x);
        this.engine.fpx.fp2neg(x);
        if (COMPorDEC == 0) {
            int i;
            this.engine.fpx.fp2add(A, x, y2);
            this.engine.fpx.fp2mul_mont(y2, x, y2);
            this.engine.fpx.fpaddPRIME(y2[0], one_fp, y2[0]);
            this.engine.fpx.fp2mul_mont(x, y2, y2);
            this.engine.fpx.fpsqr_mont(y2[0], a2);
            this.engine.fpx.fpsqr_mont(y2[1], b2);
            this.engine.fpx.fpaddPRIME(a2, b2, N);
            this.engine.fpx.fpcopy(N, 0, temp0);
            for (i = 0; i < this.engine.params.OALICE_BITS - 2; ++i) {
                this.engine.fpx.fpsqr_mont(temp0, temp0);
            }
            for (i = 0; i < this.engine.params.OBOB_EXPON; ++i) {
                this.engine.fpx.fpsqr_mont(temp0, temp1);
                this.engine.fpx.fpmul_mont(temp0, temp1, temp0);
            }
            this.engine.fpx.fpsqr_mont(temp0, temp1);
            this.engine.fpx.fpcorrectionPRIME(temp1);
            this.engine.fpx.fpcorrectionPRIME(N);
            if (!Fpx.subarrayEquals(temp1, N, this.engine.params.NWORDS_FIELD)) {
                this.engine.fpx.fp2neg(x);
                this.engine.fpx.fp2sub(x, A, x);
                if (COMPorDEC == 0) {
                    bit[bitOffset] = 1;
                }
            }
        } else if (bit[bitOffset] == 1) {
            this.engine.fpx.fp2neg(x);
            this.engine.fpx.fp2sub(x, A, x);
        }
    }

    protected void make_positive(long[][] x) {
        int nbytes = this.engine.params.NWORDS_FIELD;
        long[] zero = new long[this.engine.params.NWORDS_FIELD];
        this.engine.fpx.from_fp2mont(x, x);
        if (!Fpx.subarrayEquals(x[0], zero, nbytes)) {
            if ((x[0][0] & 1L) == 1L) {
                this.engine.fpx.fp2neg(x);
            }
        } else if ((x[1][0] & 1L) == 1L) {
            this.engine.fpx.fp2neg(x);
        }
        this.engine.fpx.to_fp2mont(x, x);
    }

    protected void BiQuad_affine(long[][] a24, long[][] x0, long[][] x1, PointProj R) {
        long[][] Ap2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] aa = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] bb = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] cc = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(a24, a24, Ap2);
        this.engine.fpx.fp2add(Ap2, Ap2, Ap2);
        this.engine.fpx.fp2sub(x0, x1, aa);
        this.engine.fpx.fp2sqr_mont(aa, aa);
        this.engine.fpx.fp2mul_mont(x0, x1, cc);
        this.engine.fpx.fpsubPRIME(cc[0], this.engine.params.Montgomery_one, cc[0]);
        this.engine.fpx.fp2sqr_mont(cc, cc);
        this.engine.fpx.fpsubPRIME(x0[0], this.engine.params.Montgomery_one, bb[0]);
        this.engine.fpx.fpcopy(x0[1], 0, bb[1]);
        this.engine.fpx.fp2sqr_mont(bb, bb);
        this.engine.fpx.fp2mul_mont(Ap2, x0, t0);
        this.engine.fpx.fp2add(bb, t0, bb);
        this.engine.fpx.fp2mul_mont(x1, bb, bb);
        this.engine.fpx.fpsubPRIME(x1[0], this.engine.params.Montgomery_one, t0[0]);
        this.engine.fpx.fpcopy(x1[1], 0, t0[1]);
        this.engine.fpx.fp2sqr_mont(t0, t0);
        this.engine.fpx.fp2mul_mont(Ap2, x1, t1);
        this.engine.fpx.fp2add(t0, t1, t0);
        this.engine.fpx.fp2mul_mont(x0, t0, t0);
        this.engine.fpx.fp2add(bb, t0, bb);
        this.engine.fpx.fp2add(bb, bb, bb);
        this.engine.fpx.fp2sqr_mont(bb, t0);
        this.engine.fpx.fp2mul_mont(aa, cc, t1);
        this.engine.fpx.fp2add(t1, t1, t1);
        this.engine.fpx.fp2add(t1, t1, t1);
        this.engine.fpx.fp2sub(t0, t1, t0);
        this.engine.fpx.sqrt_Fp2(t0, t0);
        this.make_positive(t0);
        this.engine.fpx.fp2add(bb, t0, R.X);
        this.engine.fpx.fp2add(aa, aa, R.Z);
    }

    protected void get_4_isog_dual(PointProj P, long[][] A24, long[][] C24, long[][][] coeff) {
        this.engine.fpx.fp2sub(P.X, P.Z, coeff[1]);
        this.engine.fpx.fp2add(P.X, P.Z, coeff[2]);
        this.engine.fpx.fp2sqr_mont(P.Z, coeff[4]);
        this.engine.fpx.fp2add(coeff[4], coeff[4], coeff[0]);
        this.engine.fpx.fp2sqr_mont(coeff[0], C24);
        this.engine.fpx.fp2add(coeff[0], coeff[0], coeff[0]);
        this.engine.fpx.fp2sqr_mont(P.X, coeff[3]);
        this.engine.fpx.fp2add(coeff[3], coeff[3], A24);
        this.engine.fpx.fp2sqr_mont(A24, A24);
    }

    protected void eval_dual_2_isog(long[][] X2, long[][] Z2, PointProj P) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(P.X, P.Z, t0);
        this.engine.fpx.fp2sub(P.X, P.Z, P.Z);
        this.engine.fpx.fp2sqr_mont(t0, t0);
        this.engine.fpx.fp2sqr_mont(P.Z, P.Z);
        this.engine.fpx.fp2sub(t0, P.Z, P.Z);
        this.engine.fpx.fp2mul_mont(X2, P.Z, P.Z);
        this.engine.fpx.fp2mul_mont(Z2, t0, P.X);
    }

    protected void eval_final_dual_2_isog(PointProj P) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[] t2 = new long[this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(P.X, P.Z, t0);
        this.engine.fpx.fp2mul_mont(P.X, P.Z, t1);
        this.engine.fpx.fp2sqr_mont(t0, P.X);
        this.engine.fpx.fpcopy(P.X[0], 0, t2);
        this.engine.fpx.fpcopy(P.X[1], 0, P.X[0]);
        this.engine.fpx.fpcopy(t2, 0, P.X[1]);
        this.engine.fpx.fpnegPRIME(P.X[1]);
        this.engine.fpx.fp2add(t1, t1, P.Z);
        this.engine.fpx.fp2add(P.Z, P.Z, P.Z);
    }

    protected void eval_dual_4_isog_shared(long[][] X4pZ4, long[][] X42, long[][] Z42, long[][][] coeff, int coeffOffset) {
        this.engine.fpx.fp2sub(X42, Z42, coeff[0 + coeffOffset]);
        this.engine.fpx.fp2add(X42, Z42, coeff[1 + coeffOffset]);
        this.engine.fpx.fp2sqr_mont(X4pZ4, coeff[2 + coeffOffset]);
        this.engine.fpx.fp2sub(coeff[2 + coeffOffset], coeff[1 + coeffOffset], coeff[2 + coeffOffset]);
    }

    protected void eval_dual_4_isog(long[][] A24, long[][] C24, long[][][] coeff, int coeffOffset, PointProj P) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t3 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(P.X, P.Z, t0);
        this.engine.fpx.fp2sub(P.X, P.Z, t1);
        this.engine.fpx.fp2sqr_mont(t0, t0);
        this.engine.fpx.fp2sqr_mont(t1, t1);
        this.engine.fpx.fp2sub(t0, t1, t2);
        this.engine.fpx.fp2sub(C24, A24, t3);
        this.engine.fpx.fp2mul_mont(t2, t3, t3);
        this.engine.fpx.fp2mul_mont(C24, t0, t2);
        this.engine.fpx.fp2sub(t2, t3, t2);
        this.engine.fpx.fp2mul_mont(t2, t0, P.X);
        this.engine.fpx.fp2mul_mont(t3, t1, P.Z);
        this.engine.fpx.fp2mul_mont(coeff[0 + coeffOffset], P.X, P.X);
        this.engine.fpx.fp2mul_mont(coeff[1 + coeffOffset], P.Z, t0);
        this.engine.fpx.fp2add(P.X, t0, P.X);
        this.engine.fpx.fp2mul_mont(coeff[2 + coeffOffset], P.Z, P.Z);
    }

    protected void eval_full_dual_4_isog(long[][][][] As, PointProj P) {
        for (int i = 0; i < this.engine.params.MAX_Alice; ++i) {
            this.eval_dual_4_isog(As[this.engine.params.MAX_Alice - i][0], As[this.engine.params.MAX_Alice - i][1], As[this.engine.params.MAX_Alice - i - 1], 2, P);
        }
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            this.eval_dual_2_isog(As[this.engine.params.MAX_Alice][2], As[this.engine.params.MAX_Alice][3], P);
        }
        this.eval_final_dual_2_isog(P);
    }

    protected void TripleAndParabola_proj(PointProjFull R, long[][] l1x, long[][] l1z) {
        this.engine.fpx.fp2sqr_mont(R.X, l1z);
        this.engine.fpx.fp2add(l1z, l1z, l1x);
        this.engine.fpx.fp2add(l1x, l1z, l1x);
        this.engine.fpx.fpaddPRIME(l1x[0], this.engine.params.Montgomery_one, l1x[0]);
        this.engine.fpx.fp2add(R.Y, R.Y, l1z);
    }

    protected void Tate3_proj(PointProjFull P, PointProjFull Q, long[][] gX, long[][] gZ) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] l1x = new long[2][this.engine.params.NWORDS_FIELD];
        this.TripleAndParabola_proj(P, l1x, gZ);
        this.engine.fpx.fp2sub(Q.X, P.X, gX);
        this.engine.fpx.fp2mul_mont(l1x, gX, gX);
        this.engine.fpx.fp2sub(P.Y, Q.Y, t0);
        this.engine.fpx.fp2mul_mont(gZ, t0, t0);
        this.engine.fpx.fp2add(gX, t0, gX);
    }

    protected void FinalExpo3(long[][] gX, long[][] gZ) {
        int i;
        long[][] f_ = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2copy(gZ, f_);
        this.engine.fpx.fpnegPRIME(f_[1]);
        this.engine.fpx.fp2mul_mont(gX, f_, f_);
        this.engine.fpx.fp2inv_mont_bingcd(f_);
        this.engine.fpx.fpnegPRIME(gX[1]);
        this.engine.fpx.fp2mul_mont(gX, gZ, gX);
        this.engine.fpx.fp2mul_mont(gX, f_, gX);
        for (i = 0; i < this.engine.params.OALICE_BITS; ++i) {
            this.engine.fpx.fp2sqr_mont(gX, gX);
        }
        for (i = 0; i < this.engine.params.OBOB_EXPON - 1; ++i) {
            this.engine.fpx.cube_Fp2_cycl(gX, this.engine.params.Montgomery_one);
        }
    }

    protected void FinalExpo3_2way(long[][][] gX, long[][][] gZ) {
        int i;
        long[][][] f_ = new long[2][2][this.engine.params.NWORDS_FIELD];
        long[][][] finv = new long[2][2][this.engine.params.NWORDS_FIELD];
        for (i = 0; i < 2; ++i) {
            this.engine.fpx.fp2copy(gZ[i], f_[i]);
            this.engine.fpx.fpnegPRIME(f_[i][1]);
            this.engine.fpx.fp2mul_mont(gX[i], f_[i], f_[i]);
        }
        this.engine.fpx.mont_n_way_inv(f_, 2, finv);
        for (i = 0; i < 2; ++i) {
            int j;
            this.engine.fpx.fpnegPRIME(gX[i][1]);
            this.engine.fpx.fp2mul_mont(gX[i], gZ[i], gX[i]);
            this.engine.fpx.fp2mul_mont(gX[i], finv[i], gX[i]);
            for (j = 0; j < this.engine.params.OALICE_BITS; ++j) {
                this.engine.fpx.fp2sqr_mont(gX[i], gX[i]);
            }
            for (j = 0; j < this.engine.params.OBOB_EXPON - 1; ++j) {
                this.engine.fpx.cube_Fp2_cycl(gX[i], this.engine.params.Montgomery_one);
            }
        }
    }

    private boolean FirstPoint_dual(PointProj P, PointProjFull R, byte[] ind) {
        PointProjFull R3 = new PointProjFull(this.engine.params.NWORDS_FIELD);
        PointProjFull S3 = new PointProjFull(this.engine.params.NWORDS_FIELD);
        long[][][] gX = new long[2][2][this.engine.params.NWORDS_FIELD];
        long[][][] gZ = new long[2][2][this.engine.params.NWORDS_FIELD];
        long[] zero = new long[this.engine.params.NWORDS_FIELD];
        int nbytes = this.engine.params.NWORDS_FIELD;
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 0 * this.engine.params.NWORDS_FIELD, R3.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 1 * this.engine.params.NWORDS_FIELD, R3.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 2 * this.engine.params.NWORDS_FIELD, R3.Y[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 3 * this.engine.params.NWORDS_FIELD, R3.Y[1]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 4 * this.engine.params.NWORDS_FIELD, S3.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 5 * this.engine.params.NWORDS_FIELD, S3.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 6 * this.engine.params.NWORDS_FIELD, S3.Y[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 7 * this.engine.params.NWORDS_FIELD, S3.Y[1]);
        this.engine.isogeny.CompletePoint(P, R);
        this.Tate3_proj(R3, R, gX[0], gZ[0]);
        this.Tate3_proj(S3, R, gX[1], gZ[1]);
        this.FinalExpo3_2way(gX, gZ);
        this.engine.fpx.fp2correction(gX[0]);
        this.engine.fpx.fp2correction(gX[1]);
        int alpha = Fpx.subarrayEquals(gX[0][1], zero, nbytes) ? 0 : (Fpx.subarrayEquals(gX[0][1], this.engine.params.g_R_S_im, nbytes) ? 1 : 2);
        int beta = Fpx.subarrayEquals(gX[1][1], zero, nbytes) ? 0 : (Fpx.subarrayEquals(gX[1][1], this.engine.params.g_R_S_im, nbytes) ? 1 : 2);
        if (alpha == 0 && beta == 0) {
            return false;
        }
        ind[0] = alpha == 0 ? 0 : (beta == 0 ? 1 : (alpha + beta == 3 ? 3 : 2));
        return true;
    }

    private boolean SecondPoint_dual(PointProj P, PointProjFull R, byte[] ind) {
        PointProjFull RS3 = new PointProjFull(this.engine.params.NWORDS_FIELD);
        long[][] gX = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] gZ = new long[2][this.engine.params.NWORDS_FIELD];
        long[] zero = new long[this.engine.params.NWORDS_FIELD];
        int nbytes = this.engine.params.NWORDS_FIELD;
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, (4 * ind[0] + 0) * this.engine.params.NWORDS_FIELD, RS3.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, (4 * ind[0] + 1) * this.engine.params.NWORDS_FIELD, RS3.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, (4 * ind[0] + 2) * this.engine.params.NWORDS_FIELD, RS3.Y[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, (4 * ind[0] + 3) * this.engine.params.NWORDS_FIELD, RS3.Y[1]);
        this.engine.isogeny.CompletePoint(P, R);
        this.Tate3_proj(RS3, R, gX, gZ);
        this.FinalExpo3(gX, gZ);
        this.engine.fpx.fp2correction(gX);
        return !Fpx.subarrayEquals(gX[1], zero, nbytes);
    }

    protected void FirstPoint3n(long[][] a24, long[][][][] As, long[][] x, PointProjFull R, int[] r, byte[] ind, byte[] bitEll) {
        boolean b = false;
        PointProj P = new PointProj(this.engine.params.NWORDS_FIELD);
        long[] zero = new long[this.engine.params.NWORDS_FIELD];
        r[0] = 0;
        while (!b) {
            bitEll[0] = 0;
            this.Elligator2(a24, r, 0, x, bitEll, 0, 0);
            this.engine.fpx.fp2copy(x, P.X);
            this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, P.Z[0]);
            this.engine.fpx.fpcopy(zero, 0, P.Z[1]);
            this.eval_full_dual_4_isog(As, P);
            b = this.FirstPoint_dual(P, R, ind);
            r[0] = r[0] + 1;
        }
    }

    protected void SecondPoint3n(long[][] a24, long[][][][] As, long[][] x, PointProjFull R, int[] r, byte[] ind, byte[] bitEll) {
        boolean b = false;
        PointProj P = new PointProj(this.engine.params.NWORDS_FIELD);
        long[] zero = new long[this.engine.params.NWORDS_FIELD];
        while (!b) {
            bitEll[0] = 0;
            this.Elligator2(a24, r, 1, x, bitEll, 0, 0);
            this.engine.fpx.fp2copy(x, P.X);
            this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, P.Z[0]);
            this.engine.fpx.fpcopy(zero, 0, P.Z[1]);
            this.eval_full_dual_4_isog(As, P);
            b = this.SecondPoint_dual(P, R, ind);
            r[1] = r[1] + 1;
        }
    }

    protected void makeDiff(PointProjFull R, PointProjFull S, PointProj D) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        int nbytes = this.engine.params.NWORDS_FIELD;
        this.engine.fpx.fp2sub(R.X, S.X, t0);
        this.engine.fpx.fp2sub(R.Y, S.Y, t1);
        this.engine.fpx.fp2sqr_mont(t0, t0);
        this.engine.fpx.fp2sqr_mont(t1, t1);
        this.engine.fpx.fp2add(R.X, S.X, t2);
        this.engine.fpx.fp2mul_mont(t0, t2, t2);
        this.engine.fpx.fp2sub(t1, t2, t1);
        this.engine.fpx.fp2mul_mont(D.Z, t1, t1);
        this.engine.fpx.fp2mul_mont(D.X, t0, t0);
        this.engine.fpx.fp2correction(t0);
        this.engine.fpx.fp2correction(t1);
        if (Fpx.subarrayEquals(t0[0], t1[0], nbytes) & Fpx.subarrayEquals(t0[1], t1[1], nbytes)) {
            this.engine.fpx.fp2neg(S.Y);
        }
    }

    protected void BuildOrdinary3nBasis_dual(long[][] a24, long[][][][] As, PointProjFull[] R, int[] r, int[] bitsEll, int bitsEllOffset) {
        PointProj D = new PointProj(this.engine.params.NWORDS_FIELD);
        long[][][] xs = new long[2][2][this.engine.params.NWORDS_FIELD];
        byte[] ind = new byte[1];
        byte[] bit = new byte[1];
        this.FirstPoint3n(a24, As, xs[0], R[0], r, ind, bit);
        bitsEll[bitsEllOffset] = bit[0];
        r[1] = r[0];
        this.SecondPoint3n(a24, As, xs[1], R[1], r, ind, bit);
        int n = bitsEllOffset;
        bitsEll[n] = bitsEll[n] | bit[0] << 1;
        this.BiQuad_affine(a24, xs[0], xs[1], D);
        this.eval_full_dual_4_isog(As, D);
        this.makeDiff(R[0], R[1], D);
    }

    protected void FullIsogeny_A_dual(byte[] PrivateKeyA, long[][][][] As, long[][] a24, int sike) {
        PointProj R = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pts = new PointProj[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][] XPA = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XQA = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XRA = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] C24 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] coeff = new long[5][2][this.engine.params.NWORDS_FIELD];
        int index = 0;
        int npts = 0;
        int ii = 0;
        int[] pts_index = new int[this.engine.params.MAX_INT_POINTS_ALICE];
        long[] SecretKeyA = new long[this.engine.params.NWORDS_ORDER];
        this.init_basis(this.engine.params.A_gen, XPA, XQA, XRA);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, A24[0]);
        this.engine.fpx.fp2add(A24, A24, A24);
        this.engine.fpx.fp2add(A24, A24, C24);
        this.engine.fpx.fp2add(A24, C24, A);
        this.engine.fpx.fp2add(C24, C24, A24);
        this.engine.fpx.decode_to_digits(PrivateKeyA, this.engine.params.MSG_BYTES, SecretKeyA, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(XPA, XQA, XRA, SecretKeyA, this.engine.params.ALICE, R, A);
        this.engine.fpx.fp2inv_mont(R.Z);
        this.engine.fpx.fp2mul_mont(R.X, R.Z, R.X);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, R.Z[0]);
        this.engine.fpx.fpzero(R.Z[1]);
        if (sike == 1) {
            this.engine.fpx.fp2_encode(R.X, PrivateKeyA, this.engine.params.MSG_BYTES + this.engine.params.SECRETKEY_A_BYTES + this.engine.params.CRYPTO_PUBLICKEYBYTES);
        }
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            PointProj S = new PointProj(this.engine.params.NWORDS_FIELD);
            this.engine.isogeny.xDBLe(R, S, A24, C24, this.engine.params.OALICE_BITS - 1);
            this.engine.isogeny.get_2_isog(S, A24, C24);
            this.engine.isogeny.eval_2_isog(R, S);
            this.engine.fpx.fp2copy(S.X, As[this.engine.params.MAX_Alice][2]);
            this.engine.fpx.fp2copy(S.Z, As[this.engine.params.MAX_Alice][3]);
        }
        index = 0;
        for (int row = 1; row < this.engine.params.MAX_Alice; ++row) {
            while (index < this.engine.params.MAX_Alice - row) {
                pts[npts] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(R.X, pts[npts].X);
                this.engine.fpx.fp2copy(R.Z, pts[npts].Z);
                pts_index[npts++] = index;
                int m = this.engine.params.strat_Alice[ii++];
                this.engine.isogeny.xDBLe(R, R, A24, C24, 2 * m);
                index += m;
            }
            this.engine.fpx.fp2copy(A24, As[row - 1][0]);
            this.engine.fpx.fp2copy(C24, As[row - 1][1]);
            this.get_4_isog_dual(R, A24, C24, coeff);
            for (int i = 0; i < npts; ++i) {
                this.engine.isogeny.eval_4_isog(pts[i], coeff);
            }
            this.eval_dual_4_isog_shared(coeff[2], coeff[3], coeff[4], As[row - 1], 2);
            this.engine.fpx.fp2copy(pts[npts - 1].X, R.X);
            this.engine.fpx.fp2copy(pts[npts - 1].Z, R.Z);
            index = pts_index[npts - 1];
            --npts;
        }
        this.engine.fpx.fp2copy(A24, As[this.engine.params.MAX_Alice - 1][0]);
        this.engine.fpx.fp2copy(C24, As[this.engine.params.MAX_Alice - 1][1]);
        this.get_4_isog_dual(R, A24, C24, coeff);
        this.eval_dual_4_isog_shared(coeff[2], coeff[3], coeff[4], As[this.engine.params.MAX_Alice - 1], 2);
        this.engine.fpx.fp2copy(A24, As[this.engine.params.MAX_Alice][0]);
        this.engine.fpx.fp2copy(C24, As[this.engine.params.MAX_Alice][1]);
        this.engine.fpx.fp2inv_mont_bingcd(C24);
        this.engine.fpx.fp2mul_mont(A24, C24, a24);
    }

    protected void Dlogs3_dual(long[][][] f, int[] D, long[] d0, long[] c0, long[] d1, long[] c1) {
        this.solve_dlog(f[0], D, d0, 3);
        this.solve_dlog(f[2], D, c0, 3);
        this.solve_dlog(f[1], D, d1, 3);
        this.solve_dlog(f[3], D, c1, 3);
        this.engine.fpx.mp_sub(this.engine.params.Bob_order, c0, c0, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.mp_sub(this.engine.params.Bob_order, c1, c1, this.engine.params.NWORDS_ORDER);
    }

    protected void BuildOrdinary3nBasis_Decomp_dual(long[][] A24, PointProj[] Rs, int[] r, int[] bitsEll, int bitsEllIndex) {
        byte[] bitEll = new byte[]{(byte)(bitsEll[bitsEllIndex] & 1), (byte)(bitsEll[bitsEllIndex] >>> 1 & 1)};
        r[0] = r[0] - 1;
        this.Elligator2(A24, r, 0, Rs[0].X, bitEll, 0, 1);
        r[1] = r[1] - 1;
        this.Elligator2(A24, r, 1, Rs[1].X, bitEll, 1, 1);
        this.BiQuad_affine(A24, Rs[0].X, Rs[1].X, Rs[2]);
    }

    protected void PKADecompression_dual(byte[] SecretKeyB, byte[] CompressedPKA, PointProj R, long[][] A) {
        int[] rs = new int[3];
        long[][] A24 = new long[2][this.engine.params.NWORDS_FIELD];
        PointProj[] Rs = new PointProj[]{new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD)};
        long[] t1 = new long[this.engine.params.NWORDS_ORDER];
        long[] t2 = new long[this.engine.params.NWORDS_ORDER];
        long[] t3 = new long[this.engine.params.NWORDS_ORDER];
        long[] t4 = new long[this.engine.params.NWORDS_ORDER];
        long[] vone = new long[this.engine.params.NWORDS_ORDER];
        long[] temp = new long[this.engine.params.NWORDS_ORDER];
        long[] SKin = new long[this.engine.params.NWORDS_ORDER];
        this.engine.fpx.fp2_decode(CompressedPKA, A, 3 * this.engine.params.ORDER_B_ENCODED_BYTES);
        vone[0] = 1L;
        this.engine.fpx.to_Montgomery_mod_order(vone, vone, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        byte bit = (byte)((CompressedPKA[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] & 0xFF) >> 7);
        byte[] rs_temp = new byte[3];
        System.arraycopy(CompressedPKA, 3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES, rs_temp, 0, 3);
        rs[0] = rs_temp[0] & 0xFFFF;
        rs[1] = rs_temp[1] & 0xFFFF;
        rs[2] = rs_temp[2] & 0xFFFF;
        rs[0] = rs[0] & 0x7F;
        this.engine.fpx.fpaddPRIME(A[0], this.engine.params.Montgomery_one, A24[0]);
        this.engine.fpx.fpcopy(A[1], 0, A24[1]);
        this.engine.fpx.fpaddPRIME(A24[0], this.engine.params.Montgomery_one, A24[0]);
        this.engine.fpx.fp2div2(A24, A24);
        this.engine.fpx.fp2div2(A24, A24);
        this.BuildOrdinary3nBasis_Decomp_dual(A24, Rs, rs, rs, 2);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, Rs[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, Rs[1].Z[0]);
        this.engine.isogeny.swap_points(Rs[0], Rs[1], -((long)bit));
        this.engine.fpx.decode_to_digits(SecretKeyB, 0, SKin, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.to_Montgomery_mod_order(SKin, t1, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.decode_to_digits(CompressedPKA, 0, temp, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.to_Montgomery_mod_order(temp, t2, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.decode_to_digits(CompressedPKA, this.engine.params.ORDER_B_ENCODED_BYTES, temp, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.to_Montgomery_mod_order(temp, t3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.decode_to_digits(CompressedPKA, 2 * this.engine.params.ORDER_B_ENCODED_BYTES, temp, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.to_Montgomery_mod_order(temp, t4, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        if (bit == 0) {
            this.engine.fpx.Montgomery_multiply_mod_order(t1, t3, t3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.mp_add(t3, vone, t3, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.Montgomery_inversion_mod_order_bingcd(t3, t3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
            this.engine.fpx.Montgomery_multiply_mod_order(t1, t4, t4, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.mp_add(t2, t4, t4, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.Montgomery_multiply_mod_order(t3, t4, t3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(t3, t3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.Ladder3pt_dual(Rs, t3, this.engine.params.BOB, R, A24);
        } else {
            this.engine.fpx.Montgomery_multiply_mod_order(t1, t4, t4, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.mp_add(t4, vone, t4, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.Montgomery_inversion_mod_order_bingcd(t4, t4, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
            this.engine.fpx.Montgomery_multiply_mod_order(t1, t3, t3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.mp_add(t2, t3, t3, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.Montgomery_multiply_mod_order(t3, t4, t3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(t3, t3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.Ladder3pt_dual(Rs, t3, this.engine.params.BOB, R, A24);
        }
        this.engine.isogeny.Double(R, R, A24, this.engine.params.OALICE_BITS);
    }

    protected void Compress_PKA_dual(long[] d0, long[] c0, long[] d1, long[] c1, long[][] a24, int[] rs, byte[] CompressedPKA) {
        long[] temp = new long[this.engine.params.NWORDS_ORDER];
        long[] inv = new long[this.engine.params.NWORDS_ORDER];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(a24, a24, A);
        this.engine.fpx.fp2add(A, A, A);
        this.engine.fpx.fpsubPRIME(A[0], this.engine.params.Montgomery_one, A[0]);
        this.engine.fpx.fpsubPRIME(A[0], this.engine.params.Montgomery_one, A[0]);
        int bit = this.engine.fpx.mod3(d1);
        this.engine.fpx.to_Montgomery_mod_order(c0, c0, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.to_Montgomery_mod_order(c1, c1, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.to_Montgomery_mod_order(d0, d0, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.to_Montgomery_mod_order(d1, d1, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        if (bit != 0) {
            this.engine.fpx.Montgomery_inversion_mod_order_bingcd(d1, inv, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
            this.engine.fpx.Montgomery_neg(d0, this.engine.params.Bob_order);
            this.engine.fpx.Montgomery_multiply_mod_order(d0, inv, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(temp, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(temp, CompressedPKA, 0, this.engine.params.ORDER_B_ENCODED_BYTES);
            this.engine.fpx.Montgomery_neg(c1, this.engine.params.Bob_order);
            this.engine.fpx.Montgomery_multiply_mod_order(c1, inv, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(temp, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(temp, CompressedPKA, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.ORDER_B_ENCODED_BYTES);
            this.engine.fpx.Montgomery_multiply_mod_order(c0, inv, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(temp, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(temp, CompressedPKA, 2 * this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.ORDER_B_ENCODED_BYTES);
            CompressedPKA[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = 0;
        } else {
            this.engine.fpx.Montgomery_inversion_mod_order_bingcd(d0, inv, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
            this.engine.fpx.Montgomery_neg(d1, this.engine.params.Bob_order);
            this.engine.fpx.Montgomery_multiply_mod_order(d1, inv, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(temp, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(temp, CompressedPKA, 0, this.engine.params.ORDER_B_ENCODED_BYTES);
            this.engine.fpx.Montgomery_multiply_mod_order(c1, inv, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(temp, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(temp, CompressedPKA, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.ORDER_B_ENCODED_BYTES);
            this.engine.fpx.Montgomery_neg(c0, this.engine.params.Bob_order);
            this.engine.fpx.Montgomery_multiply_mod_order(c0, inv, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(temp, temp, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(temp, CompressedPKA, 2 * this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.ORDER_B_ENCODED_BYTES);
            CompressedPKA[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = -128;
        }
        this.engine.fpx.fp2_encode(A, CompressedPKA, 3 * this.engine.params.ORDER_B_ENCODED_BYTES);
        int n = 3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES;
        CompressedPKA[n] = (byte)(CompressedPKA[n] | (byte)rs[0]);
        CompressedPKA[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1] = (byte)rs[1];
        CompressedPKA[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 2] = (byte)rs[2];
    }

    protected int EphemeralKeyGeneration_A_extended(byte[] PrivateKeyA, byte[] CompressedPKA) {
        int[] rs = new int[3];
        int[] D = new int[this.engine.params.DLEN_3];
        long[][] a24 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][][] As = new long[this.engine.params.MAX_Alice + 1][5][2][this.engine.params.NWORDS_FIELD];
        long[][][] f = new long[4][2][this.engine.params.NWORDS_FIELD];
        long[] c0 = new long[this.engine.params.NWORDS_ORDER];
        long[] d0 = new long[this.engine.params.NWORDS_ORDER];
        long[] c1 = new long[this.engine.params.NWORDS_ORDER];
        long[] d1 = new long[this.engine.params.NWORDS_ORDER];
        PointProjFull[] Rs = new PointProjFull[]{new PointProjFull(this.engine.params.NWORDS_FIELD), new PointProjFull(this.engine.params.NWORDS_FIELD)};
        this.FullIsogeny_A_dual(PrivateKeyA, As, a24, 1);
        this.BuildOrdinary3nBasis_dual(a24, As, Rs, rs, rs, 2);
        this.Tate3_pairings(Rs, f);
        this.Dlogs3_dual(f, D, d0, c0, d1, c1);
        this.Compress_PKA_dual(d0, c0, d1, c1, a24, rs, CompressedPKA);
        return 0;
    }

    int EphemeralSecretAgreement_B(byte[] PrivateKeyB, byte[] PKA, byte[] SharedSecretB) {
        int ii = 0;
        int index = 0;
        int npts = 0;
        int[] pts_index = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[][] A24plus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24minus = new long[2][this.engine.params.NWORDS_FIELD];
        PointProj R = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pts = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        long[][] jinv = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] coeff = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][] param_A = new long[2][this.engine.params.NWORDS_FIELD];
        this.PKADecompression_dual(PrivateKeyB, PKA, R, param_A);
        this.engine.fpx.fp2copy(param_A, A);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, this.engine.params.Montgomery_one, A24minus[0]);
        this.engine.fpx.fp2add(A, A24minus, A24plus);
        this.engine.fpx.fp2sub(A, A24minus, A24minus);
        index = 0;
        for (int row = 1; row < this.engine.params.MAX_Bob; ++row) {
            while (index < this.engine.params.MAX_Bob - row) {
                pts[npts] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(R.X, pts[npts].X);
                this.engine.fpx.fp2copy(R.Z, pts[npts].Z);
                pts_index[npts++] = index;
                int m = this.engine.params.strat_Bob[ii++];
                this.engine.isogeny.xTPLe(R, R, A24minus, A24plus, m);
                index += m;
            }
            this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
            for (int i = 0; i < npts; ++i) {
                this.engine.isogeny.eval_3_isog(pts[i], coeff);
            }
            this.engine.fpx.fp2copy(pts[npts - 1].X, R.X);
            this.engine.fpx.fp2copy(pts[npts - 1].Z, R.Z);
            index = pts_index[npts - 1];
            --npts;
        }
        this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
        this.engine.fpx.fp2add(A24plus, A24minus, A);
        this.engine.fpx.fp2add(A, A, A);
        this.engine.fpx.fp2sub(A24plus, A24minus, A24plus);
        this.engine.isogeny.j_inv(A, A24plus, jinv);
        this.engine.fpx.fp2_encode(jinv, SharedSecretB, 0);
        return 0;
    }

    protected void BuildEntangledXonly(long[][] A, PointProj[] R, byte[] qnr, byte[] ind) {
        long[][] t_ptr;
        long[] s = new long[this.engine.params.NWORDS_FIELD];
        long[][] r = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t = new long[2][this.engine.params.NWORDS_FIELD];
        int t_ptrOffset = 0;
        if (this.engine.fpx.is_sqr_fp2(A, s)) {
            t_ptr = this.engine.params.table_v_qnr;
            qnr[0] = 1;
        } else {
            t_ptr = this.engine.params.table_v_qr;
            qnr[0] = 0;
        }
        ind[0] = 0;
        do {
            this.engine.fpx.fp2mul_mont(A, t_ptr, t_ptrOffset, R[0].X);
            t_ptrOffset += 2;
            this.engine.fpx.fp2neg(R[0].X);
            this.engine.fpx.fp2add(R[0].X, A, t);
            this.engine.fpx.fp2mul_mont(R[0].X, t, t);
            this.engine.fpx.fpaddPRIME(t[0], this.engine.params.Montgomery_one, t[0]);
            this.engine.fpx.fp2mul_mont(R[0].X, t, t);
            ind[0] = (byte)(ind[0] + 1);
        } while (!this.engine.fpx.is_sqr_fp2(t, s));
        ind[0] = (byte)(ind[0] - 1);
        if (qnr[0] == 1) {
            this.engine.fpx.fpcopy(this.engine.params.table_r_qnr[ind[0]], 0, r[0]);
        } else {
            this.engine.fpx.fpcopy(this.engine.params.table_r_qr[ind[0]], 0, r[0]);
        }
        this.engine.fpx.fp2add(R[0].X, A, R[1].X);
        this.engine.fpx.fp2neg(R[1].X);
        this.engine.fpx.fp2sub(R[0].X, R[1].X, R[2].Z);
        this.engine.fpx.fp2sqr_mont(R[2].Z, R[2].Z);
        this.engine.fpx.fpcopy(r[0], 0, r[1]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, r[0], r[0]);
        this.engine.fpx.fp2sqr_mont(r, r);
        this.engine.fpx.fp2mul_mont(t, r, R[2].X);
    }

    protected void RecoverY(long[][] A, PointProj[] xs, PointProjFull[] Rs) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t4 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2mul_mont(xs[2].X, xs[1].Z, t0);
        this.engine.fpx.fp2mul_mont(xs[1].X, xs[2].Z, t1);
        this.engine.fpx.fp2mul_mont(xs[1].X, xs[2].X, t2);
        this.engine.fpx.fp2mul_mont(xs[1].Z, xs[2].Z, t3);
        this.engine.fpx.fp2sqr_mont(xs[1].X, t4);
        this.engine.fpx.fp2sqr_mont(xs[1].Z, Rs[1].X);
        this.engine.fpx.fp2sub(t2, t3, Rs[1].Y);
        this.engine.fpx.fp2mul_mont(xs[1].X, Rs[1].Y, Rs[1].Y);
        this.engine.fpx.fp2add(t4, Rs[1].X, t4);
        this.engine.fpx.fp2mul_mont(xs[2].Z, t4, t4);
        this.engine.fpx.fp2mul_mont(A, t1, Rs[1].X);
        this.engine.fpx.fp2sub(t0, t1, Rs[1].Z);
        this.engine.fpx.fp2mul_mont(Rs[0].X, Rs[1].Z, t0);
        this.engine.fpx.fp2add(t2, Rs[1].X, t1);
        this.engine.fpx.fp2add(t1, t1, t1);
        this.engine.fpx.fp2sub(t0, t1, t0);
        this.engine.fpx.fp2mul_mont(xs[1].Z, t0, t0);
        this.engine.fpx.fp2sub(t0, t4, t0);
        this.engine.fpx.fp2mul_mont(Rs[0].X, t0, t0);
        this.engine.fpx.fp2add(t0, Rs[1].Y, Rs[1].Y);
        this.engine.fpx.fp2mul_mont(Rs[0].Y, t3, t0);
        this.engine.fpx.fp2mul_mont(xs[1].X, t0, Rs[1].X);
        this.engine.fpx.fp2add(Rs[1].X, Rs[1].X, Rs[1].X);
        this.engine.fpx.fp2mul_mont(xs[1].Z, t0, Rs[1].Z);
        this.engine.fpx.fp2add(Rs[1].Z, Rs[1].Z, Rs[1].Z);
        this.engine.fpx.fp2inv_mont_bingcd(Rs[1].Z);
        this.engine.fpx.fp2mul_mont(Rs[1].X, Rs[1].Z, Rs[1].X);
        this.engine.fpx.fp2mul_mont(Rs[1].Y, Rs[1].Z, Rs[1].Y);
    }

    protected void BuildOrdinary2nBasis_dual(long[][] A, long[][][][] Ds, PointProjFull[] Rs, byte[] qnr, byte[] ind) {
        long[] t0 = new long[this.engine.params.NWORDS_FIELD];
        long[][] A6 = new long[2][this.engine.params.NWORDS_FIELD];
        PointProj[] xs = new PointProj[]{new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD)};
        this.BuildEntangledXonly(A, xs, qnr, ind);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, xs[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, xs[1].Z[0]);
        for (int i = 0; i < this.engine.params.MAX_Bob; ++i) {
            this.engine.isogeny.eval_3_isog(xs[0], Ds[this.engine.params.MAX_Bob - 1 - i]);
            this.engine.isogeny.eval_3_isog(xs[1], Ds[this.engine.params.MAX_Bob - 1 - i]);
            this.engine.isogeny.eval_3_isog(xs[2], Ds[this.engine.params.MAX_Bob - 1 - i]);
        }
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, A6[0]);
        this.engine.fpx.fpaddPRIME(A6[0], A6[0], t0);
        this.engine.fpx.fpaddPRIME(t0, t0, A6[0]);
        this.engine.fpx.fpaddPRIME(A6[0], t0, A6[0]);
        this.engine.isogeny.CompleteMPoint(A6, xs[0], Rs[0]);
        this.RecoverY(A6, xs, Rs);
    }

    protected void FullIsogeny_B_dual(byte[] PrivateKeyB, long[][][][] Ds, long[][] A) {
        PointProj R = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj Q3 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pts = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        long[][] XPB = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XQB = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XRB = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24plus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24minus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] coeff = new long[3][2][this.engine.params.NWORDS_FIELD];
        int index = 0;
        int npts = 0;
        int ii = 0;
        int[] pts_index = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[] SecretKeyB = new long[this.engine.params.NWORDS_ORDER];
        this.init_basis(this.engine.params.B_gen, XPB, XQB, XRB);
        this.engine.fpx.fpcopy(this.engine.params.XQB3, 0, Q3.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.XQB3, this.engine.params.NWORDS_FIELD, Q3.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, Q3.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, A24plus[0]);
        this.engine.fpx.fp2add(A24plus, A24plus, A24plus);
        this.engine.fpx.fp2add(A24plus, A24plus, A24minus);
        this.engine.fpx.fp2add(A24plus, A24minus, A);
        this.engine.fpx.fp2add(A24minus, A24minus, A24plus);
        this.engine.fpx.decode_to_digits(PrivateKeyB, 0, SecretKeyB, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(XPB, XQB, XRB, SecretKeyB, this.engine.params.BOB, R, A);
        index = 0;
        for (int row = 1; row < this.engine.params.MAX_Bob; ++row) {
            while (index < this.engine.params.MAX_Bob - row) {
                pts[npts] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(R.X, pts[npts].X);
                this.engine.fpx.fp2copy(R.Z, pts[npts].Z);
                pts_index[npts++] = index;
                int m = this.engine.params.strat_Bob[ii++];
                this.engine.isogeny.xTPLe(R, R, A24minus, A24plus, m);
                index += m;
            }
            this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
            for (int i = 0; i < npts; ++i) {
                this.engine.isogeny.eval_3_isog(pts[i], coeff);
            }
            this.engine.isogeny.eval_3_isog(Q3, coeff);
            this.engine.fpx.fp2sub(Q3.X, Q3.Z, Ds[row - 1][0]);
            this.engine.fpx.fp2add(Q3.X, Q3.Z, Ds[row - 1][1]);
            this.engine.fpx.fp2copy(pts[npts - 1].X, R.X);
            this.engine.fpx.fp2copy(pts[npts - 1].Z, R.Z);
            index = pts_index[npts - 1];
            --npts;
        }
        this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
        this.engine.isogeny.eval_3_isog(Q3, coeff);
        this.engine.fpx.fp2sub(Q3.X, Q3.Z, Ds[this.engine.params.MAX_Bob - 1][0]);
        this.engine.fpx.fp2add(Q3.X, Q3.Z, Ds[this.engine.params.MAX_Bob - 1][1]);
        this.engine.fpx.fp2add(A24plus, A24minus, A);
        this.engine.fpx.fp2sub(A24plus, A24minus, A24plus);
        this.engine.fpx.fp2inv_mont_bingcd(A24plus);
        this.engine.fpx.fp2mul_mont(A24plus, A, A);
        this.engine.fpx.fp2add(A, A, A);
    }

    protected void Dlogs2_dual(long[][][] f, int[] D, long[] d0, long[] c0, long[] d1, long[] c1) {
        this.solve_dlog(f[0], D, d0, 2);
        this.solve_dlog(f[2], D, c0, 2);
        this.solve_dlog(f[1], D, d1, 2);
        this.solve_dlog(f[3], D, c1, 2);
        this.engine.fpx.mp_sub(this.engine.params.Alice_order, c0, c0, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.mp_sub(this.engine.params.Alice_order, c1, c1, this.engine.params.NWORDS_ORDER);
    }

    protected void BuildEntangledXonly_Decomp(long[][] A, PointProj[] R, int qnr, int ind) {
        long[][] r = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t_ptr = qnr == 1 ? this.engine.params.table_v_qnr : this.engine.params.table_v_qr;
        if (ind >= this.engine.params.TABLE_V_LEN / 2) {
            ind = 0;
        }
        this.engine.fpx.fp2mul_mont(A, t_ptr, ind * 2, R[0].X);
        this.engine.fpx.fp2neg(R[0].X);
        this.engine.fpx.fp2add(R[0].X, A, t);
        this.engine.fpx.fp2mul_mont(R[0].X, t, t);
        this.engine.fpx.fpaddPRIME(t[0], this.engine.params.Montgomery_one, t[0]);
        this.engine.fpx.fp2mul_mont(R[0].X, t, t);
        if (qnr == 1) {
            this.engine.fpx.fpcopy(this.engine.params.table_r_qnr[ind], 0, r[0]);
        } else {
            this.engine.fpx.fpcopy(this.engine.params.table_r_qr[ind], 0, r[0]);
        }
        this.engine.fpx.fp2add(R[0].X, A, R[1].X);
        this.engine.fpx.fp2neg(R[1].X);
        this.engine.fpx.fp2sub(R[0].X, R[1].X, R[2].Z);
        this.engine.fpx.fp2sqr_mont(R[2].Z, R[2].Z);
        this.engine.fpx.fpcopy(r[0], 0, r[1]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, r[0], r[0]);
        this.engine.fpx.fp2sqr_mont(r, r);
        this.engine.fpx.fp2mul_mont(t, r, R[2].X);
    }

    protected void PKBDecompression_extended(byte[] SecretKeyA, int SecretKeyAOffset, byte[] CompressedPKB, PointProj R, long[][] A, byte[] tphiBKA_t, int tphiBKA_tOffset) {
        long mask = -1L;
        long[][] A24 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] Adiv2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[] tmp1 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] tmp2 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] inv = new long[this.engine.params.NWORDS_ORDER];
        long[] scal = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] SKin = new long[this.engine.params.NWORDS_ORDER];
        long[] a0 = new long[this.engine.params.NWORDS_ORDER];
        long[] a1 = new long[this.engine.params.NWORDS_ORDER];
        long[] b0 = new long[this.engine.params.NWORDS_ORDER];
        long[] b1 = new long[this.engine.params.NWORDS_ORDER];
        PointProj[] Rs = new PointProj[]{new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD)};
        mask >>>= this.engine.params.MAXBITS_ORDER - this.engine.params.OALICE_BITS;
        this.engine.fpx.fp2_decode(CompressedPKB, A, 4 * this.engine.params.ORDER_A_ENCODED_BYTES);
        int qnr = CompressedPKB[4 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] & 1;
        byte ind = CompressedPKB[4 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1];
        this.BuildEntangledXonly_Decomp(A, Rs, qnr, ind);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, Rs[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, Rs[1].Z[0]);
        this.engine.fpx.fpaddPRIME(A[0], this.engine.params.Montgomery_one, A24[0]);
        this.engine.fpx.fpcopy(A[1], 0, A24[1]);
        this.engine.fpx.fpaddPRIME(A24[0], this.engine.params.Montgomery_one, A24[0]);
        this.engine.fpx.fp2div2(A24, A24);
        this.engine.fpx.fp2div2(A24, A24);
        this.engine.fpx.decode_to_digits(SecretKeyA, SecretKeyAOffset, SKin, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.decode_to_digits(CompressedPKB, 0, a0, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.decode_to_digits(CompressedPKB, this.engine.params.ORDER_A_ENCODED_BYTES, b0, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.decode_to_digits(CompressedPKB, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, a1, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.decode_to_digits(CompressedPKB, 3 * this.engine.params.ORDER_A_ENCODED_BYTES, b1, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        if ((a0[0] & 1L) == 1L) {
            this.engine.fpx.multiply(SKin, b1, tmp1, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(tmp1, b0, tmp1, this.engine.params.NWORDS_ORDER);
            int n = this.engine.params.NWORDS_ORDER - 1;
            tmp1[n] = tmp1[n] & mask;
            this.engine.fpx.multiply(SKin, a1, tmp2, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(tmp2, a0, tmp2, this.engine.params.NWORDS_ORDER);
            int n2 = this.engine.params.NWORDS_ORDER - 1;
            tmp2[n2] = tmp2[n2] & mask;
            this.engine.fpx.inv_mod_orderA(tmp2, inv);
            this.engine.fpx.multiply(tmp1, inv, scal, this.engine.params.NWORDS_ORDER);
            int n3 = this.engine.params.NWORDS_ORDER - 1;
            scal[n3] = scal[n3] & mask;
            this.Ladder3pt_dual(Rs, scal, this.engine.params.ALICE, R, A24);
        } else {
            this.engine.fpx.multiply(SKin, a1, tmp1, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(tmp1, a0, tmp1, this.engine.params.NWORDS_ORDER);
            int n = this.engine.params.NWORDS_ORDER - 1;
            tmp1[n] = tmp1[n] & mask;
            this.engine.fpx.multiply(SKin, b1, tmp2, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(tmp2, b0, tmp2, this.engine.params.NWORDS_ORDER);
            int n4 = this.engine.params.NWORDS_ORDER - 1;
            tmp2[n4] = tmp2[n4] & mask;
            this.engine.fpx.inv_mod_orderA(tmp2, inv);
            this.engine.fpx.multiply(inv, tmp1, scal, this.engine.params.NWORDS_ORDER);
            int n5 = this.engine.params.NWORDS_ORDER - 1;
            scal[n5] = scal[n5] & mask;
            this.engine.isogeny.swap_points(Rs[0], Rs[1], -1L);
            this.Ladder3pt_dual(Rs, scal, this.engine.params.ALICE, R, A24);
        }
        this.engine.fpx.fp2div2(A, Adiv2);
        this.engine.isogeny.xTPLe_fast(R, R, Adiv2, this.engine.params.OBOB_EXPON);
        this.engine.fpx.fp2_encode(R.X, tphiBKA_t, tphiBKA_tOffset);
        this.engine.fpx.fp2_encode(R.Z, tphiBKA_t, tphiBKA_tOffset + this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.encode_to_bytes(inv, tphiBKA_t, tphiBKA_tOffset + 2 * this.engine.params.FP2_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
    }

    protected void Compress_PKB_dual_extended(long[] d0, long[] c0, long[] d1, long[] c1, long[][] A, byte[] qnr, byte[] ind, byte[] CompressedPKB) {
        long mask = -1L;
        long[] tmp = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] D = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] Dinv = new long[2 * this.engine.params.NWORDS_ORDER];
        mask >>>= this.engine.params.MAXBITS_ORDER - this.engine.params.OALICE_BITS;
        this.engine.fpx.multiply(c0, d1, tmp, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.multiply(c1, d0, D, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.Montgomery_neg(D, this.engine.params.Alice_order);
        this.engine.fpx.mp_add(tmp, D, D, this.engine.params.NWORDS_ORDER);
        int n = this.engine.params.NWORDS_ORDER - 1;
        D[n] = D[n] & mask;
        this.engine.fpx.inv_mod_orderA(D, Dinv);
        this.engine.fpx.multiply(d1, Dinv, tmp, this.engine.params.NWORDS_ORDER);
        int n2 = this.engine.params.NWORDS_ORDER - 1;
        tmp[n2] = tmp[n2] & mask;
        this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, 0, this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.Montgomery_neg(d0, this.engine.params.Alice_order);
        this.engine.fpx.multiply(d0, Dinv, tmp, this.engine.params.NWORDS_ORDER);
        int n3 = this.engine.params.NWORDS_ORDER - 1;
        tmp[n3] = tmp[n3] & mask;
        this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.Montgomery_neg(c1, this.engine.params.Alice_order);
        this.engine.fpx.multiply(c1, Dinv, tmp, this.engine.params.NWORDS_ORDER);
        int n4 = this.engine.params.NWORDS_ORDER - 1;
        tmp[n4] = tmp[n4] & mask;
        this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.multiply(c0, Dinv, tmp, this.engine.params.NWORDS_ORDER);
        int n5 = this.engine.params.NWORDS_ORDER - 1;
        tmp[n5] = tmp[n5] & mask;
        this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, 3 * this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.fp2_encode(A, CompressedPKB, 4 * this.engine.params.ORDER_A_ENCODED_BYTES);
        CompressedPKB[4 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = qnr[0];
        CompressedPKB[4 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1] = ind[0];
    }

    protected void PKBDecompression(byte[] SecretKeyA, int SecretKeyAOffset, byte[] CompressedPKB, PointProj R, long[][] A) {
        long mask = -1L;
        long[][] A24 = new long[2][this.engine.params.NWORDS_FIELD];
        long[] tmp1 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] tmp2 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] vone = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] SKin = new long[this.engine.params.NWORDS_ORDER];
        long[] comp_temp = new long[this.engine.params.NWORDS_ORDER];
        PointProj[] Rs = new PointProj[3];
        mask >>>= this.engine.params.MAXBITS_ORDER - this.engine.params.OALICE_BITS;
        vone[0] = 1L;
        this.engine.fpx.fp2_decode(CompressedPKB, A, 3 * this.engine.params.ORDER_A_ENCODED_BYTES);
        int bit = CompressedPKB[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] >>> 7;
        int qnr = CompressedPKB[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] & 1;
        byte ind = CompressedPKB[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1];
        this.BuildEntangledXonly_Decomp(A, Rs, qnr, ind);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, Rs[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, Rs[1].Z[0]);
        this.engine.fpx.fpaddPRIME(A[0], this.engine.params.Montgomery_one, A24[0]);
        this.engine.fpx.fpcopy(A[1], 0, A24[1]);
        this.engine.fpx.fpaddPRIME(A24[0], this.engine.params.Montgomery_one, A24[0]);
        this.engine.fpx.fp2div2(A24, A24);
        this.engine.fpx.fp2div2(A24, A24);
        this.engine.fpx.decode_to_digits(SecretKeyA, SecretKeyAOffset, SKin, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.swap_points(Rs[0], Rs[1], 0L - (long)bit);
        if (bit == 0) {
            this.engine.fpx.decode_to_digits(CompressedPKB, this.engine.params.ORDER_A_ENCODED_BYTES, comp_temp, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(SKin, comp_temp, tmp1, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(tmp1, vone, tmp1, this.engine.params.NWORDS_ORDER);
            int n = this.engine.params.NWORDS_ORDER - 1;
            tmp1[n] = tmp1[n] & mask;
            this.engine.fpx.inv_mod_orderA(tmp1, tmp2);
            this.engine.fpx.decode_to_digits(CompressedPKB, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, comp_temp, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(SKin, comp_temp, tmp1, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.decode_to_digits(CompressedPKB, 0, comp_temp, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(comp_temp, tmp1, tmp1, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(tmp1, tmp2, vone, this.engine.params.NWORDS_ORDER);
            int n2 = this.engine.params.NWORDS_ORDER - 1;
            vone[n2] = vone[n2] & mask;
            this.Ladder3pt_dual(Rs, vone, this.engine.params.ALICE, R, A24);
        } else {
            this.engine.fpx.decode_to_digits(CompressedPKB, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, comp_temp, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(SKin, comp_temp, tmp1, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(tmp1, vone, tmp1, this.engine.params.NWORDS_ORDER);
            int n = this.engine.params.NWORDS_ORDER - 1;
            tmp1[n] = tmp1[n] & mask;
            this.engine.fpx.inv_mod_orderA(tmp1, tmp2);
            this.engine.fpx.decode_to_digits(CompressedPKB, this.engine.params.ORDER_A_ENCODED_BYTES, comp_temp, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(SKin, comp_temp, tmp1, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.decode_to_digits(CompressedPKB, 0, comp_temp, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(comp_temp, tmp1, tmp1, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(tmp1, tmp2, vone, this.engine.params.NWORDS_ORDER);
            int n3 = this.engine.params.NWORDS_ORDER - 1;
            vone[n3] = vone[n3] & mask;
            this.Ladder3pt_dual(Rs, vone, this.engine.params.ALICE, R, A24);
        }
        this.engine.fpx.fp2div2(A, A24);
        this.engine.isogeny.xTPLe_fast(R, R, A24, this.engine.params.OBOB_EXPON);
    }

    protected void Compress_PKB_dual(long[] d0, long[] c0, long[] d1, long[] c1, long[][] A, byte[] qnr, byte[] ind, byte[] CompressedPKB) {
        long[] tmp = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] inv = new long[this.engine.params.NWORDS_ORDER];
        if ((d1[0] & 1L) == 1L) {
            this.engine.fpx.inv_mod_orderA(d1, inv);
            this.engine.fpx.Montgomery_neg(d0, this.engine.params.Alice_order);
            this.engine.fpx.multiply(d0, inv, tmp, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, 0, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n = this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            CompressedPKB[n] = (byte)(CompressedPKB[n] & this.engine.params.MASK_ALICE);
            this.engine.fpx.Montgomery_neg(c1, this.engine.params.Alice_order);
            this.engine.fpx.multiply(c1, inv, tmp, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n2 = 2 * this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            CompressedPKB[n2] = (byte)(CompressedPKB[n2] & this.engine.params.MASK_ALICE);
            this.engine.fpx.multiply(c0, inv, tmp, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n3 = 3 * this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            CompressedPKB[n3] = (byte)(CompressedPKB[n3] & this.engine.params.MASK_ALICE);
            CompressedPKB[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = 0;
        } else {
            this.engine.fpx.inv_mod_orderA(d0, inv);
            this.engine.fpx.Montgomery_neg(d1, this.engine.params.Alice_order);
            this.engine.fpx.multiply(d1, inv, tmp, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, 0, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n = this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            CompressedPKB[n] = (byte)(CompressedPKB[n] & this.engine.params.MASK_ALICE);
            this.engine.fpx.multiply(c1, inv, tmp, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n4 = 2 * this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            CompressedPKB[n4] = (byte)(CompressedPKB[n4] & this.engine.params.MASK_ALICE);
            this.engine.fpx.Montgomery_neg(c0, this.engine.params.Alice_order);
            this.engine.fpx.multiply(c0, inv, tmp, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(tmp, CompressedPKB, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n5 = 3 * this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            CompressedPKB[n5] = (byte)(CompressedPKB[n5] & this.engine.params.MASK_ALICE);
            CompressedPKB[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = -128;
        }
        this.engine.fpx.fp2_encode(A, CompressedPKB, 3 * this.engine.params.ORDER_A_ENCODED_BYTES);
        int n = 3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES;
        CompressedPKB[n] = (byte)(CompressedPKB[n] | qnr[0]);
        CompressedPKB[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1] = ind[0];
        CompressedPKB[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 2] = 0;
    }

    protected int EphemeralKeyGeneration_B_extended(byte[] PrivateKeyB, byte[] CompressedPKB, int sike) {
        byte[] qnr = new byte[1];
        byte[] ind = new byte[1];
        int[] D = new int[this.engine.params.DLEN_2];
        long[] c0 = new long[this.engine.params.NWORDS_ORDER];
        long[] d0 = new long[this.engine.params.NWORDS_ORDER];
        long[] c1 = new long[this.engine.params.NWORDS_ORDER];
        long[] d1 = new long[this.engine.params.NWORDS_ORDER];
        long[][][][] Ds = new long[this.engine.params.MAX_Bob][2][2][this.engine.params.NWORDS_FIELD];
        long[][][] f = new long[4][2][this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        PointProjFull[] Rs = new PointProjFull[]{new PointProjFull(this.engine.params.NWORDS_FIELD), new PointProjFull(this.engine.params.NWORDS_FIELD)};
        PointProj Pw = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj Qw = new PointProj(this.engine.params.NWORDS_FIELD);
        this.FullIsogeny_B_dual(PrivateKeyB, Ds, A);
        this.BuildOrdinary2nBasis_dual(A, Ds, Rs, qnr, ind);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, Rs[0].X[0], Rs[0].X[0]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, Rs[0].X[0], Rs[0].X[0]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, Rs[1].X[0], Rs[1].X[0]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, Rs[1].X[0], Rs[1].X[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 0 * this.engine.params.NWORDS_FIELD, Pw.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 1 * this.engine.params.NWORDS_FIELD, Pw.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 2 * this.engine.params.NWORDS_FIELD, Pw.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 3 * this.engine.params.NWORDS_FIELD, Pw.Z[1]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 4 * this.engine.params.NWORDS_FIELD, Qw.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 5 * this.engine.params.NWORDS_FIELD, Qw.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 6 * this.engine.params.NWORDS_FIELD, Qw.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 7 * this.engine.params.NWORDS_FIELD, Qw.Z[1]);
        this.Tate2_pairings(Pw, Qw, Rs, f);
        this.engine.fpx.fp2correction(f[0]);
        this.engine.fpx.fp2correction(f[1]);
        this.engine.fpx.fp2correction(f[2]);
        this.engine.fpx.fp2correction(f[3]);
        this.Dlogs2_dual(f, D, d0, c0, d1, c1);
        if (sike == 1) {
            this.Compress_PKB_dual_extended(d0, c0, d1, c1, A, qnr, ind, CompressedPKB);
        } else {
            this.Compress_PKB_dual(d0, c0, d1, c1, A, qnr, ind, CompressedPKB);
        }
        return 0;
    }

    protected int EphemeralKeyGeneration_B(byte[] PrivateKeyB, byte[] CompressedPKB) {
        return this.EphemeralKeyGeneration_B_extended(PrivateKeyB, CompressedPKB, 0);
    }

    protected int EphemeralSecretAgreement_A_extended(byte[] PrivateKeyA, int PrivateKeyAOffset, byte[] PKB, byte[] SharedSecretA, int sike) {
        int ii = 0;
        int index = 0;
        int npts = 0;
        int[] pts_index = new int[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][] A24plus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] C24 = new long[2][this.engine.params.NWORDS_FIELD];
        PointProj R = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pts = new PointProj[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][] jinv = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] param_A = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] coeff = new long[5][2][this.engine.params.NWORDS_FIELD];
        if (sike == 1) {
            this.PKBDecompression_extended(PrivateKeyA, PrivateKeyAOffset, PKB, R, param_A, SharedSecretA, this.engine.params.FP2_ENCODED_BYTES);
        } else {
            this.PKBDecompression(PrivateKeyA, PrivateKeyAOffset, PKB, R, param_A);
        }
        this.engine.fpx.fp2copy(param_A, A);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, this.engine.params.Montgomery_one, C24[0]);
        this.engine.fpx.fp2add(A, C24, A24plus);
        this.engine.fpx.fpaddPRIME(C24[0], C24[0], C24[0]);
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            PointProj S = new PointProj(this.engine.params.NWORDS_FIELD);
            this.engine.isogeny.xDBLe(R, S, A24plus, C24, this.engine.params.OALICE_BITS - 1);
            this.engine.isogeny.get_2_isog(S, A24plus, C24);
            this.engine.isogeny.eval_2_isog(R, S);
        }
        index = 0;
        for (int row = 1; row < this.engine.params.MAX_Alice; ++row) {
            while (index < this.engine.params.MAX_Alice - row) {
                pts[npts] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(R.X, pts[npts].X);
                this.engine.fpx.fp2copy(R.Z, pts[npts].Z);
                pts_index[npts++] = index;
                int m = this.engine.params.strat_Alice[ii++];
                this.engine.isogeny.xDBLe(R, R, A24plus, C24, 2 * m);
                index += m;
            }
            this.engine.isogeny.get_4_isog(R, A24plus, C24, coeff);
            for (int i = 0; i < npts; ++i) {
                this.engine.isogeny.eval_4_isog(pts[i], coeff);
            }
            this.engine.fpx.fp2copy(pts[npts - 1].X, R.X);
            this.engine.fpx.fp2copy(pts[npts - 1].Z, R.Z);
            index = pts_index[npts - 1];
            --npts;
        }
        this.engine.isogeny.get_4_isog(R, A24plus, C24, coeff);
        this.engine.fpx.fp2add(A24plus, A24plus, A24plus);
        this.engine.fpx.fp2sub(A24plus, C24, A24plus);
        this.engine.fpx.fp2add(A24plus, A24plus, A24plus);
        this.engine.isogeny.j_inv(A24plus, C24, jinv);
        this.engine.fpx.fp2_encode(jinv, SharedSecretA, 0);
        return 0;
    }

    int EphemeralSecretAgreement_A(byte[] PrivateKeyA, int PrivateKeyAOffset, byte[] PKB, byte[] SharedSecretA) {
        return this.EphemeralSecretAgreement_A_extended(PrivateKeyA, PrivateKeyAOffset, PKB, SharedSecretA, 0);
    }

    protected byte validate_ciphertext(byte[] ephemeralsk_, byte[] CompressedPKB, byte[] xKA, int xKAOffset, byte[] tphiBKA_t, int tphiBKA_tOffset) {
        PointProj[] phis = new PointProj[3];
        PointProj[] pts = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        phis[0] = new PointProj(this.engine.params.NWORDS_FIELD);
        phis[1] = new PointProj(this.engine.params.NWORDS_FIELD);
        phis[2] = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj R = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj S = new PointProj(this.engine.params.NWORDS_FIELD);
        long[][] XPB = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XQB = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XRB = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24plus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24minus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] comp1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] comp2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] one = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] coeff = new long[3][2][this.engine.params.NWORDS_FIELD];
        int index = 0;
        int npts = 0;
        int ii = 0;
        int[] pts_index = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[] temp = new long[this.engine.params.NWORDS_ORDER];
        long[] sk = new long[this.engine.params.NWORDS_ORDER];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, one[0]);
        this.init_basis(this.engine.params.B_gen, XPB, XQB, XRB);
        this.engine.fpx.fp2_decode(xKA, phis[0].X, xKAOffset);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, phis[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, A24plus[0]);
        this.engine.fpx.fp2add(A24plus, A24plus, A24plus);
        this.engine.fpx.fp2add(A24plus, A24plus, A24minus);
        this.engine.fpx.fp2add(A24plus, A24minus, A);
        this.engine.fpx.fp2add(A24minus, A24minus, A24plus);
        this.engine.fpx.decode_to_digits(ephemeralsk_, 0, sk, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(XPB, XQB, XRB, sk, this.engine.params.BOB, R, A);
        index = 0;
        for (int row = 1; row < this.engine.params.MAX_Bob; ++row) {
            while (index < this.engine.params.MAX_Bob - row) {
                pts[npts] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(R.X, pts[npts].X);
                this.engine.fpx.fp2copy(R.Z, pts[npts].Z);
                pts_index[npts++] = index;
                int m = this.engine.params.strat_Bob[ii++];
                this.engine.isogeny.xTPLe(R, R, A24minus, A24plus, m);
                index += m;
            }
            this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
            for (int i = 0; i < npts; ++i) {
                this.engine.isogeny.eval_3_isog(pts[i], coeff);
            }
            this.engine.isogeny.eval_3_isog(phis[0], coeff);
            this.engine.fpx.fp2copy(pts[npts - 1].X, R.X);
            this.engine.fpx.fp2copy(pts[npts - 1].Z, R.Z);
            index = pts_index[npts - 1];
            --npts;
        }
        this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
        this.engine.isogeny.eval_3_isog(phis[0], coeff);
        this.engine.fpx.fp2_decode(CompressedPKB, A, 4 * this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.fp2_decode(tphiBKA_t, S.X, tphiBKA_tOffset);
        this.engine.fpx.fp2_decode(tphiBKA_t, S.Z, tphiBKA_tOffset + this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.decode_to_digits(tphiBKA_t, tphiBKA_tOffset + 2 * this.engine.params.FP2_ENCODED_BYTES, temp, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.Ladder(phis[0], temp, A, this.engine.params.OALICE_BITS, R);
        this.engine.fpx.fp2mul_mont(R.X, S.Z, comp1);
        this.engine.fpx.fp2mul_mont(R.Z, S.X, comp2);
        return this.engine.fpx.cmp_f2elm(comp1, comp2);
    }

    void solve_dlog(long[][] r, int[] D, long[] d, int ell) {
        if (ell == 2) {
            if (this.engine.params.OALICE_BITS % this.engine.params.W_2 == 0) {
                this.Traverse_w_div_e_fullsigned(r, 0, 0, this.engine.params.PLEN_2 - 1, this.engine.params.ph2_path, this.engine.params.ph2_T, D, this.engine.params.DLEN_2, this.engine.params.ELL2_W, this.engine.params.W_2);
            } else {
                this.Traverse_w_notdiv_e_fullsigned(r, 0, 0, this.engine.params.PLEN_2 - 1, this.engine.params.ph2_path, this.engine.params.ph2_T1, this.engine.params.ph2_T2, D, this.engine.params.DLEN_2, ell, this.engine.params.ELL2_W, this.engine.params.ELL2_EMODW, this.engine.params.W_2, this.engine.params.OALICE_BITS);
            }
            this.from_base(D, d, this.engine.params.DLEN_2, this.engine.params.ELL2_W);
        } else if (ell == 3) {
            if (this.engine.params.OBOB_EXPON % this.engine.params.W_3 == 0) {
                this.Traverse_w_div_e_fullsigned(r, 0, 0, this.engine.params.PLEN_3 - 1, this.engine.params.ph3_path, this.engine.params.ph3_T, D, this.engine.params.DLEN_3, this.engine.params.ELL3_W, this.engine.params.W_3);
            } else {
                this.Traverse_w_notdiv_e_fullsigned(r, 0, 0, this.engine.params.PLEN_3 - 1, this.engine.params.ph3_path, this.engine.params.ph3_T1, this.engine.params.ph3_T2, D, this.engine.params.DLEN_3, ell, this.engine.params.ELL3_W, this.engine.params.ELL3_EMODW, this.engine.params.W_3, this.engine.params.OBOB_EXPON);
            }
            this.from_base(D, d, this.engine.params.DLEN_3, this.engine.params.ELL3_W);
        }
    }

    private void from_base(int[] D, long[] r, int Dlen, int base) {
        long[] ell = new long[this.engine.params.NWORDS_ORDER];
        long[] digit = new long[this.engine.params.NWORDS_ORDER];
        long[] temp = new long[this.engine.params.NWORDS_ORDER];
        ell[0] = base;
        if (D[Dlen - 1] < 0) {
            digit[0] = (long)(-D[Dlen - 1]) * ell[0];
            if ((base & 1) == 0) {
                this.engine.fpx.Montgomery_neg(digit, this.engine.params.Alice_order);
                this.engine.fpx.copy_words(digit, r, this.engine.params.NWORDS_ORDER);
            } else {
                this.engine.fpx.mp_sub(this.engine.params.Bob_order, digit, r, this.engine.params.NWORDS_ORDER);
            }
        } else {
            r[0] = (long)D[Dlen - 1] * ell[0];
        }
        for (int i = Dlen - 2; i >= 1; --i) {
            int ellw = base;
            Arrays.fill(digit, 0L);
            if (D[i] < 0) {
                digit[0] = -D[i];
                if ((base & 1) == 0) {
                    this.engine.fpx.Montgomery_neg(digit, this.engine.params.Alice_order);
                } else {
                    this.engine.fpx.mp_sub(this.engine.params.Bob_order, digit, digit, this.engine.params.NWORDS_ORDER);
                }
            } else {
                digit[0] = D[i];
            }
            this.engine.fpx.mp_add(r, digit, r, this.engine.params.NWORDS_ORDER);
            if ((base & 1) != 0 && !this.engine.fpx.is_orderelm_lt(r, this.engine.params.Bob_order)) {
                this.engine.fpx.mp_sub(r, this.engine.params.Bob_order, r, this.engine.params.NWORDS_ORDER);
            }
            if ((base & 1) == 0) {
                while (ellw > 1) {
                    this.engine.fpx.mp_add(r, r, r, this.engine.params.NWORDS_ORDER);
                    ellw /= 2;
                }
                continue;
            }
            while (ellw > 1) {
                Arrays.fill(temp, 0L);
                this.engine.fpx.mp_add(r, r, temp, this.engine.params.NWORDS_ORDER);
                if (!this.engine.fpx.is_orderelm_lt(temp, this.engine.params.Bob_order)) {
                    this.engine.fpx.mp_sub(temp, this.engine.params.Bob_order, temp, this.engine.params.NWORDS_ORDER);
                }
                this.engine.fpx.mp_add(r, temp, r, this.engine.params.NWORDS_ORDER);
                if (!this.engine.fpx.is_orderelm_lt(r, this.engine.params.Bob_order)) {
                    this.engine.fpx.mp_sub(r, this.engine.params.Bob_order, r, this.engine.params.NWORDS_ORDER);
                }
                ellw /= 3;
            }
        }
        Arrays.fill(digit, 0L);
        if (D[0] < 0) {
            digit[0] = -D[0];
            if ((base & 1) == 0) {
                this.engine.fpx.Montgomery_neg(digit, this.engine.params.Alice_order);
            } else {
                this.engine.fpx.mp_sub(this.engine.params.Bob_order, digit, digit, this.engine.params.NWORDS_ORDER);
            }
        } else {
            digit[0] = D[0];
        }
        this.engine.fpx.mp_add(r, digit, r, this.engine.params.NWORDS_ORDER);
        if ((base & 1) != 0 && !this.engine.fpx.is_orderelm_lt(r, this.engine.params.Bob_order)) {
            this.engine.fpx.mp_sub(r, this.engine.params.Bob_order, r, this.engine.params.NWORDS_ORDER);
        }
    }

    void Traverse_w_notdiv_e_fullsigned(long[][] r, int j, int k, int z, int[] P, long[] CT1, long[] CT2, int[] D, int Dlen, int ell, int ellw, int ell_emodw, int w, int e) {
        long[][] rp = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] alpha = new long[2][this.engine.params.NWORDS_FIELD];
        if (z > 1) {
            int t = P[z];
            this.engine.fpx.fp2copy(r, rp);
            int goleft = j > 0 ? w * (z - t) : e % w + w * (z - t - 1);
            for (int i = 0; i < goleft; ++i) {
                if ((ell & 1) == 0) {
                    this.engine.fpx.sqr_Fp2_cycl(rp, this.engine.params.Montgomery_one);
                    continue;
                }
                this.engine.fpx.cube_Fp2_cycl(rp, this.engine.params.Montgomery_one);
            }
            this.Traverse_w_notdiv_e_fullsigned(rp, j + (z - t), k, t, P, CT1, CT2, D, Dlen, ell, ellw, ell_emodw, w, e);
            this.engine.fpx.fp2copy(r, rp);
            for (int h = k; h < k + t; ++h) {
                if (D[h] == 0) continue;
                if (j > 0) {
                    if (D[h] < 0) {
                        this.engine.fpx.fp2copy(CT2, this.engine.params.NWORDS_FIELD * (2 * (j + h) * (ellw / 2) + 2 * (-D[h] - 1)), alpha);
                        this.engine.fpx.fpnegPRIME(alpha[1]);
                        this.engine.fpx.fp2mul_mont(rp, alpha, rp);
                        continue;
                    }
                    this.engine.fpx.fp2mul_mont(rp, CT2, this.engine.params.NWORDS_FIELD * (2 * ((j + h) * (ellw / 2) + (D[h] - 1))), rp);
                    continue;
                }
                if (D[h] < 0) {
                    this.engine.fpx.fp2copy(CT1, this.engine.params.NWORDS_FIELD * (2 * ((j + h) * (ellw / 2) + (-D[h] - 1))), alpha);
                    this.engine.fpx.fpnegPRIME(alpha[1]);
                    this.engine.fpx.fp2mul_mont(rp, alpha, rp);
                    continue;
                }
                this.engine.fpx.fp2mul_mont(rp, CT1, this.engine.params.NWORDS_FIELD * (2 * ((j + h) * (ellw / 2) + (D[h] - 1))), rp);
            }
            this.Traverse_w_notdiv_e_fullsigned(rp, j, k + t, z - t, P, CT1, CT2, D, Dlen, ell, ellw, ell_emodw, w, e);
        } else {
            this.engine.fpx.fp2copy(r, rp);
            this.engine.fpx.fp2correction(rp);
            if (this.engine.fpx.is_felm_zero(rp[1]) && Fpx.subarrayEquals(rp[0], this.engine.params.Montgomery_one, this.engine.params.NWORDS_FIELD)) {
                D[k] = 0;
            } else if (j != 0 || k != Dlen - 1) {
                for (int t = 1; t <= ellw / 2; ++t) {
                    if (Fpx.subarrayEquals(rp, CT2, this.engine.params.NWORDS_FIELD * (2 * (ellw / 2) * (Dlen - 1) + 2 * (t - 1)), 2 * this.engine.params.NWORDS_FIELD)) {
                        D[k] = -t;
                    } else {
                        this.engine.fpx.fp2copy(CT2, this.engine.params.NWORDS_FIELD * (2 * (ellw / 2 * (Dlen - 1) + (t - 1))), alpha);
                        this.engine.fpx.fpnegPRIME(alpha[1]);
                        this.engine.fpx.fpcorrectionPRIME(alpha[1]);
                        if (!Fpx.subarrayEquals(rp, alpha, 2 * this.engine.params.NWORDS_FIELD)) continue;
                        D[k] = t;
                    }
                    break;
                }
            } else {
                for (int t = 1; t <= ell_emodw / 2; ++t) {
                    if (Fpx.subarrayEquals(rp, CT1, this.engine.params.NWORDS_FIELD * (2 * (ellw / 2) * (Dlen - 1) + 2 * (t - 1)), 2 * this.engine.params.NWORDS_FIELD)) {
                        D[k] = -t;
                    } else {
                        this.engine.fpx.fp2copy(CT1, this.engine.params.NWORDS_FIELD * (2 * (ellw / 2 * (Dlen - 1) + (t - 1))), alpha);
                        this.engine.fpx.fpnegPRIME(alpha[1]);
                        this.engine.fpx.fpcorrectionPRIME(alpha[1]);
                        if (!Fpx.subarrayEquals(rp, alpha, 2 * this.engine.params.NWORDS_FIELD)) continue;
                        D[k] = t;
                    }
                    break;
                }
            }
        }
    }

    void Traverse_w_div_e_fullsigned(long[][] r, int j, int k, int z, int[] P, long[] CT, int[] D, int Dlen, int ellw, int w) {
        long[][] rp = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] alpha = new long[2][this.engine.params.NWORDS_FIELD];
        if (z > 1) {
            int t = P[z];
            this.engine.fpx.fp2copy(r, rp);
            for (int i = 0; i < z - t; ++i) {
                int ii;
                if ((ellw & 1) == 0) {
                    for (ii = 0; ii < w; ++ii) {
                        this.engine.fpx.sqr_Fp2_cycl(rp, this.engine.params.Montgomery_one);
                    }
                    continue;
                }
                for (ii = 0; ii < w; ++ii) {
                    this.engine.fpx.cube_Fp2_cycl(rp, this.engine.params.Montgomery_one);
                }
            }
            this.Traverse_w_div_e_fullsigned(rp, j + (z - t), k, t, P, CT, D, Dlen, ellw, w);
            this.engine.fpx.fp2copy(r, rp);
            for (int h = k; h < k + t; ++h) {
                if (D[h] == 0) continue;
                if (D[h] < 0) {
                    this.engine.fpx.fp2copy(CT, this.engine.params.NWORDS_FIELD * (2 * ((j + h) * (ellw / 2) + (-D[h] - 1))), alpha);
                    this.engine.fpx.fpnegPRIME(alpha[1]);
                    this.engine.fpx.fp2mul_mont(rp, alpha, rp);
                    continue;
                }
                this.engine.fpx.fp2mul_mont(rp, CT, this.engine.params.NWORDS_FIELD * (2 * ((j + h) * (ellw / 2) + (D[h] - 1))), rp);
            }
            this.Traverse_w_div_e_fullsigned(rp, j, k + t, z - t, P, CT, D, Dlen, ellw, w);
        } else {
            this.engine.fpx.fp2copy(r, rp);
            this.engine.fpx.fp2correction(rp);
            if (this.engine.fpx.is_felm_zero(rp[1]) && Fpx.subarrayEquals(rp[0], this.engine.params.Montgomery_one, this.engine.params.NWORDS_FIELD)) {
                D[k] = 0;
            } else {
                for (int t = 1; t <= ellw / 2; ++t) {
                    if (Fpx.subarrayEquals(rp, CT, this.engine.params.NWORDS_FIELD * (2 * ((Dlen - 1) * (ellw / 2) + (t - 1))), 2 * this.engine.params.NWORDS_FIELD)) {
                        D[k] = -t;
                        break;
                    }
                    this.engine.fpx.fp2copy(CT, this.engine.params.NWORDS_FIELD * (2 * ((Dlen - 1) * (ellw / 2) + (t - 1))), alpha);
                    this.engine.fpx.fpnegPRIME(alpha[1]);
                    this.engine.fpx.fpcorrectionPRIME(alpha[1]);
                    if (!Fpx.subarrayEquals(rp, alpha, 2 * this.engine.params.NWORDS_FIELD)) continue;
                    D[k] = t;
                    break;
                }
            }
        }
    }

    private void Tate3_pairings(PointProjFull[] Qj, long[][][] f) {
        int j;
        long[] x = new long[this.engine.params.NWORDS_FIELD];
        long[] y = new long[this.engine.params.NWORDS_FIELD];
        long[] l1 = new long[this.engine.params.NWORDS_FIELD];
        long[] l2 = new long[this.engine.params.NWORDS_FIELD];
        long[] n1 = new long[this.engine.params.NWORDS_FIELD];
        long[] n2 = new long[this.engine.params.NWORDS_FIELD];
        long[] x2 = new long[this.engine.params.NWORDS_FIELD];
        long[] x23 = new long[this.engine.params.NWORDS_FIELD];
        long[] x2p3 = new long[this.engine.params.NWORDS_FIELD];
        long[][][] xQ2s = new long[2][2][this.engine.params.NWORDS_FIELD];
        long[][][] finv = new long[4][2][this.engine.params.NWORDS_FIELD];
        long[][] one = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] g = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] h = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] tf = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, one[0]);
        for (j = 0; j < 2; ++j) {
            this.engine.fpx.fp2copy(one, f[j]);
            this.engine.fpx.fp2copy(one, f[j + 2]);
            this.engine.fpx.fp2sqr_mont(Qj[j].X, xQ2s[j]);
        }
        for (int k = 0; k < this.engine.params.OBOB_EXPON - 1; ++k) {
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * k + 0), l1, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * k + 1), l2, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * k + 2), n1, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * k + 3), n2, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * k + 4), x23, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * k + 5), x2p3, 0, this.engine.params.NWORDS_FIELD);
            for (int j2 = 0; j2 < 2; ++j2) {
                this.engine.fpx.fpmul_mont(Qj[j2].X[0], l1, t0[0]);
                this.engine.fpx.fpmul_mont(Qj[j2].X[1], l1, t0[1]);
                this.engine.fpx.fpmul_mont(Qj[j2].X[0], l2, t2[0]);
                this.engine.fpx.fpmul_mont(Qj[j2].X[1], l2, t2[1]);
                this.engine.fpx.fpaddPRIME(xQ2s[j2][0], x23, t4[0]);
                this.engine.fpx.fpcopy(xQ2s[j2][1], 0, t4[1]);
                this.engine.fpx.fpmul_mont(Qj[j2].X[0], x2p3, t5[0]);
                this.engine.fpx.fpmul_mont(Qj[j2].X[1], x2p3, t5[1]);
                this.engine.fpx.fp2sub(t0, Qj[j2].Y, t1);
                this.engine.fpx.fpaddPRIME(t1[0], n1, t1[0]);
                this.engine.fpx.fp2sub(t2, Qj[j2].Y, t3);
                this.engine.fpx.fpaddPRIME(t3[0], n2, t3[0]);
                this.engine.fpx.fp2mul_mont(t1, t3, g);
                this.engine.fpx.fp2sub(t4, t5, h);
                this.engine.fpx.fp2_conj(h, h);
                this.engine.fpx.fp2mul_mont(g, h, g);
                this.engine.fpx.fp2sqr_mont(f[j2], tf);
                this.engine.fpx.fp2mul_mont(f[j2], tf, f[j2]);
                this.engine.fpx.fp2mul_mont(f[j2], g, f[j2]);
                this.engine.fpx.fpsubPRIME(t0[1], Qj[j2].Y[0], t1[0]);
                this.engine.fpx.fpaddPRIME(t0[0], Qj[j2].Y[1], t1[1]);
                this.engine.fpx.fpnegPRIME(t1[1]);
                this.engine.fpx.fpaddPRIME(t1[1], n1, t1[1]);
                this.engine.fpx.fpsubPRIME(t2[1], Qj[j2].Y[0], t3[0]);
                this.engine.fpx.fpaddPRIME(t2[0], Qj[j2].Y[1], t3[1]);
                this.engine.fpx.fpnegPRIME(t3[1]);
                this.engine.fpx.fpaddPRIME(t3[1], n2, t3[1]);
                this.engine.fpx.fp2mul_mont(t1, t3, g);
                this.engine.fpx.fp2add(t4, t5, h);
                this.engine.fpx.fp2_conj(h, h);
                this.engine.fpx.fp2mul_mont(g, h, g);
                this.engine.fpx.fp2sqr_mont(f[j2 + 2], tf);
                this.engine.fpx.fp2mul_mont(f[j2 + 2], tf, f[j2 + 2]);
                this.engine.fpx.fp2mul_mont(f[j2 + 2], g, f[j2 + 2]);
            }
        }
        for (j = 0; j < 2; ++j) {
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * (this.engine.params.OBOB_EXPON - 1) + 0), x, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * (this.engine.params.OBOB_EXPON - 1) + 1), y, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * (this.engine.params.OBOB_EXPON - 1) + 2), l1, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * (this.engine.params.OBOB_EXPON - 1) + 3), x2, 0, this.engine.params.NWORDS_FIELD);
            this.engine.fpx.fpsubPRIME(Qj[j].X[0], x, t0[0]);
            this.engine.fpx.fpcopy(Qj[j].X[1], 0, t0[1]);
            this.engine.fpx.fpmul_mont(l1, t0[0], t1[0]);
            this.engine.fpx.fpmul_mont(l1, t0[1], t1[1]);
            this.engine.fpx.fp2sub(t1, Qj[j].Y, t2);
            this.engine.fpx.fpaddPRIME(t2[0], y, t2[0]);
            this.engine.fpx.fp2mul_mont(t0, t2, g);
            this.engine.fpx.fpsubPRIME(Qj[j].X[0], x2, h[0]);
            this.engine.fpx.fpcopy(Qj[j].X[1], 0, h[1]);
            this.engine.fpx.fpnegPRIME(h[1]);
            this.engine.fpx.fp2mul_mont(g, h, g);
            this.engine.fpx.fp2sqr_mont(f[j], tf);
            this.engine.fpx.fp2mul_mont(f[j], tf, f[j]);
            this.engine.fpx.fp2mul_mont(f[j], g, f[j]);
            this.engine.fpx.fpaddPRIME(Qj[j].X[0], x, t0[0]);
            this.engine.fpx.fpmul_mont(l1, t0[0], t1[0]);
            this.engine.fpx.fpsubPRIME(Qj[j].Y[0], t1[1], t2[0]);
            this.engine.fpx.fpaddPRIME(Qj[j].Y[1], t1[0], t2[1]);
            this.engine.fpx.fpsubPRIME(t2[1], y, t2[1]);
            this.engine.fpx.fp2mul_mont(t0, t2, g);
            this.engine.fpx.fpaddPRIME(Qj[j].X[0], x2, h[0]);
            this.engine.fpx.fp2mul_mont(g, h, g);
            this.engine.fpx.fp2sqr_mont(f[j + 2], tf);
            this.engine.fpx.fp2mul_mont(f[j + 2], tf, f[j + 2]);
            this.engine.fpx.fp2mul_mont(f[j + 2], g, f[j + 2]);
        }
        this.engine.fpx.mont_n_way_inv(f, 4, finv);
        for (j = 0; j < 4; ++j) {
            this.final_exponentiation_3_torsion(f[j], finv[j], f[j]);
        }
    }

    private void final_exponentiation_3_torsion(long[][] f, long[][] finv, long[][] fout) {
        long[] one = new long[this.engine.params.NWORDS_FIELD];
        long[][] temp = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, one);
        this.engine.fpx.fp2_conj(f, temp);
        this.engine.fpx.fp2mul_mont(temp, finv, temp);
        for (int i = 0; i < this.engine.params.OALICE_BITS; ++i) {
            this.engine.fpx.sqr_Fp2_cycl(temp, one);
        }
        this.engine.fpx.fp2copy(temp, fout);
    }

    private void Tate2_pairings(PointProj P, PointProj Q, PointProjFull[] Qj, long[][][] f) {
        int j;
        int l1Offset;
        long[] l1;
        int k;
        int j2;
        long[][][] finv = new long[4][2][this.engine.params.NWORDS_FIELD];
        long[][] one = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] l1_first = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] g = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] h = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, one[0]);
        for (j2 = 0; j2 < 2; ++j2) {
            this.engine.fpx.fp2copy(one, f[j2]);
            this.engine.fpx.fp2copy(one, f[j2 + 2]);
        }
        long[][] x_first = P.X;
        long[][] y_first = P.Z;
        int x_Offset = 0;
        int y_Offset = 1;
        long[] x_ = this.engine.params.T_tate2_firststep_P;
        long[] y_ = this.engine.params.T_tate2_firststep_P;
        this.engine.fpx.fpcopy(this.engine.params.T_tate2_firststep_P, 2 * this.engine.params.NWORDS_FIELD, l1_first[0]);
        this.engine.fpx.fpcopy(this.engine.params.T_tate2_firststep_P, 3 * this.engine.params.NWORDS_FIELD, l1_first[1]);
        for (j2 = 0; j2 < 2; ++j2) {
            this.engine.fpx.fp2sub(Qj[j2].X, x_first, t0);
            this.engine.fpx.fp2sub(Qj[j2].Y, y_first, t1);
            this.engine.fpx.fp2mul_mont(l1_first, t0, t0);
            this.engine.fpx.fp2sub(t0, t1, g);
            this.engine.fpx.fpsubPRIME(Qj[j2].X[0], this.engine.params.T_tate2_firststep_P, x_Offset, h[0]);
            this.engine.fpx.fpcopy(Qj[j2].X[1], 0, h[1]);
            this.engine.fpx.fpnegPRIME(h[1]);
            this.engine.fpx.fp2mul_mont(g, h, g);
            this.engine.fpx.fp2sqr_mont(f[j2], f[j2]);
            this.engine.fpx.fp2mul_mont(f[j2], g, f[j2]);
        }
        int xOffset = 0;
        int yOffset = 1 * this.engine.params.NWORDS_FIELD;
        long[] x = x_;
        long[] y = y_;
        for (k = 0; k < this.engine.params.OALICE_BITS - 2; ++k) {
            x_ = this.engine.params.T_tate2_P;
            y_ = this.engine.params.T_tate2_P;
            l1 = this.engine.params.T_tate2_P;
            x_Offset = this.engine.params.NWORDS_FIELD * (3 * k + 0);
            y_Offset = this.engine.params.NWORDS_FIELD * (3 * k + 1);
            l1Offset = this.engine.params.NWORDS_FIELD * (3 * k + 2);
            for (j = 0; j < 2; ++j) {
                this.engine.fpx.fpsubPRIME(x, xOffset, Qj[j].X[0], t0[1]);
                this.engine.fpx.fpmul_mont(l1, l1Offset, t0[1], t0[1]);
                this.engine.fpx.fpmul_mont(l1, l1Offset, Qj[j].X[1], t0[0]);
                this.engine.fpx.fpsubPRIME(Qj[j].Y[1], y, yOffset, t1[1]);
                this.engine.fpx.fpsubPRIME(t0[1], t1[1], g[1]);
                this.engine.fpx.fpsubPRIME(t0[0], Qj[j].Y[0], g[0]);
                this.engine.fpx.fpsubPRIME(Qj[j].X[0], x_, x_Offset, h[0]);
                this.engine.fpx.fpcopy(Qj[j].X[1], 0, h[1]);
                this.engine.fpx.fpnegPRIME(h[1]);
                this.engine.fpx.fp2mul_mont(g, h, g);
                this.engine.fpx.fp2sqr_mont(f[j], f[j]);
                this.engine.fpx.fp2mul_mont(f[j], g, f[j]);
            }
            x = x_;
            y = y_;
            yOffset = y_Offset;
            xOffset = x_Offset;
        }
        for (j2 = 0; j2 < 2; ++j2) {
            this.engine.fpx.fpsubPRIME(Qj[j2].X[0], x, xOffset, g[0]);
            this.engine.fpx.fpcopy(Qj[j2].X[1], 0, g[1]);
            this.engine.fpx.fp2sqr_mont(f[j2], f[j2]);
            this.engine.fpx.fp2mul_mont(f[j2], g, f[j2]);
        }
        x_first = Q.X;
        y_first = Q.Z;
        x_ = this.engine.params.T_tate2_firststep_Q;
        y_ = this.engine.params.T_tate2_firststep_Q;
        x_Offset = 0;
        y_Offset = 1 * this.engine.params.NWORDS_FIELD;
        this.engine.fpx.fpcopy(this.engine.params.T_tate2_firststep_Q, 2 * this.engine.params.NWORDS_FIELD, l1_first[0]);
        this.engine.fpx.fpcopy(this.engine.params.T_tate2_firststep_Q, 3 * this.engine.params.NWORDS_FIELD, l1_first[1]);
        for (j2 = 0; j2 < 2; ++j2) {
            this.engine.fpx.fp2sub(Qj[j2].X, x_first, t0);
            this.engine.fpx.fp2sub(Qj[j2].Y, y_first, t1);
            this.engine.fpx.fp2mul_mont(l1_first, t0, t0);
            this.engine.fpx.fp2sub(t0, t1, g);
            this.engine.fpx.fpsubPRIME(Qj[j2].X[0], x_, x_Offset, h[0]);
            this.engine.fpx.fpcopy(Qj[j2].X[1], 0, h[1]);
            this.engine.fpx.fpnegPRIME(h[1]);
            this.engine.fpx.fp2mul_mont(g, h, g);
            this.engine.fpx.fp2sqr_mont(f[j2 + 2], f[j2 + 2]);
            this.engine.fpx.fp2mul_mont(f[j2 + 2], g, f[j2 + 2]);
        }
        x = x_;
        y = y_;
        yOffset = y_Offset;
        xOffset = x_Offset;
        for (k = 0; k < this.engine.params.OALICE_BITS - 2; ++k) {
            x_ = this.engine.params.T_tate2_Q;
            y_ = this.engine.params.T_tate2_Q;
            l1 = this.engine.params.T_tate2_Q;
            x_Offset = this.engine.params.NWORDS_FIELD * (3 * k + 0);
            y_Offset = this.engine.params.NWORDS_FIELD * (3 * k + 1);
            l1Offset = this.engine.params.NWORDS_FIELD * (3 * k + 2);
            for (j = 0; j < 2; ++j) {
                this.engine.fpx.fpsubPRIME(Qj[j].X[0], x, xOffset, t0[0]);
                this.engine.fpx.fpmul_mont(l1, l1Offset, t0[0], t0[0]);
                this.engine.fpx.fpmul_mont(l1, l1Offset, Qj[j].X[1], t0[1]);
                this.engine.fpx.fpsubPRIME(Qj[j].Y[0], y, yOffset, t1[0]);
                this.engine.fpx.fpsubPRIME(t0[0], t1[0], g[0]);
                this.engine.fpx.fpsubPRIME(t0[1], Qj[j].Y[1], g[1]);
                this.engine.fpx.fpsubPRIME(Qj[j].X[0], x_, x_Offset, h[0]);
                this.engine.fpx.fpcopy(Qj[j].X[1], 0, h[1]);
                this.engine.fpx.fpnegPRIME(h[1]);
                this.engine.fpx.fp2mul_mont(g, h, g);
                this.engine.fpx.fp2sqr_mont(f[j + 2], f[j + 2]);
                this.engine.fpx.fp2mul_mont(f[j + 2], g, f[j + 2]);
            }
            x = x_;
            y = y_;
            yOffset = y_Offset;
            xOffset = x_Offset;
        }
        for (j2 = 0; j2 < 2; ++j2) {
            this.engine.fpx.fpsubPRIME(Qj[j2].X[0], x, xOffset, g[0]);
            this.engine.fpx.fpcopy(Qj[j2].X[1], 0, g[1]);
            this.engine.fpx.fp2sqr_mont(f[j2 + 2], f[j2 + 2]);
            this.engine.fpx.fp2mul_mont(f[j2 + 2], g, f[j2 + 2]);
        }
        this.engine.fpx.mont_n_way_inv(f, 4, finv);
        for (j2 = 0; j2 < 4; ++j2) {
            this.final_exponentiation_2_torsion(f[j2], finv[j2], f[j2]);
        }
    }

    private void final_exponentiation_2_torsion(long[][] f, long[][] finv, long[][] fout) {
        long[] one = new long[this.engine.params.NWORDS_FIELD];
        long[][] temp = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, one);
        this.engine.fpx.fp2_conj(f, temp);
        this.engine.fpx.fp2mul_mont(temp, finv, temp);
        for (int i = 0; i < this.engine.params.OBOB_EXPON; ++i) {
            this.engine.fpx.cube_Fp2_cycl(temp, one);
        }
        this.engine.fpx.fp2copy(temp, fout);
    }
}

