/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import org.bouncycastle.pqc.legacy.crypto.sike.PointProj;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;

class SIDH {
    private SIKEEngine engine;

    public SIDH(SIKEEngine engine) {
        this.engine = engine;
    }

    protected void init_basis(long[] gen, long[][] XP, long[][] XQ, long[][] XR) {
        this.engine.fpx.fpcopy(gen, 0, XP[0]);
        this.engine.fpx.fpcopy(gen, this.engine.params.NWORDS_FIELD, XP[1]);
        this.engine.fpx.fpcopy(gen, 2 * this.engine.params.NWORDS_FIELD, XQ[0]);
        this.engine.fpx.fpcopy(gen, 3 * this.engine.params.NWORDS_FIELD, XQ[1]);
        this.engine.fpx.fpcopy(gen, 4 * this.engine.params.NWORDS_FIELD, XR[0]);
        this.engine.fpx.fpcopy(gen, 5 * this.engine.params.NWORDS_FIELD, XR[1]);
    }

    protected void EphemeralKeyGeneration_B(byte[] sk, byte[] pk) {
        PointProj R = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj phiP = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj phiQ = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj phiR = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pts = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        long[][] XPB = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XQB = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XRB = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24plus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24minus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] coeff = new long[3][2][this.engine.params.NWORDS_FIELD];
        int index = 0;
        int npts = 0;
        int ii = 0;
        int[] pts_index = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[] SecretKeyB = new long[this.engine.params.NWORDS_ORDER];
        this.init_basis(this.engine.params.B_gen, XPB, XQB, XRB);
        this.init_basis(this.engine.params.A_gen, phiP.X, phiQ.X, phiR.X);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, phiP.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, phiQ.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, phiR.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, A24plus[0]);
        this.engine.fpx.mp2_add(A24plus, A24plus, A24plus);
        this.engine.fpx.mp2_add(A24plus, A24plus, A24minus);
        this.engine.fpx.mp2_add(A24plus, A24minus, A);
        this.engine.fpx.mp2_add(A24minus, A24minus, A24plus);
        this.engine.fpx.decode_to_digits(sk, this.engine.params.MSG_BYTES, SecretKeyB, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(XPB, XQB, XRB, SecretKeyB, this.engine.params.BOB, R, A);
        index = 0;
        for (int row = 1; row < this.engine.params.MAX_Bob; ++row) {
            while (index < this.engine.params.MAX_Bob - row) {
                pts[npts] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(R.X, pts[npts].X);
                this.engine.fpx.fp2copy(R.Z, pts[npts].Z);
                pts_index[npts++] = index;
                int m = this.engine.params.strat_Bob[ii++];
                this.engine.isogeny.xTPLe(R, R, A24minus, A24plus, m);
                index += m;
            }
            this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
            for (int i = 0; i < npts; ++i) {
                this.engine.isogeny.eval_3_isog(pts[i], coeff);
            }
            this.engine.isogeny.eval_3_isog(phiP, coeff);
            this.engine.isogeny.eval_3_isog(phiQ, coeff);
            this.engine.isogeny.eval_3_isog(phiR, coeff);
            this.engine.fpx.fp2copy(pts[npts - 1].X, R.X);
            this.engine.fpx.fp2copy(pts[npts - 1].Z, R.Z);
            index = pts_index[npts - 1];
            --npts;
        }
        this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
        this.engine.isogeny.eval_3_isog(phiP, coeff);
        this.engine.isogeny.eval_3_isog(phiQ, coeff);
        this.engine.isogeny.eval_3_isog(phiR, coeff);
        this.engine.isogeny.inv_3_way(phiP.Z, phiQ.Z, phiR.Z);
        this.engine.fpx.fp2mul_mont(phiP.X, phiP.Z, phiP.X);
        this.engine.fpx.fp2mul_mont(phiQ.X, phiQ.Z, phiQ.X);
        this.engine.fpx.fp2mul_mont(phiR.X, phiR.Z, phiR.X);
        this.engine.fpx.fp2_encode(phiP.X, pk, 0);
        this.engine.fpx.fp2_encode(phiQ.X, pk, this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.fp2_encode(phiR.X, pk, 2 * this.engine.params.FP2_ENCODED_BYTES);
    }

    protected void EphemeralKeyGeneration_A(byte[] ephemeralsk, byte[] ct) {
        PointProj R = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj phiP = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj phiQ = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj phiR = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pts = new PointProj[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][] XPA = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XQA = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] XRA = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24plus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] C24 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] coeff = new long[3][2][this.engine.params.NWORDS_FIELD];
        int index = 0;
        int npts = 0;
        int ii = 0;
        int[] pts_index = new int[this.engine.params.MAX_INT_POINTS_ALICE];
        long[] SecretKeyA = new long[this.engine.params.NWORDS_ORDER];
        this.init_basis(this.engine.params.A_gen, XPA, XQA, XRA);
        this.init_basis(this.engine.params.B_gen, phiP.X, phiQ.X, phiR.X);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, phiP.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, phiQ.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, phiR.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, A24plus[0]);
        this.engine.fpx.mp2_add(A24plus, A24plus, A24plus);
        this.engine.fpx.mp2_add(A24plus, A24plus, C24);
        this.engine.fpx.mp2_add(A24plus, C24, A);
        this.engine.fpx.mp2_add(C24, C24, A24plus);
        this.engine.fpx.decode_to_digits(ephemeralsk, 0, SecretKeyA, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(XPA, XQA, XRA, SecretKeyA, this.engine.params.ALICE, R, A);
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            PointProj S = new PointProj(this.engine.params.NWORDS_FIELD);
            this.engine.isogeny.xDBLe(R, S, A24plus, C24, this.engine.params.OALICE_BITS - 1);
            this.engine.isogeny.get_2_isog(S, A24plus, C24);
            this.engine.isogeny.eval_2_isog(phiP, S);
            this.engine.isogeny.eval_2_isog(phiQ, S);
            this.engine.isogeny.eval_2_isog(phiR, S);
            this.engine.isogeny.eval_2_isog(R, S);
        }
        index = 0;
        for (int row = 1; row < this.engine.params.MAX_Alice; ++row) {
            while (index < this.engine.params.MAX_Alice - row) {
                pts[npts] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(R.X, pts[npts].X);
                this.engine.fpx.fp2copy(R.Z, pts[npts].Z);
                pts_index[npts++] = index;
                int m = this.engine.params.strat_Alice[ii++];
                this.engine.isogeny.xDBLe(R, R, A24plus, C24, 2 * m);
                index += m;
            }
            this.engine.isogeny.get_4_isog(R, A24plus, C24, coeff);
            for (int i = 0; i < npts; ++i) {
                this.engine.isogeny.eval_4_isog(pts[i], coeff);
            }
            this.engine.isogeny.eval_4_isog(phiP, coeff);
            this.engine.isogeny.eval_4_isog(phiQ, coeff);
            this.engine.isogeny.eval_4_isog(phiR, coeff);
            this.engine.fpx.fp2copy(pts[npts - 1].X, R.X);
            this.engine.fpx.fp2copy(pts[npts - 1].Z, R.Z);
            index = pts_index[npts - 1];
            --npts;
        }
        this.engine.isogeny.get_4_isog(R, A24plus, C24, coeff);
        this.engine.isogeny.eval_4_isog(phiP, coeff);
        this.engine.isogeny.eval_4_isog(phiQ, coeff);
        this.engine.isogeny.eval_4_isog(phiR, coeff);
        this.engine.isogeny.inv_3_way(phiP.Z, phiQ.Z, phiR.Z);
        this.engine.fpx.fp2mul_mont(phiP.X, phiP.Z, phiP.X);
        this.engine.fpx.fp2mul_mont(phiQ.X, phiQ.Z, phiQ.X);
        this.engine.fpx.fp2mul_mont(phiR.X, phiR.Z, phiR.X);
        this.engine.fpx.fp2_encode(phiP.X, ct, 0);
        this.engine.fpx.fp2_encode(phiQ.X, ct, this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.fp2_encode(phiR.X, ct, 2 * this.engine.params.FP2_ENCODED_BYTES);
    }

    protected void EphemeralSecretAgreement_A(byte[] ephemeralsk, byte[] pk, byte[] jinvariant) {
        PointProj R = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pts = new PointProj[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][][] PKB = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][][] coeff = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][] jinv = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24plus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] C24 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        int i = 0;
        int row = 0;
        int m = 0;
        int index = 0;
        int npts = 0;
        int ii = 0;
        int[] pts_index = new int[this.engine.params.MAX_INT_POINTS_ALICE];
        long[] SecretKeyA = new long[this.engine.params.NWORDS_ORDER];
        this.engine.fpx.fp2_decode(pk, PKB[0], 0);
        this.engine.fpx.fp2_decode(pk, PKB[1], this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.fp2_decode(pk, PKB[2], 2 * this.engine.params.FP2_ENCODED_BYTES);
        this.engine.isogeny.get_A(PKB[0], PKB[1], PKB[2], A);
        this.engine.fpx.mp_add(this.engine.params.Montgomery_one, this.engine.params.Montgomery_one, C24[0], this.engine.params.NWORDS_FIELD);
        this.engine.fpx.mp2_add(A, C24, A24plus);
        this.engine.fpx.mp_add(C24[0], C24[0], C24[0], this.engine.params.NWORDS_FIELD);
        this.engine.fpx.decode_to_digits(ephemeralsk, 0, SecretKeyA, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(PKB[0], PKB[1], PKB[2], SecretKeyA, this.engine.params.ALICE, R, A);
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            PointProj S = new PointProj(this.engine.params.NWORDS_FIELD);
            this.engine.isogeny.xDBLe(R, S, A24plus, C24, this.engine.params.OALICE_BITS - 1);
            this.engine.isogeny.get_2_isog(S, A24plus, C24);
            this.engine.isogeny.eval_2_isog(R, S);
        }
        index = 0;
        for (row = 1; row < this.engine.params.MAX_Alice; ++row) {
            while (index < this.engine.params.MAX_Alice - row) {
                pts[npts] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(R.X, pts[npts].X);
                this.engine.fpx.fp2copy(R.Z, pts[npts].Z);
                pts_index[npts++] = index;
                m = this.engine.params.strat_Alice[ii++];
                this.engine.isogeny.xDBLe(R, R, A24plus, C24, 2 * m);
                index += m;
            }
            this.engine.isogeny.get_4_isog(R, A24plus, C24, coeff);
            for (i = 0; i < npts; ++i) {
                this.engine.isogeny.eval_4_isog(pts[i], coeff);
            }
            this.engine.fpx.fp2copy(pts[npts - 1].X, R.X);
            this.engine.fpx.fp2copy(pts[npts - 1].Z, R.Z);
            index = pts_index[npts - 1];
            --npts;
        }
        this.engine.isogeny.get_4_isog(R, A24plus, C24, coeff);
        this.engine.fpx.mp2_add(A24plus, A24plus, A24plus);
        this.engine.fpx.fp2sub(A24plus, C24, A24plus);
        this.engine.fpx.fp2add(A24plus, A24plus, A24plus);
        this.engine.isogeny.j_inv(A24plus, C24, jinv);
        this.engine.fpx.fp2_encode(jinv, jinvariant, 0);
    }

    protected void EphemeralSecretAgreement_B(byte[] sk, byte[] ct, byte[] jinvariant_) {
        PointProj R = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pts = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        long[][][] coeff = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][][] PKB = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][] jinv = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24plus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A24minus = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] A = new long[2][this.engine.params.NWORDS_FIELD];
        int index = 0;
        int npts = 0;
        int ii = 0;
        int[] pts_index = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[] SecretKeyB = new long[this.engine.params.NWORDS_ORDER];
        this.engine.fpx.fp2_decode(ct, PKB[0], 0);
        this.engine.fpx.fp2_decode(ct, PKB[1], this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.fp2_decode(ct, PKB[2], 2 * this.engine.params.FP2_ENCODED_BYTES);
        this.engine.isogeny.get_A(PKB[0], PKB[1], PKB[2], A);
        this.engine.fpx.mp_add(this.engine.params.Montgomery_one, this.engine.params.Montgomery_one, A24minus[0], this.engine.params.NWORDS_FIELD);
        this.engine.fpx.mp2_add(A, A24minus, A24plus);
        this.engine.fpx.mp2_sub_p2(A, A24minus, A24minus);
        this.engine.fpx.decode_to_digits(sk, this.engine.params.MSG_BYTES, SecretKeyB, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(PKB[0], PKB[1], PKB[2], SecretKeyB, this.engine.params.BOB, R, A);
        index = 0;
        for (int row = 1; row < this.engine.params.MAX_Bob; ++row) {
            while (index < this.engine.params.MAX_Bob - row) {
                pts[npts] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(R.X, pts[npts].X);
                this.engine.fpx.fp2copy(R.Z, pts[npts].Z);
                pts_index[npts++] = index;
                int m = this.engine.params.strat_Bob[ii++];
                this.engine.isogeny.xTPLe(R, R, A24minus, A24plus, m);
                index += m;
            }
            this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
            for (int i = 0; i < npts; ++i) {
                this.engine.isogeny.eval_3_isog(pts[i], coeff);
            }
            this.engine.fpx.fp2copy(pts[npts - 1].X, R.X);
            this.engine.fpx.fp2copy(pts[npts - 1].Z, R.Z);
            index = pts_index[npts - 1];
            --npts;
        }
        this.engine.isogeny.get_3_isog(R, A24minus, A24plus, coeff);
        this.engine.fpx.fp2add(A24plus, A24minus, A);
        this.engine.fpx.fp2add(A, A, A);
        this.engine.fpx.fp2sub(A24plus, A24minus, A24plus);
        this.engine.isogeny.j_inv(A, A24plus, jinv);
        this.engine.fpx.fp2_encode(jinv, jinvariant_, 0);
    }
}

