/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntru;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUOWCPA;
import org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.OWCPAKeyPair;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;

public class NTRUKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUKeyGenerationParameters params;
    private SecureRandom random;

    public void init(KeyGenerationParameters param) {
        this.params = (NTRUKeyGenerationParameters)param;
        this.random = param.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUParameterSet parameterSet = this.params.getParameters().parameterSet;
        byte[] seed = new byte[parameterSet.sampleFgBytes()];
        this.random.nextBytes(seed);
        NTRUOWCPA owcpa = new NTRUOWCPA(parameterSet);
        OWCPAKeyPair owcpaKeys = owcpa.keypair(seed);
        byte[] publicKey = owcpaKeys.publicKey;
        byte[] privateKey = new byte[parameterSet.ntruSecretKeyBytes()];
        byte[] owcpaPrivateKey = owcpaKeys.privateKey;
        System.arraycopy(owcpaPrivateKey, 0, privateKey, 0, owcpaPrivateKey.length);
        byte[] prfBytes = new byte[parameterSet.prfKeyBytes()];
        this.random.nextBytes(prfBytes);
        System.arraycopy(prfBytes, 0, privateKey, parameterSet.owcpaSecretKeyBytes(), prfBytes.length);
        return new AsymmetricCipherKeyPair(new NTRUPublicKeyParameters(this.params.getParameters(), publicKey), new NTRUPrivateKeyParameters(this.params.getParameters(), privateKey));
    }
}

