/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.FPREngine;
import org.bouncycastle.pqc.crypto.falcon.FalconCommon;
import org.bouncycastle.pqc.crypto.falcon.FalconFFT;
import org.bouncycastle.pqc.crypto.falcon.FalconFPR;
import org.bouncycastle.pqc.crypto.falcon.SHAKE256;
import org.bouncycastle.pqc.crypto.falcon.SamplerCtx;
import org.bouncycastle.pqc.crypto.falcon.SamplerZ;

class FalconSign {
    FPREngine fpr = new FPREngine();
    FalconFFT fft = new FalconFFT();
    FalconCommon common = new FalconCommon();

    FalconSign() {
    }

    private static int MKN(int logn) {
        return 1 << logn;
    }

    int ffLDL_treesize(int logn) {
        return logn + 1 << logn;
    }

    void ffLDL_fft_inner(FalconFPR[] srctree, int tree, FalconFPR[] srcg0, int g0, FalconFPR[] srcg1, int g1, int logn, FalconFPR[] srctmp, int tmp) {
        int n = FalconSign.MKN(logn);
        if (n == 1) {
            srctree[tree + 0] = srcg0[g0 + 0];
            return;
        }
        int hn = n >> 1;
        this.fft.poly_LDLmv_fft(srctmp, tmp, srctree, tree, srcg0, g0, srcg1, g1, srcg0, g0, logn);
        this.fft.poly_split_fft(srcg1, g1, srcg1, g1 + hn, srcg0, g0, logn);
        this.fft.poly_split_fft(srcg0, g0, srcg0, g0 + hn, srctmp, tmp, logn);
        this.ffLDL_fft_inner(srctree, tree + n, srcg1, g1, srcg1, g1 + hn, logn - 1, srctmp, tmp);
        this.ffLDL_fft_inner(srctree, tree + n + this.ffLDL_treesize(logn - 1), srcg0, g0, srcg0, g0 + hn, logn - 1, srctmp, tmp);
    }

    void ffLDL_fft(FalconFPR[] srctree, int tree, FalconFPR[] srcg00, int g00, FalconFPR[] srcg01, int g01, FalconFPR[] srcg11, int g11, int logn, FalconFPR[] srctmp, int tmp) {
        int n = FalconSign.MKN(logn);
        if (n == 1) {
            srctree[tree + 0] = srcg00[g00 + 0];
            return;
        }
        int hn = n >> 1;
        int d00 = tmp;
        int d11 = tmp + n;
        System.arraycopy(srcg00, g00, srctmp, d00, n);
        this.fft.poly_LDLmv_fft(srctmp, d11, srctree, tree, srcg00, g00, srcg01, g01, srcg11, g11, logn);
        this.fft.poly_split_fft(srctmp, tmp += n << 1, srctmp, tmp + hn, srctmp, d00, logn);
        this.fft.poly_split_fft(srctmp, d00, srctmp, d00 + hn, srctmp, d11, logn);
        System.arraycopy(srctmp, tmp, srctmp, d11, n);
        this.ffLDL_fft_inner(srctree, tree + n, srctmp, d11, srctmp, d11 + hn, logn - 1, srctmp, tmp);
        this.ffLDL_fft_inner(srctree, tree + n + this.ffLDL_treesize(logn - 1), srctmp, d00, srctmp, d00 + hn, logn - 1, srctmp, tmp);
    }

    void ffLDL_binary_normalize(FalconFPR[] srctree, int tree, int orig_logn, int logn) {
        int n = FalconSign.MKN(logn);
        if (n == 1) {
            srctree[tree + 0] = this.fpr.fpr_mul(this.fpr.fpr_sqrt(srctree[tree + 0]), this.fpr.fpr_inv_sigma[orig_logn]);
        } else {
            this.ffLDL_binary_normalize(srctree, tree + n, orig_logn, logn - 1);
            this.ffLDL_binary_normalize(srctree, tree + n + this.ffLDL_treesize(logn - 1), orig_logn, logn - 1);
        }
    }

    void smallints_to_fpr(FalconFPR[] srcr, int r, byte[] srct, int t, int logn) {
        int n = FalconSign.MKN(logn);
        for (int u = 0; u < n; ++u) {
            srcr[r + u] = this.fpr.fpr_of(srct[t + u]);
        }
    }

    int skoff_b00(int logn) {
        return 0;
    }

    int skoff_b01(int logn) {
        return FalconSign.MKN(logn);
    }

    int skoff_b10(int logn) {
        return 2 * FalconSign.MKN(logn);
    }

    int skoff_b11(int logn) {
        return 3 * FalconSign.MKN(logn);
    }

    int skoff_tree(int logn) {
        return 4 * FalconSign.MKN(logn);
    }

    void expand_privkey(FalconFPR[] srcexpanded_key, int expanded_key, byte[] srcf, int f, byte[] srcg, int g, byte[] srcF, int F2, byte[] srcG, int G, int logn, FalconFPR[] srctmp, int tmp) {
        int n = FalconSign.MKN(logn);
        int b00 = expanded_key + this.skoff_b00(logn);
        int b01 = expanded_key + this.skoff_b01(logn);
        int b10 = expanded_key + this.skoff_b10(logn);
        int b11 = expanded_key + this.skoff_b11(logn);
        int tree = expanded_key + this.skoff_tree(logn);
        int rf = b01;
        int rg = b00;
        int rF = b11;
        int rG = b10;
        this.smallints_to_fpr(srcexpanded_key, rf, srcf, f, logn);
        this.smallints_to_fpr(srcexpanded_key, rg, srcg, g, logn);
        this.smallints_to_fpr(srcexpanded_key, rF, srcF, F2, logn);
        this.smallints_to_fpr(srcexpanded_key, rG, srcG, G, logn);
        this.fft.FFT(srcexpanded_key, rf, logn);
        this.fft.FFT(srcexpanded_key, rg, logn);
        this.fft.FFT(srcexpanded_key, rF, logn);
        this.fft.FFT(srcexpanded_key, rG, logn);
        this.fft.poly_neg(srcexpanded_key, rf, logn);
        this.fft.poly_neg(srcexpanded_key, rF, logn);
        int g00 = tmp;
        int g01 = g00 + n;
        int g11 = g01 + n;
        int gxx = g11 + n;
        System.arraycopy(srcexpanded_key, b00, srctmp, g00, n);
        this.fft.poly_mulselfadj_fft(srctmp, g00, logn);
        System.arraycopy(srcexpanded_key, b01, srctmp, gxx, n);
        this.fft.poly_mulselfadj_fft(srctmp, gxx, logn);
        this.fft.poly_add(srctmp, g00, srctmp, gxx, logn);
        System.arraycopy(srcexpanded_key, b00, srctmp, g01, n);
        this.fft.poly_muladj_fft(srctmp, g01, srcexpanded_key, b10, logn);
        System.arraycopy(srcexpanded_key, b01, srctmp, gxx, n);
        this.fft.poly_muladj_fft(srctmp, gxx, srcexpanded_key, b11, logn);
        this.fft.poly_add(srctmp, g01, srctmp, gxx, logn);
        System.arraycopy(srcexpanded_key, b10, srctmp, g11, n);
        this.fft.poly_mulselfadj_fft(srctmp, g11, logn);
        System.arraycopy(srcexpanded_key, b11, srctmp, gxx, n);
        this.fft.poly_mulselfadj_fft(srctmp, gxx, logn);
        this.fft.poly_add(srctmp, g11, srctmp, gxx, logn);
        this.ffLDL_fft(srcexpanded_key, tree, srctmp, g00, srctmp, g01, srctmp, g11, logn, srctmp, gxx);
        this.ffLDL_binary_normalize(srcexpanded_key, tree, logn, logn);
    }

    void ffSampling_fft_dyntree(SamplerZ samp, SamplerCtx samp_ctx, FalconFPR[] srct0, int t0, FalconFPR[] srct1, int t1, FalconFPR[] srcg00, int g00, FalconFPR[] srcg01, int g01, FalconFPR[] srcg11, int g11, int orig_logn, int logn, FalconFPR[] srctmp, int tmp) {
        if (logn == 0) {
            FalconFPR leaf = srcg00[g00 + 0];
            leaf = this.fpr.fpr_mul(this.fpr.fpr_sqrt(leaf), this.fpr.fpr_inv_sigma[orig_logn]);
            srct0[t0 + 0] = this.fpr.fpr_of(samp.sample(samp_ctx, srct0[t0 + 0], leaf));
            srct1[t1 + 0] = this.fpr.fpr_of(samp.sample(samp_ctx, srct1[t1 + 0], leaf));
            return;
        }
        int n = 1 << logn;
        int hn = n >> 1;
        this.fft.poly_LDL_fft(srcg00, g00, srcg01, g01, srcg11, g11, logn);
        this.fft.poly_split_fft(srctmp, tmp, srctmp, tmp + hn, srcg00, g00, logn);
        System.arraycopy(srctmp, tmp, srcg00, g00, n);
        this.fft.poly_split_fft(srctmp, tmp, srctmp, tmp + hn, srcg11, g11, logn);
        System.arraycopy(srctmp, tmp, srcg11, g11, n);
        System.arraycopy(srcg01, g01, srctmp, tmp, n);
        System.arraycopy(srcg00, g00, srcg01, g01, hn);
        System.arraycopy(srcg11, g11, srcg01, g01 + hn, hn);
        int z1 = tmp + n;
        this.fft.poly_split_fft(srctmp, z1, srctmp, z1 + hn, srct1, t1, logn);
        this.ffSampling_fft_dyntree(samp, samp_ctx, srctmp, z1, srctmp, z1 + hn, srcg11, g11, srcg11, g11 + hn, srcg01, g01 + hn, orig_logn, logn - 1, srctmp, z1 + n);
        this.fft.poly_merge_fft(srctmp, tmp + (n << 1), srctmp, z1, srctmp, z1 + hn, logn);
        System.arraycopy(srct1, t1, srctmp, z1, n);
        this.fft.poly_sub(srctmp, z1, srctmp, tmp + (n << 1), logn);
        System.arraycopy(srctmp, tmp + (n << 1), srct1, t1, n);
        this.fft.poly_mul_fft(srctmp, tmp, srctmp, z1, logn);
        this.fft.poly_add(srct0, t0, srctmp, tmp, logn);
        int z0 = tmp;
        this.fft.poly_split_fft(srctmp, z0, srctmp, z0 + hn, srct0, t0, logn);
        this.ffSampling_fft_dyntree(samp, samp_ctx, srctmp, z0, srctmp, z0 + hn, srcg00, g00, srcg00, g00 + hn, srcg01, g01, orig_logn, logn - 1, srctmp, z0 + n);
        this.fft.poly_merge_fft(srct0, t0, srctmp, z0, srctmp, z0 + hn, logn);
    }

    void ffSampling_fft(SamplerZ samp, SamplerCtx samp_ctx, FalconFPR[] srcz0, int z0, FalconFPR[] srcz1, int z1, FalconFPR[] srctree, int tree, FalconFPR[] srct0, int t0, FalconFPR[] srct1, int t1, int logn, FalconFPR[] srctmp, int tmp) {
        if (logn == 2) {
            FalconFPR y1;
            FalconFPR y0;
            int tree0 = tree + 4;
            int tree1 = tree + 8;
            FalconFPR a_re = srct1[t1 + 0];
            FalconFPR a_im = srct1[t1 + 2];
            FalconFPR b_re = srct1[t1 + 1];
            FalconFPR b_im = srct1[t1 + 3];
            FalconFPR c_re = this.fpr.fpr_add(a_re, b_re);
            FalconFPR c_im = this.fpr.fpr_add(a_im, b_im);
            FalconFPR w0 = this.fpr.fpr_half(c_re);
            FalconFPR w1 = this.fpr.fpr_half(c_im);
            c_re = this.fpr.fpr_sub(a_re, b_re);
            c_im = this.fpr.fpr_sub(a_im, b_im);
            FalconFPR w2 = this.fpr.fpr_mul(this.fpr.fpr_add(c_re, c_im), this.fpr.fpr_invsqrt8);
            FalconFPR w3 = this.fpr.fpr_mul(this.fpr.fpr_sub(c_im, c_re), this.fpr.fpr_invsqrt8);
            FalconFPR x0 = w2;
            FalconFPR x1 = w3;
            FalconFPR sigma = srctree[tree1 + 3];
            w2 = this.fpr.fpr_of(samp.sample(samp_ctx, x0, sigma));
            w3 = this.fpr.fpr_of(samp.sample(samp_ctx, x1, sigma));
            a_re = this.fpr.fpr_sub(x0, w2);
            a_im = this.fpr.fpr_sub(x1, w3);
            b_re = srctree[tree1 + 0];
            b_im = srctree[tree1 + 1];
            c_re = this.fpr.fpr_sub(this.fpr.fpr_mul(a_re, b_re), this.fpr.fpr_mul(a_im, b_im));
            c_im = this.fpr.fpr_add(this.fpr.fpr_mul(a_re, b_im), this.fpr.fpr_mul(a_im, b_re));
            x0 = this.fpr.fpr_add(c_re, w0);
            x1 = this.fpr.fpr_add(c_im, w1);
            sigma = srctree[tree1 + 2];
            w0 = this.fpr.fpr_of(samp.sample(samp_ctx, x0, sigma));
            w1 = this.fpr.fpr_of(samp.sample(samp_ctx, x1, sigma));
            a_re = w0;
            a_im = w1;
            b_re = w2;
            b_im = w3;
            c_re = this.fpr.fpr_mul(this.fpr.fpr_sub(b_re, b_im), this.fpr.fpr_invsqrt2);
            c_im = this.fpr.fpr_mul(this.fpr.fpr_add(b_re, b_im), this.fpr.fpr_invsqrt2);
            srcz1[z1 + 0] = w0 = this.fpr.fpr_add(a_re, c_re);
            srcz1[z1 + 2] = w2 = this.fpr.fpr_add(a_im, c_im);
            srcz1[z1 + 1] = w1 = this.fpr.fpr_sub(a_re, c_re);
            srcz1[z1 + 3] = w3 = this.fpr.fpr_sub(a_im, c_im);
            w0 = this.fpr.fpr_sub(srct1[t1 + 0], w0);
            w1 = this.fpr.fpr_sub(srct1[t1 + 1], w1);
            w2 = this.fpr.fpr_sub(srct1[t1 + 2], w2);
            w3 = this.fpr.fpr_sub(srct1[t1 + 3], w3);
            a_re = w0;
            a_im = w2;
            b_re = srctree[tree + 0];
            b_im = srctree[tree + 2];
            w0 = this.fpr.fpr_sub(this.fpr.fpr_mul(a_re, b_re), this.fpr.fpr_mul(a_im, b_im));
            w2 = this.fpr.fpr_add(this.fpr.fpr_mul(a_re, b_im), this.fpr.fpr_mul(a_im, b_re));
            a_re = w1;
            a_im = w3;
            b_re = srctree[tree + 1];
            b_im = srctree[tree + 3];
            w1 = this.fpr.fpr_sub(this.fpr.fpr_mul(a_re, b_re), this.fpr.fpr_mul(a_im, b_im));
            w3 = this.fpr.fpr_add(this.fpr.fpr_mul(a_re, b_im), this.fpr.fpr_mul(a_im, b_re));
            w0 = this.fpr.fpr_add(w0, srct0[t0 + 0]);
            w1 = this.fpr.fpr_add(w1, srct0[t0 + 1]);
            w2 = this.fpr.fpr_add(w2, srct0[t0 + 2]);
            w3 = this.fpr.fpr_add(w3, srct0[t0 + 3]);
            a_re = w0;
            a_im = w2;
            b_re = w1;
            b_im = w3;
            c_re = this.fpr.fpr_add(a_re, b_re);
            c_im = this.fpr.fpr_add(a_im, b_im);
            w0 = this.fpr.fpr_half(c_re);
            w1 = this.fpr.fpr_half(c_im);
            c_re = this.fpr.fpr_sub(a_re, b_re);
            c_im = this.fpr.fpr_sub(a_im, b_im);
            w2 = this.fpr.fpr_mul(this.fpr.fpr_add(c_re, c_im), this.fpr.fpr_invsqrt8);
            w3 = this.fpr.fpr_mul(this.fpr.fpr_sub(c_im, c_re), this.fpr.fpr_invsqrt8);
            x0 = w2;
            x1 = w3;
            sigma = srctree[tree0 + 3];
            w2 = y0 = this.fpr.fpr_of(samp.sample(samp_ctx, x0, sigma));
            w3 = y1 = this.fpr.fpr_of(samp.sample(samp_ctx, x1, sigma));
            a_re = this.fpr.fpr_sub(x0, y0);
            a_im = this.fpr.fpr_sub(x1, y1);
            b_re = srctree[tree0 + 0];
            b_im = srctree[tree0 + 1];
            c_re = this.fpr.fpr_sub(this.fpr.fpr_mul(a_re, b_re), this.fpr.fpr_mul(a_im, b_im));
            c_im = this.fpr.fpr_add(this.fpr.fpr_mul(a_re, b_im), this.fpr.fpr_mul(a_im, b_re));
            x0 = this.fpr.fpr_add(c_re, w0);
            x1 = this.fpr.fpr_add(c_im, w1);
            sigma = srctree[tree0 + 2];
            w0 = this.fpr.fpr_of(samp.sample(samp_ctx, x0, sigma));
            w1 = this.fpr.fpr_of(samp.sample(samp_ctx, x1, sigma));
            a_re = w0;
            a_im = w1;
            b_re = w2;
            b_im = w3;
            c_re = this.fpr.fpr_mul(this.fpr.fpr_sub(b_re, b_im), this.fpr.fpr_invsqrt2);
            c_im = this.fpr.fpr_mul(this.fpr.fpr_add(b_re, b_im), this.fpr.fpr_invsqrt2);
            srcz0[z0 + 0] = this.fpr.fpr_add(a_re, c_re);
            srcz0[z0 + 2] = this.fpr.fpr_add(a_im, c_im);
            srcz0[z0 + 1] = this.fpr.fpr_sub(a_re, c_re);
            srcz0[z0 + 3] = this.fpr.fpr_sub(a_im, c_im);
            return;
        }
        if (logn == 1) {
            FalconFPR y1;
            FalconFPR y0;
            FalconFPR x0 = srct1[t1 + 0];
            FalconFPR x1 = srct1[t1 + 1];
            FalconFPR sigma = srctree[tree + 3];
            srcz1[z1 + 0] = y0 = this.fpr.fpr_of(samp.sample(samp_ctx, x0, sigma));
            srcz1[z1 + 1] = y1 = this.fpr.fpr_of(samp.sample(samp_ctx, x1, sigma));
            FalconFPR a_re = this.fpr.fpr_sub(x0, y0);
            FalconFPR a_im = this.fpr.fpr_sub(x1, y1);
            FalconFPR b_re = srctree[tree + 0];
            FalconFPR b_im = srctree[tree + 1];
            FalconFPR c_re = this.fpr.fpr_sub(this.fpr.fpr_mul(a_re, b_re), this.fpr.fpr_mul(a_im, b_im));
            FalconFPR c_im = this.fpr.fpr_add(this.fpr.fpr_mul(a_re, b_im), this.fpr.fpr_mul(a_im, b_re));
            x0 = this.fpr.fpr_add(c_re, srct0[t0 + 0]);
            x1 = this.fpr.fpr_add(c_im, srct0[t0 + 1]);
            sigma = srctree[tree + 2];
            srcz0[z0 + 0] = this.fpr.fpr_of(samp.sample(samp_ctx, x0, sigma));
            srcz0[z0 + 1] = this.fpr.fpr_of(samp.sample(samp_ctx, x1, sigma));
            return;
        }
        int n = 1 << logn;
        int hn = n >> 1;
        int tree0 = tree + n;
        int tree1 = tree + n + this.ffLDL_treesize(logn - 1);
        this.fft.poly_split_fft(srcz1, z1, srcz1, z1 + hn, srct1, t1, logn);
        this.ffSampling_fft(samp, samp_ctx, srctmp, tmp, srctmp, tmp + hn, srctree, tree1, srcz1, z1, srcz1, z1 + hn, logn - 1, srctmp, tmp + n);
        this.fft.poly_merge_fft(srcz1, z1, srctmp, tmp, srctmp, tmp + hn, logn);
        System.arraycopy(srct1, t1, srctmp, tmp, n);
        this.fft.poly_sub(srctmp, tmp, srcz1, z1, logn);
        this.fft.poly_mul_fft(srctmp, tmp, srctree, tree, logn);
        this.fft.poly_add(srctmp, tmp, srct0, t0, logn);
        this.fft.poly_split_fft(srcz0, z0, srcz0, z0 + hn, srctmp, tmp, logn);
        this.ffSampling_fft(samp, samp_ctx, srctmp, tmp, srctmp, tmp + hn, srctree, tree0, srcz0, z0, srcz0, z0 + hn, logn - 1, srctmp, tmp + n);
        this.fft.poly_merge_fft(srcz0, z0, srctmp, tmp, srctmp, tmp + hn, logn);
    }

    int do_sign_tree(SamplerZ samp, SamplerCtx samp_ctx, short[] srcs2, int s2, FalconFPR[] srcexpanded_key, int expanded_key, short[] srchm, int hm, int logn, FalconFPR[] srctmp, int tmp) {
        int u;
        int n = FalconSign.MKN(logn);
        int t0 = tmp;
        int t1 = t0 + n;
        int b00 = expanded_key + this.skoff_b00(logn);
        int b01 = expanded_key + this.skoff_b01(logn);
        int b10 = expanded_key + this.skoff_b10(logn);
        int b11 = expanded_key + this.skoff_b11(logn);
        int tree = expanded_key + this.skoff_tree(logn);
        for (u = 0; u < n; ++u) {
            srctmp[t0 + u] = this.fpr.fpr_of(srchm[hm + u]);
        }
        this.fft.FFT(srctmp, t0, logn);
        FalconFPR ni = this.fpr.fpr_inverse_of_q;
        System.arraycopy(srctmp, t0, srctmp, t1, n);
        this.fft.poly_mul_fft(srctmp, t1, srcexpanded_key, b01, logn);
        this.fft.poly_mulconst(srctmp, t1, this.fpr.fpr_neg(ni), logn);
        this.fft.poly_mul_fft(srctmp, t0, srcexpanded_key, b11, logn);
        this.fft.poly_mulconst(srctmp, t0, ni, logn);
        int tx = t1 + n;
        int ty = tx + n;
        this.ffSampling_fft(samp, samp_ctx, srctmp, tx, srctmp, ty, srcexpanded_key, tree, srctmp, t0, srctmp, t1, logn, srctmp, ty + n);
        System.arraycopy(srctmp, tx, srctmp, t0, n);
        System.arraycopy(srctmp, ty, srctmp, t1, n);
        this.fft.poly_mul_fft(srctmp, tx, srcexpanded_key, b00, logn);
        this.fft.poly_mul_fft(srctmp, ty, srcexpanded_key, b10, logn);
        this.fft.poly_add(srctmp, tx, srctmp, ty, logn);
        System.arraycopy(srctmp, t0, srctmp, ty, n);
        this.fft.poly_mul_fft(srctmp, ty, srcexpanded_key, b01, logn);
        System.arraycopy(srctmp, tx, srctmp, t0, n);
        this.fft.poly_mul_fft(srctmp, t1, srcexpanded_key, b11, logn);
        this.fft.poly_add(srctmp, t1, srctmp, ty, logn);
        this.fft.iFFT(srctmp, t0, logn);
        this.fft.iFFT(srctmp, t1, logn);
        short[] s1tmp = new short[n];
        int sqn = 0;
        int ng = 0;
        for (u = 0; u < n; ++u) {
            int z = (srchm[hm + u] & 0xFFFF) - (int)this.fpr.fpr_rint(srctmp[t0 + u]);
            ng |= (sqn += z * z);
            s1tmp[u] = (short)z;
        }
        sqn |= -(ng >>> 31);
        short[] s2tmp = new short[n];
        for (u = 0; u < n; ++u) {
            s2tmp[u] = (short)(-this.fpr.fpr_rint(srctmp[t1 + u]));
        }
        if (this.common.is_short_half(sqn, s2tmp, 0, logn) != 0) {
            System.arraycopy(s2tmp, 0, srcs2, s2, n);
            System.arraycopy(s1tmp, 0, srctmp, tmp, n);
            return 1;
        }
        return 0;
    }

    int do_sign_dyn(SamplerZ samp, SamplerCtx samp_ctx, short[] srcs2, int s2, byte[] srcf, int f, byte[] srcg, int g, byte[] srcF, int F2, byte[] srcG, int G, short[] srchm, int hm, int logn, FalconFPR[] srctmp, int tmp) {
        int u;
        int n = FalconSign.MKN(logn);
        int b00 = tmp;
        int b01 = b00 + n;
        int b10 = b01 + n;
        int b11 = b10 + n;
        this.smallints_to_fpr(srctmp, b01, srcf, f, logn);
        this.smallints_to_fpr(srctmp, b00, srcg, g, logn);
        this.smallints_to_fpr(srctmp, b11, srcF, F2, logn);
        this.smallints_to_fpr(srctmp, b10, srcG, G, logn);
        this.fft.FFT(srctmp, b01, logn);
        this.fft.FFT(srctmp, b00, logn);
        this.fft.FFT(srctmp, b11, logn);
        this.fft.FFT(srctmp, b10, logn);
        this.fft.poly_neg(srctmp, b01, logn);
        this.fft.poly_neg(srctmp, b11, logn);
        int t0 = b11 + n;
        int t1 = t0 + n;
        System.arraycopy(srctmp, b01, srctmp, t0, n);
        this.fft.poly_mulselfadj_fft(srctmp, t0, logn);
        System.arraycopy(srctmp, b00, srctmp, t1, n);
        this.fft.poly_muladj_fft(srctmp, t1, srctmp, b10, logn);
        this.fft.poly_mulselfadj_fft(srctmp, b00, logn);
        this.fft.poly_add(srctmp, b00, srctmp, t0, logn);
        System.arraycopy(srctmp, b01, srctmp, t0, n);
        this.fft.poly_muladj_fft(srctmp, b01, srctmp, b11, logn);
        this.fft.poly_add(srctmp, b01, srctmp, t1, logn);
        this.fft.poly_mulselfadj_fft(srctmp, b10, logn);
        System.arraycopy(srctmp, b11, srctmp, t1, n);
        this.fft.poly_mulselfadj_fft(srctmp, t1, logn);
        this.fft.poly_add(srctmp, b10, srctmp, t1, logn);
        int g00 = b00;
        int g01 = b01;
        int g11 = b10;
        b01 = t0;
        t0 = b01 + n;
        t1 = t0 + n;
        for (u = 0; u < n; ++u) {
            srctmp[t0 + u] = this.fpr.fpr_of(srchm[hm + u]);
        }
        this.fft.FFT(srctmp, t0, logn);
        FalconFPR ni = this.fpr.fpr_inverse_of_q;
        System.arraycopy(srctmp, t0, srctmp, t1, n);
        this.fft.poly_mul_fft(srctmp, t1, srctmp, b01, logn);
        this.fft.poly_mulconst(srctmp, t1, this.fpr.fpr_neg(ni), logn);
        this.fft.poly_mul_fft(srctmp, t0, srctmp, b11, logn);
        this.fft.poly_mulconst(srctmp, t0, ni, logn);
        System.arraycopy(srctmp, t0, srctmp, b11, 2 * n);
        t0 = g11 + n;
        t1 = t0 + n;
        this.ffSampling_fft_dyntree(samp, samp_ctx, srctmp, t0, srctmp, t1, srctmp, g00, srctmp, g01, srctmp, g11, logn, logn, srctmp, t1 + n);
        b00 = tmp;
        b01 = b00 + n;
        b10 = b01 + n;
        b11 = b10 + n;
        System.arraycopy(srctmp, t0, srctmp, b11 + n, n * 2);
        t0 = b11 + n;
        t1 = t0 + n;
        this.smallints_to_fpr(srctmp, b01, srcf, f, logn);
        this.smallints_to_fpr(srctmp, b00, srcg, g, logn);
        this.smallints_to_fpr(srctmp, b11, srcF, F2, logn);
        this.smallints_to_fpr(srctmp, b10, srcG, G, logn);
        this.fft.FFT(srctmp, b01, logn);
        this.fft.FFT(srctmp, b00, logn);
        this.fft.FFT(srctmp, b11, logn);
        this.fft.FFT(srctmp, b10, logn);
        this.fft.poly_neg(srctmp, b01, logn);
        this.fft.poly_neg(srctmp, b11, logn);
        int tx = t1 + n;
        int ty = tx + n;
        System.arraycopy(srctmp, t0, srctmp, tx, n);
        System.arraycopy(srctmp, t1, srctmp, ty, n);
        this.fft.poly_mul_fft(srctmp, tx, srctmp, b00, logn);
        this.fft.poly_mul_fft(srctmp, ty, srctmp, b10, logn);
        this.fft.poly_add(srctmp, tx, srctmp, ty, logn);
        System.arraycopy(srctmp, t0, srctmp, ty, n);
        this.fft.poly_mul_fft(srctmp, ty, srctmp, b01, logn);
        System.arraycopy(srctmp, tx, srctmp, t0, n);
        this.fft.poly_mul_fft(srctmp, t1, srctmp, b11, logn);
        this.fft.poly_add(srctmp, t1, srctmp, ty, logn);
        this.fft.iFFT(srctmp, t0, logn);
        this.fft.iFFT(srctmp, t1, logn);
        short[] s1tmp = new short[n];
        int sqn = 0;
        int ng = 0;
        for (u = 0; u < n; ++u) {
            int z = (srchm[hm + u] & 0xFFFF) - (int)this.fpr.fpr_rint(srctmp[t0 + u]);
            ng |= (sqn += z * z);
            s1tmp[u] = (short)z;
        }
        sqn |= -(ng >>> 31);
        short[] s2tmp = new short[n];
        for (u = 0; u < n; ++u) {
            s2tmp[u] = (short)(-this.fpr.fpr_rint(srctmp[t1 + u]));
        }
        if (this.common.is_short_half(sqn, s2tmp, 0, logn) != 0) {
            System.arraycopy(s2tmp, 0, srcs2, s2, n);
            return 1;
        }
        return 0;
    }

    void sign_tree(short[] srcsig, int sig, SHAKE256 rng, FalconFPR[] srcexpanded_key, int expanded_key, short[] srchm, int hm, int logn, FalconFPR[] srctmp, int tmp) {
        SamplerCtx spc;
        SamplerCtx samp_ctx;
        SamplerZ samp;
        int ftmp = tmp;
        do {
            spc = new SamplerCtx();
            samp = new SamplerZ();
            spc.sigma_min = this.fpr.fpr_sigma_min[logn];
            spc.p.prng_init(rng);
        } while (this.do_sign_tree(samp, samp_ctx = spc, srcsig, sig, srcexpanded_key, expanded_key, srchm, hm, logn, srctmp, ftmp) == 0);
    }

    void sign_dyn(short[] srcsig, int sig, SHAKE256 rng, byte[] srcf, int f, byte[] srcg, int g, byte[] srcF, int F2, byte[] srcG, int G, short[] srchm, int hm, int logn, FalconFPR[] srctmp, int tmp) {
        SamplerCtx spc;
        SamplerCtx samp_ctx;
        SamplerZ samp;
        int ftmp = tmp;
        do {
            spc = new SamplerCtx();
            samp = new SamplerZ();
            spc.sigma_min = this.fpr.fpr_sigma_min[logn];
            spc.p.prng_init(rng);
        } while (this.do_sign_dyn(samp, samp_ctx = spc, srcsig, sig, srcf, f, srcg, g, srcF, F2, srcG, G, srchm, hm, logn, srctmp, ftmp) == 0);
    }
}

