/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.sike;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.pqc.crypto.sike.SIKEPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.jcajce.interfaces.SIKEKey;
import org.bouncycastle.pqc.jcajce.spec.SIKEParameterSpec;
import org.bouncycastle.util.Arrays;

public class BCSIKEPrivateKey
implements PrivateKey,
SIKEKey {
    private static final long serialVersionUID = 1L;
    private transient SIKEPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSIKEPrivateKey(SIKEPrivateKeyParameters params) {
        this.params = params;
    }

    public BCSIKEPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(PrivateKeyInfo keyInfo) throws IOException {
        this.attributes = keyInfo.getAttributes();
        this.params = (SIKEPrivateKeyParameters)PrivateKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCSIKEPrivateKey) {
            BCSIKEPrivateKey otherKey = (BCSIKEPrivateKey)o;
            return Arrays.areEqual(this.params.getEncoded(), otherKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return "SIKE";
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo pki = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public SIKEParameterSpec getParameterSpec() {
        return SIKEParameterSpec.fromName(this.params.getParameters().getName());
    }

    public String getFormat() {
        return "PKCS#8";
    }

    SIKEPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

