/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import org.bouncycastle.pqc.crypto.picnic.KMatricesWithPointer;
import org.bouncycastle.pqc.crypto.picnic.LowmcConstants;
import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.pqc.crypto.picnic.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

class Tape {
    byte[][] tapes;
    int pos;
    int nTapes;
    private PicnicEngine engine;

    public Tape(PicnicEngine engine) {
        this.engine = engine;
        this.tapes = new byte[engine.numMPCParties][2 * engine.andSizeBytes];
        this.pos = 0;
        this.nTapes = engine.numMPCParties;
    }

    protected void setAuxBits(byte[] input) {
        int last = this.engine.numMPCParties - 1;
        int pos = 0;
        int n = this.engine.stateSizeBits;
        for (int j = 0; j < this.engine.numRounds; ++j) {
            for (int i = 0; i < n; ++i) {
                Utils.setBit(this.tapes[last], n + n * 2 * j + i, Utils.getBit(input, pos++));
            }
        }
    }

    protected void computeAuxTape(byte[] inputs) {
        int[] roundKey = new int[16];
        int[] x = new int[16];
        int[] y = new int[16];
        int[] key = new int[16];
        int[] key0 = new int[16];
        key0[this.engine.stateSizeWords - 1] = 0;
        this.tapesToParityBits(key0, this.engine.stateSizeBits);
        KMatricesWithPointer current = LowmcConstants.KMatrixInv(this.engine);
        this.engine.matrix_mul(key, key0, current.getData(), current.getMatrixPointer());
        if (inputs != null) {
            Pack.intToLittleEndian(Arrays.copyOf(key, this.engine.stateSizeWords), inputs, 0);
        }
        for (int r = this.engine.numRounds; r > 0; --r) {
            current = LowmcConstants.KMatrix(this.engine, r);
            this.engine.matrix_mul(roundKey, key, current.getData(), current.getMatrixPointer());
            this.engine.xor_array(x, x, roundKey, 0, this.engine.stateSizeWords);
            current = LowmcConstants.LMatrixInv(this.engine, r - 1);
            this.engine.matrix_mul(y, x, current.getData(), current.getMatrixPointer());
            if (r == 1) {
                System.arraycopy(key0, 0, x, 0, key0.length);
            } else {
                this.pos = this.engine.stateSizeBits * 2 * (r - 1);
                this.tapesToParityBits(x, this.engine.stateSizeBits);
            }
            this.pos = this.engine.stateSizeBits * 2 * (r - 1) + this.engine.stateSizeBits;
            this.engine.aux_mpc_sbox(x, y, this);
        }
        this.pos = 0;
    }

    private void tapesToParityBits(int[] output, int outputBitLen) {
        for (int i = 0; i < outputBitLen; ++i) {
            Utils.setBitInWordArray(output, i, Utils.parity16(this.tapesToWord()));
        }
    }

    protected int tapesToWord() {
        byte[] shares = new byte[4];
        for (int i = 0; i < 16; ++i) {
            byte bit = Utils.getBit(this.tapes[i], this.pos);
            Utils.setBit(shares, i, bit);
        }
        ++this.pos;
        return Pack.littleEndianToInt(shares, 0);
    }
}

