/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.frodo;

import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;

abstract class FrodoMatrixGenerator {
    int n;
    int q;

    public FrodoMatrixGenerator(int n, int q) {
        this.n = n;
        this.q = q;
    }

    abstract short[] genMatrix(byte[] var1);

    static class Aes128MatrixGenerator
    extends FrodoMatrixGenerator {
        BufferedBlockCipher cipher = new BufferedBlockCipher(new AESEngine());

        public Aes128MatrixGenerator(int n, int q) {
            super(n, q);
        }

        short[] genMatrix(byte[] seedA) {
            short[] A = new short[this.n * this.n];
            byte[] b = new byte[16];
            byte[] c = new byte[16];
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; j += 8) {
                    System.arraycopy(Pack.shortToLittleEndian((short)(i & 0xFFFF)), 0, b, 0, 2);
                    System.arraycopy(Pack.shortToLittleEndian((short)(j & 0xFFFF)), 0, b, 2, 2);
                    this.aes128(c, seedA, b);
                    for (int k = 0; k < 8; ++k) {
                        A[i * this.n + j + k] = (short)(Pack.littleEndianToShort(c, 2 * k) % this.q);
                    }
                }
            }
            return A;
        }

        void aes128(byte[] out, byte[] keyBytes, byte[] msg) {
            try {
                KeyParameter kp = new KeyParameter(keyBytes);
                this.cipher.init(true, kp);
                int len = this.cipher.processBytes(msg, 0, msg.length, out, 0);
                this.cipher.doFinal(out, len);
            }
            catch (InvalidCipherTextException e) {
                throw Exceptions.illegalStateException(e.toString(), e);
            }
        }
    }

    static class Shake128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Shake128MatrixGenerator(int n, int q) {
            super(n, q);
        }

        short[] genMatrix(byte[] seedA) {
            short[] A = new short[this.n * this.n];
            byte[] tmp = new byte[16 * this.n / 8];
            for (short i = 0; i < this.n; i = (short)(i + 1)) {
                byte[] b = Arrays.concatenate(Pack.shortToLittleEndian(i), seedA);
                SHAKEDigest digest = new SHAKEDigest(128);
                digest.update(b, 0, b.length);
                digest.doFinal(tmp, 0, tmp.length);
                for (int j = 0; j < this.n; j = (int)((short)(j + 1))) {
                    A[i * this.n + j] = (short)(Pack.littleEndianToShort(tmp, 2 * j) % this.q);
                }
            }
            return A;
        }
    }
}

