/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.falcon.FalconNIST;
import org.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;

public class FalconSigner
implements MessageSigner {
    private byte[] encodedkey;
    private FalconNIST nist;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                FalconPrivateKeyParameters skparam = (FalconPrivateKeyParameters)((ParametersWithRandom)param).getParameters();
                this.encodedkey = skparam.getEncoded();
                this.nist = new FalconNIST(skparam.getParameters().getLogN(), skparam.getParameters().getNonceLength(), ((ParametersWithRandom)param).getRandom());
            } else {
                FalconPrivateKeyParameters skparam = (FalconPrivateKeyParameters)param;
                this.encodedkey = ((FalconPrivateKeyParameters)param).getEncoded();
                this.nist = new FalconNIST(skparam.getParameters().getLogN(), skparam.getParameters().getNonceLength(), CryptoServicesRegistrar.getSecureRandom());
            }
        } else {
            FalconPublicKeyParameters pkparam = (FalconPublicKeyParameters)param;
            this.encodedkey = pkparam.getH();
            this.nist = new FalconNIST(pkparam.getParameters().getLogN(), pkparam.getParameters().getNonceLength(), CryptoServicesRegistrar.getSecureRandom());
        }
    }

    public byte[] generateSignature(byte[] message) {
        byte[] sm = new byte[this.nist.CRYPTO_BYTES];
        return this.nist.crypto_sign(sm, message, 0, message.length, this.encodedkey, 0);
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        if (signature[0] != (byte)(48 + this.nist.LOGN)) {
            return false;
        }
        byte[] nonce = new byte[this.nist.NONCELEN];
        byte[] sig = new byte[signature.length - this.nist.NONCELEN - 1];
        System.arraycopy(signature, 1, nonce, 0, this.nist.NONCELEN);
        System.arraycopy(signature, this.nist.NONCELEN + 1, sig, 0, signature.length - this.nist.NONCELEN - 1);
        boolean res = this.nist.crypto_sign_open(sig, nonce, message, this.encodedkey, 0) == 0;
        return res;
    }
}

