/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import java.text.ParseException;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.XMSS;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Pack;

public final class XMSSPrivateKeyParameters
implements XMSSStoreableObjectInterface {
    private final XMSSParameters params;
    private final int index;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final BDS bdsState;

    private XMSSPrivateKeyParameters(Builder builder) throws ParseException, ClassNotFoundException, IOException {
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getDigestSize();
        byte[] privateKey = builder.privateKey;
        if (privateKey != null) {
            if (builder.xmss == null) {
                throw new NullPointerException("xmss == null");
            }
            int height = this.params.getHeight();
            int indexSize = 4;
            int secretKeySize = n;
            int secretKeyPRFSize = n;
            int publicSeedSize = n;
            int rootSize = n;
            int position = 0;
            this.index = Pack.bigEndianToInt(privateKey, position);
            if (!XMSSUtil.isIndexValid(height, this.index)) {
                throw new ParseException("index out of bounds", 0);
            }
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset(privateKey, position += indexSize, secretKeySize);
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset(privateKey, position += secretKeySize, secretKeyPRFSize);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(privateKey, position += secretKeyPRFSize, publicSeedSize);
            this.root = XMSSUtil.extractBytesAtOffset(privateKey, position += publicSeedSize, rootSize);
            byte[] bdsStateBinary = XMSSUtil.extractBytesAtOffset(privateKey, position += rootSize, privateKey.length - position);
            BDS bdsImport = (BDS)XMSSUtil.deserialize(bdsStateBinary);
            bdsImport.setXMSS(builder.xmss);
            bdsImport.validate();
            this.bdsState = bdsImport;
        } else {
            this.index = builder.index;
            byte[] tmpSecretKeySeed = builder.secretKeySeed;
            if (tmpSecretKeySeed != null) {
                if (tmpSecretKeySeed.length != n) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.secretKeySeed = tmpSecretKeySeed;
            } else {
                this.secretKeySeed = new byte[n];
            }
            byte[] tmpSecretKeyPRF = builder.secretKeyPRF;
            if (tmpSecretKeyPRF != null) {
                if (tmpSecretKeyPRF.length != n) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.secretKeyPRF = tmpSecretKeyPRF;
            } else {
                this.secretKeyPRF = new byte[n];
            }
            byte[] tmpPublicSeed = builder.publicSeed;
            if (tmpPublicSeed != null) {
                if (tmpPublicSeed.length != n) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.publicSeed = tmpPublicSeed;
            } else {
                this.publicSeed = new byte[n];
            }
            byte[] tmpRoot = builder.root;
            if (tmpRoot != null) {
                if (tmpRoot.length != n) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.root = tmpRoot;
            } else {
                this.root = new byte[n];
            }
            BDS tmpBDSState = builder.bdsState;
            this.bdsState = tmpBDSState != null ? tmpBDSState : new BDS(new XMSS(this.params));
        }
    }

    public byte[] toByteArray() {
        int n = this.params.getDigestSize();
        int indexSize = 4;
        int secretKeySize = n;
        int secretKeyPRFSize = n;
        int publicSeedSize = n;
        int rootSize = n;
        int totalSize = indexSize + secretKeySize + secretKeyPRFSize + publicSeedSize + rootSize;
        byte[] out = new byte[totalSize];
        int position = 0;
        XMSSUtil.intToBytesBigEndianOffset(out, this.index, position);
        XMSSUtil.copyBytesAtOffset(out, this.secretKeySeed, position += indexSize);
        XMSSUtil.copyBytesAtOffset(out, this.secretKeyPRF, position += secretKeySize);
        XMSSUtil.copyBytesAtOffset(out, this.publicSeed, position += secretKeyPRFSize);
        XMSSUtil.copyBytesAtOffset(out, this.root, position += publicSeedSize);
        byte[] bdsStateOut = null;
        try {
            bdsStateOut = XMSSUtil.serialize(this.bdsState);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error serializing bds state");
        }
        return XMSSUtil.concat(out, bdsStateOut);
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    public BDS getBDSState() {
        return this.bdsState;
    }

    public static class Builder {
        private final XMSSParameters params;
        private int index = 0;
        private byte[] secretKeySeed = null;
        private byte[] secretKeyPRF = null;
        private byte[] publicSeed = null;
        private byte[] root = null;
        private BDS bdsState = null;
        private byte[] privateKey = null;
        private XMSS xmss = null;

        public Builder(XMSSParameters params) {
            this.params = params;
        }

        public Builder withIndex(int val) {
            this.index = val;
            return this;
        }

        public Builder withSecretKeySeed(byte[] val) {
            this.secretKeySeed = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] val) {
            this.secretKeyPRF = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.publicSeed = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withRoot(byte[] val) {
            this.root = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withBDSState(BDS valBDS) {
            this.bdsState = valBDS;
            return this;
        }

        public Builder withPrivateKey(byte[] privateKeyVal, XMSS xmssVal) {
            this.privateKey = XMSSUtil.cloneArray(privateKeyVal);
            this.xmss = xmssVal;
            return this;
        }

        public XMSSPrivateKeyParameters build() throws ParseException, ClassNotFoundException, IOException {
            return new XMSSPrivateKeyParameters(this);
        }
    }
}

