/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

public final class KeyedHashFunctions {
    private final Digest digest;
    private final int digestSize;

    protected KeyedHashFunctions(Digest digest, int digestSize) {
        if (digest == null) {
            throw new NullPointerException("digest == null");
        }
        this.digest = digest;
        this.digestSize = digestSize;
    }

    private byte[] coreDigest(int fixedValue, byte[] key, byte[] index) {
        int i;
        byte[] buffer = new byte[this.digestSize + key.length + index.length];
        byte[] in = XMSSUtil.toBytesBigEndian(fixedValue, this.digestSize);
        for (i = 0; i < in.length; ++i) {
            buffer[i] = in[i];
        }
        for (i = 0; i < key.length; ++i) {
            buffer[in.length + i] = key[i];
        }
        for (i = 0; i < index.length; ++i) {
            buffer[in.length + key.length + i] = index[i];
        }
        this.digest.update(buffer, 0, buffer.length);
        byte[] out = new byte[this.digestSize];
        if (this.digest instanceof Xof) {
            ((Xof)this.digest).doFinal(out, 0, this.digestSize);
        } else {
            this.digest.doFinal(out, 0);
        }
        return out;
    }

    protected byte[] F(byte[] key, byte[] in) {
        if (key.length != this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        if (in.length != this.digestSize) {
            throw new IllegalArgumentException("wrong in length");
        }
        return this.coreDigest(0, key, in);
    }

    protected byte[] H(byte[] key, byte[] in) {
        if (key.length != this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        if (in.length != 2 * this.digestSize) {
            throw new IllegalArgumentException("wrong in length");
        }
        return this.coreDigest(1, key, in);
    }

    protected byte[] HMsg(byte[] key, byte[] in) {
        if (key.length != 3 * this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        return this.coreDigest(2, key, in);
    }

    protected byte[] PRF(byte[] key, byte[] address) {
        if (key.length != this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        if (address.length != 32) {
            throw new IllegalArgumentException("wrong address length");
        }
        return this.coreDigest(3, key, address);
    }
}

