/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.pqc.crypto.cmce.GF;

final class GF12
extends GF {
    GF12() {
    }

    protected void gf_mul_poly(int length, int[] poly, short[] out, short[] left, short[] right, int[] temp) {
        int i;
        temp[0] = this.gf_mul_ext(left[0], right[0]);
        for (i = 1; i < length; ++i) {
            temp[i + i - 1] = 0;
            short left_i = left[i];
            short right_i = right[i];
            for (int j = 0; j < i; ++j) {
                int n = i + j;
                temp[n] = temp[n] ^ this.gf_mul_ext_par(left_i, right[j], left[j], right_i);
            }
            temp[i + i] = this.gf_mul_ext(left_i, right_i);
        }
        for (i = (length - 1) * 2; i >= length; --i) {
            int temp_i = temp[i];
            for (int j = 0; j < poly.length - 1; ++j) {
                int n = i - length + poly[j];
                temp[n] = temp[n] ^ temp_i;
            }
            int n = i - length;
            temp[n] = temp[n] ^ this.gf_mul_ext(this.gf_reduce(temp_i), (short)2);
        }
        for (i = 0; i < length; ++i) {
            out[i] = this.gf_reduce(temp[i]);
        }
    }

    protected void gf_sqr_poly(int length, int[] poly, short[] out, short[] input, int[] temp) {
        int i;
        temp[0] = this.gf_sq_ext(input[0]);
        for (i = 1; i < length; ++i) {
            temp[i + i - 1] = 0;
            temp[i + i] = this.gf_sq_ext(input[i]);
        }
        for (i = (length - 1) * 2; i >= length; --i) {
            int temp_i = temp[i];
            for (int j = 0; j < poly.length - 1; ++j) {
                int n = i - length + poly[j];
                temp[n] = temp[n] ^ temp_i;
            }
            int n = i - length;
            temp[n] = temp[n] ^ this.gf_mul_ext(this.gf_reduce(temp_i), (short)2);
        }
        for (i = 0; i < length; ++i) {
            out[i] = this.gf_reduce(temp[i]);
        }
    }

    protected short gf_frac(short den, short num) {
        return this.gf_mul(this.gf_inv(den), num);
    }

    protected short gf_inv(short input) {
        short out = input;
        out = this.gf_sq(out);
        short tmp_11 = this.gf_mul(out, input);
        out = this.gf_sq(tmp_11);
        out = this.gf_sq(out);
        short tmp_1111 = this.gf_mul(out, tmp_11);
        out = this.gf_sq(tmp_1111);
        out = this.gf_sq(out);
        out = this.gf_sq(out);
        out = this.gf_sq(out);
        out = this.gf_mul(out, tmp_1111);
        out = this.gf_sq(out);
        out = this.gf_sq(out);
        out = this.gf_mul(out, tmp_11);
        out = this.gf_sq(out);
        out = this.gf_mul(out, input);
        return this.gf_sq(out);
    }

    protected short gf_mul(short left, short right) {
        short x = left;
        short y = right;
        int z = x * (y & 1);
        for (int i = 1; i < 12; ++i) {
            z ^= x * (y & 1 << i);
        }
        return this.gf_reduce(z);
    }

    protected int gf_mul_ext(short left, short right) {
        short x = left;
        short y = right;
        int z = x * (y & 1);
        for (int i = 1; i < 12; ++i) {
            z ^= x * (y & 1 << i);
        }
        return z;
    }

    private int gf_mul_ext_par(short left0, short right0, short left1, short right1) {
        short x0 = left0;
        short y0 = right0;
        short x1 = left1;
        short y1 = right1;
        int z0 = x0 * (y0 & 1);
        int z1 = x1 * (y1 & 1);
        for (int i = 1; i < 12; ++i) {
            z0 ^= x0 * (y0 & 1 << i);
            z1 ^= x1 * (y1 & 1 << i);
        }
        return z0 ^ z1;
    }

    protected short gf_reduce(int x) {
        int u0 = x & 0xFFF;
        int u1 = x >>> 12;
        int u2 = (x & 0x1FF000) >>> 9;
        int u3 = (x & 0xE00000) >>> 18;
        int u4 = x >>> 21;
        return (short)(u0 ^ u1 ^ u2 ^ u3 ^ u4);
    }

    protected short gf_sq(short input) {
        int z = Interleave.expand16to32(input);
        return this.gf_reduce(z);
    }

    protected int gf_sq_ext(short input) {
        return Interleave.expand16to32(input);
    }
}

