/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import org.bouncycastle.math.raw.Bits;
import org.bouncycastle.util.Integers;

public class Longs {
    public static final int BYTES = 8;
    public static final int SIZE = 64;
    private static final byte[] DEBRUIJN_TZ = new byte[]{63, 0, 1, 52, 2, 6, 53, 26, 3, 37, 40, 7, 33, 54, 47, 27, 61, 4, 38, 45, 43, 41, 21, 8, 23, 34, 58, 55, 48, 17, 28, 10, 62, 51, 5, 25, 36, 39, 32, 46, 60, 44, 42, 20, 22, 57, 16, 9, 50, 24, 35, 31, 59, 19, 56, 15, 49, 30, 18, 14, 29, 13, 12, 11};

    public static int numberOfLeadingZeros(long i) {
        int x = (int)(i >>> 32);
        int n = 0;
        if (x == 0) {
            n = 32;
            x = (int)i;
        }
        return n + Integers.numberOfLeadingZeros(x);
    }

    public static int numberOfTrailingZeros(long i) {
        byte n = DEBRUIJN_TZ[(int)((i & -i) * 315175865370177754L >>> 58)];
        long m = (i & 0xFFFFFFFFL | i >>> 32) - 1L >> 63;
        return n - (int)m;
    }

    public static long reverse(long i) {
        i = Bits.bitPermuteStepSimple(i, 0x5555555555555555L, 1);
        i = Bits.bitPermuteStepSimple(i, 0x3333333333333333L, 2);
        i = Bits.bitPermuteStepSimple(i, 0xF0F0F0F0F0F0F0FL, 4);
        return Longs.reverseBytes(i);
    }

    public static long reverseBytes(long i) {
        return Longs.rotateLeft(i & 0xFF000000FF000000L, 8) | Longs.rotateLeft(i & 0xFF000000FF0000L, 24) | Longs.rotateLeft(i & 0xFF000000FF00L, 40) | Longs.rotateLeft(i & 0xFF000000FFL, 56);
    }

    public static long rotateLeft(long i, int distance) {
        return i << distance ^ i >>> -distance;
    }

    public static long rotateRight(long i, int distance) {
        return i >>> distance ^ i << -distance;
    }

    public static Long valueOf(long value) {
        return new Long(value);
    }
}

