/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AlphabetMapper;
import org.bouncycastle.util.Integers;

public class BasicAlphabetMapper
implements AlphabetMapper {
    private Map indexMap = new HashMap();
    private Map charMap = new HashMap();

    public BasicAlphabetMapper(String alphabet) {
        this(alphabet.toCharArray());
    }

    public BasicAlphabetMapper(char[] alphabet) {
        for (int i = 0; i != alphabet.length; ++i) {
            if (this.indexMap.containsKey(new Character(alphabet[i]))) {
                throw new IllegalArgumentException("duplicate key detected in alphabet: " + alphabet[i]);
            }
            this.indexMap.put(new Character(alphabet[i]), Integers.valueOf(i));
            this.charMap.put(Integers.valueOf(i), new Character(alphabet[i]));
        }
    }

    public int getRadix() {
        return this.indexMap.size();
    }

    public byte[] convertToIndexes(char[] input) {
        byte[] out;
        if (this.indexMap.size() <= 256) {
            out = new byte[input.length];
            for (int i = 0; i != input.length; ++i) {
                out[i] = ((Integer)this.indexMap.get(new Character(input[i]))).byteValue();
            }
        } else {
            out = new byte[input.length * 2];
            for (int i = 0; i != input.length; ++i) {
                int idx = (Integer)this.indexMap.get(new Character(input[i]));
                out[i * 2] = (byte)(idx >> 8 & 0xFF);
                out[i * 2 + 1] = (byte)(idx & 0xFF);
            }
        }
        return out;
    }

    public char[] convertToChars(byte[] input) {
        char[] out;
        if (this.charMap.size() <= 256) {
            out = new char[input.length];
            for (int i = 0; i != input.length; ++i) {
                out[i] = ((Character)this.charMap.get(Integers.valueOf(input[i] & 0xFF))).charValue();
            }
        } else {
            if ((input.length & 1) != 0) {
                throw new IllegalArgumentException("two byte radix and input string odd length");
            }
            out = new char[input.length / 2];
            for (int i = 0; i != input.length; i += 2) {
                out[i / 2] = ((Character)this.charMap.get(Integers.valueOf(input[i] << 8 & 0xFF00 | input[i + 1] & 0xFF))).charValue();
            }
        }
        return out;
    }
}

