/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.hqc;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.util.SpecUtil;
import org.bouncycastle.pqc.crypto.hqc.HQCKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCKeyPairGenerator;
import org.bouncycastle.pqc.crypto.hqc.HQCParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import org.bouncycastle.pqc.jcajce.provider.hqc.BCHQCPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.hqc.BCHQCPublicKey;
import org.bouncycastle.pqc.jcajce.spec.HQCParameterSpec;
import org.bouncycastle.util.Strings;

public class HQCKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    HQCKeyGenerationParameters param;
    HQCKeyPairGenerator engine = new HQCKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public HQCKeyPairGeneratorSpi() {
        super("HQC");
    }

    protected HQCKeyPairGeneratorSpi(HQCParameterSpec paramSpec) {
        super(Strings.toUpperCase(paramSpec.getName()));
    }

    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        String name = HQCKeyPairGeneratorSpi.getNameFromParams(params);
        if (name == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + params);
        }
        this.param = new HQCKeyGenerationParameters(random, (HQCParameters)parameters.get(name));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec paramSpec) {
        if (paramSpec instanceof HQCParameterSpec) {
            HQCParameterSpec hqcParams = (HQCParameterSpec)paramSpec;
            return hqcParams.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(paramSpec));
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new HQCKeyGenerationParameters(this.random, HQCParameters.hqc128);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        HQCPublicKeyParameters pub = (HQCPublicKeyParameters)pair.getPublic();
        HQCPrivateKeyParameters priv = (HQCPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCHQCPublicKey(pub), new BCHQCPrivateKey(priv));
    }

    static {
        parameters.put("hqc-128", HQCParameters.hqc128);
        parameters.put("hqc-192", HQCParameters.hqc192);
        parameters.put("hqc-256", HQCParameters.hqc256);
        parameters.put(HQCParameterSpec.hqc128.getName(), HQCParameters.hqc128);
        parameters.put(HQCParameterSpec.hqc192.getName(), HQCParameters.hqc192);
        parameters.put(HQCParameterSpec.hqc256.getName(), HQCParameters.hqc256);
    }

    public static class HQC128
    extends HQCKeyPairGeneratorSpi {
        public HQC128() throws NoSuchAlgorithmException {
            super(HQCParameterSpec.hqc128);
        }
    }

    public static class HQC192
    extends HQCKeyPairGeneratorSpi {
        public HQC192() throws NoSuchAlgorithmException {
            super(HQCParameterSpec.hqc192);
        }
    }

    public static class HQC256
    extends HQCKeyPairGeneratorSpi {
        public HQC256() throws NoSuchAlgorithmException {
            super(HQCParameterSpec.hqc256);
        }
    }
}

