/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mayo;

import org.bouncycastle.util.GF16;

class GF16Utils {
    static final long NIBBLE_MASK_MSB = 0x7777777777777777L;
    static final long MASK_MSB = -8608480567731124088L;
    static final long MASK_LSB = 0x1111111111111111L;
    static final long NIBBLE_MASK_LSB = -1229782938247303442L;

    GF16Utils() {
    }

    static void mVecMulAdd(int mVecLimbs, long[] in, int inOffset, int b, long[] acc, int accOffset) {
        long b32 = (long)b & 0xFFFFFFFFL;
        long b32and1 = b32 & 1L;
        long b32_1_1 = b32 >>> 1 & 1L;
        long b32_2_1 = b32 >>> 2 & 1L;
        long b32_3_1 = b32 >>> 3 & 1L;
        for (int i = 0; i < mVecLimbs; ++i) {
            long a = in[inOffset++];
            long r64 = a & -b32and1;
            long a_msb = a & 0x8888888888888888L;
            a &= 0x7777777777777777L;
            long a_msb3 = a_msb >>> 3;
            a = a << 1 ^ a_msb3 + (a_msb3 << 1);
            r64 ^= a & -b32_1_1;
            a_msb = a & 0x8888888888888888L;
            a &= 0x7777777777777777L;
            a_msb3 = a_msb >>> 3;
            a = a << 1 ^ a_msb3 + (a_msb3 << 1);
            r64 ^= a & -b32_2_1;
            a_msb = a & 0x8888888888888888L;
            a &= 0x7777777777777777L;
            a_msb3 = a_msb >>> 3;
            a = a << 1 ^ a_msb3 + (a_msb3 << 1);
            int n = accOffset++;
            acc[n] = acc[n] ^ (r64 ^ a & -b32_3_1);
        }
    }

    static void mulAddMUpperTriangularMatXMat(int mVecLimbs, long[] bsMat, byte[] mat, long[] acc, int accOff, int bsMatRows, int matCols) {
        int bsMatEntriesUsed = 0;
        int matColsmVecLimbs = matCols * mVecLimbs;
        int r = 0;
        int rmatCols = 0;
        int rmatColsmVecLimbs = 0;
        while (r < bsMatRows) {
            int c = r;
            int cmatCols = rmatCols;
            while (c < bsMatRows) {
                int k = 0;
                int kmVecLimbs = 0;
                while (k < matCols) {
                    GF16Utils.mVecMulAdd(mVecLimbs, bsMat, bsMatEntriesUsed, mat[cmatCols + k], acc, accOff + rmatColsmVecLimbs + kmVecLimbs);
                    ++k;
                    kmVecLimbs += mVecLimbs;
                }
                bsMatEntriesUsed += mVecLimbs;
                ++c;
                cmatCols += matCols;
            }
            ++r;
            rmatCols += matCols;
            rmatColsmVecLimbs += matColsmVecLimbs;
        }
    }

    static void mulAddMatTransXMMat(int mVecLimbs, byte[] mat, long[] bsMat, int bsMatOff, long[] acc, int matRows, int matCols) {
        int multiply = matCols * mVecLimbs;
        int r = 0;
        int rmultiply = 0;
        while (r < matCols) {
            int c = 0;
            int cmatCols = 0;
            int cmultiply = 0;
            while (c < matRows) {
                byte matVal = mat[cmatCols + r];
                int k = 0;
                int kmVecLimbs = 0;
                while (k < matCols) {
                    GF16Utils.mVecMulAdd(mVecLimbs, bsMat, bsMatOff + cmultiply + kmVecLimbs, matVal, acc, rmultiply + kmVecLimbs);
                    ++k;
                    kmVecLimbs += mVecLimbs;
                }
                ++c;
                cmatCols += matCols;
                cmultiply += multiply;
            }
            ++r;
            rmultiply += multiply;
        }
    }

    static void mulAddMatXMMat(int mVecLimbs, byte[] mat, long[] bsMat, long[] acc, int matRows, int matCols) {
        int multiply = mVecLimbs * matRows;
        int r = 0;
        int rmatCols = 0;
        int rmultiply = 0;
        while (r < matRows) {
            int c = 0;
            int cmultiply = 0;
            while (c < matCols) {
                byte matVal = mat[rmatCols + c];
                int k = 0;
                int kmVecLimbs = 0;
                while (k < matRows) {
                    GF16Utils.mVecMulAdd(mVecLimbs, bsMat, cmultiply + kmVecLimbs, matVal, acc, rmultiply + kmVecLimbs);
                    ++k;
                    kmVecLimbs += mVecLimbs;
                }
                ++c;
                cmultiply += multiply;
            }
            ++r;
            rmatCols += matCols;
            rmultiply += multiply;
        }
    }

    static void mulAddMatXMMat(int mVecLimbs, byte[] mat, long[] bsMat, int bsMatOff, long[] acc, int matRows, int matCols, int bsMatCols) {
        int multiply = mVecLimbs * bsMatCols;
        int r = 0;
        int rmultiply = 0;
        int rmatCols = 0;
        while (r < matRows) {
            int c = 0;
            int cmultiply = 0;
            while (c < matCols) {
                byte matVal = mat[rmatCols + c];
                int k = 0;
                int kmVecLimbs = 0;
                while (k < bsMatCols) {
                    GF16Utils.mVecMulAdd(mVecLimbs, bsMat, cmultiply + kmVecLimbs + bsMatOff, matVal, acc, rmultiply + kmVecLimbs);
                    ++k;
                    kmVecLimbs += mVecLimbs;
                }
                ++c;
                cmultiply += multiply;
            }
            ++r;
            rmultiply += multiply;
            rmatCols += matCols;
        }
    }

    static void mulAddMUpperTriangularMatXMatTrans(int mVecLimbs, long[] bsMat, byte[] mat, long[] acc, int bsMatRows, int matRows) {
        int bsMatEntriesUsed = 0;
        int multiply = mVecLimbs * matRows;
        int r = 0;
        int rmultiply = 0;
        while (r < bsMatRows) {
            for (int c = r; c < bsMatRows; ++c) {
                int k = 0;
                int kbsMatRows = 0;
                int kmVecLimbs = 0;
                while (k < matRows) {
                    GF16Utils.mVecMulAdd(mVecLimbs, bsMat, bsMatEntriesUsed, mat[kbsMatRows + c], acc, rmultiply + kmVecLimbs);
                    ++k;
                    kbsMatRows += bsMatRows;
                    kmVecLimbs += mVecLimbs;
                }
                bsMatEntriesUsed += mVecLimbs;
            }
            ++r;
            rmultiply += multiply;
        }
    }

    static long mulFx8(byte a, long b) {
        int aa = a & 0xFF;
        long p = (long)(-(aa & 1)) & b ^ (long)(-(aa >> 1 & 1)) & b << 1 ^ (long)(-(aa >> 2 & 1)) & b << 2 ^ (long)(-(aa >> 3 & 1)) & b << 3;
        long topP = p & 0xF0F0F0F0F0F0F0F0L;
        return (p ^ topP >>> 4 ^ topP >>> 3) & 0xF0F0F0F0F0F0F0FL;
    }

    static void matMul(byte[] a, byte[] b, int bOff, byte[] c, int colrowAB, int rowA) {
        int aRowStart = 0;
        int cOff = 0;
        for (int i = 0; i < rowA; ++i) {
            byte result = 0;
            for (int k = 0; k < colrowAB; ++k) {
                result = (byte)(result ^ GF16.mul(a[aRowStart++], b[bOff + k]));
            }
            c[cOff++] = result;
        }
    }
}

