/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.frodo;

import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.pqc.crypto.frodo.FrodoEngine;
import org.bouncycastle.pqc.crypto.frodo.FrodoKeyParameters;
import org.bouncycastle.pqc.crypto.frodo.FrodoParameters;
import org.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;

public class FrodoKEMExtractor
implements EncapsulatedSecretExtractor {
    private FrodoEngine engine;
    private FrodoKeyParameters key;

    public FrodoKEMExtractor(FrodoKeyParameters privParams) {
        this.key = privParams;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(FrodoParameters param) {
        this.engine = param.getEngine();
    }

    public byte[] extractSecret(byte[] encapsulation) {
        byte[] session_key = new byte[this.engine.getSessionKeySize()];
        this.engine.kem_dec(session_key, encapsulation, ((FrodoPrivateKeyParameters)this.key).getPrivateKey());
        return session_key;
    }

    public int getEncapsulationLength() {
        return this.engine.getCipherTextSize();
    }
}

