/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

class FalconCodec {
    static final byte[] max_fg_bits = new byte[]{0, 8, 8, 8, 8, 8, 7, 7, 6, 6, 5};
    static final byte[] max_FG_bits = new byte[]{0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

    FalconCodec() {
    }

    static int modq_encode(byte[] srcout, int max_out_len, short[] srcx, int logn) {
        int u;
        int n = 1 << logn;
        for (u = 0; u < n; ++u) {
            if ((srcx[u] & 0xFFFF) < 12289) continue;
            return 0;
        }
        int out_len = n * 14 + 7 >> 3;
        if (srcout == null) {
            return out_len;
        }
        if (out_len > max_out_len) {
            return 0;
        }
        int buf = 1;
        int acc = 0;
        int acc_len = 0;
        for (u = 0; u < n; ++u) {
            acc = acc << 14 | srcx[u] & 0xFFFF;
            acc_len += 14;
            while (acc_len >= 8) {
                srcout[buf++] = (byte)(acc >> (acc_len -= 8));
            }
        }
        if (acc_len > 0) {
            srcout[buf] = (byte)(acc << 8 - acc_len);
        }
        return out_len;
    }

    static int modq_decode(short[] srcx, int logn, byte[] srcin, int max_in_len) {
        int n = 1 << logn;
        int in_len = n * 14 + 7 >> 3;
        if (in_len > max_in_len) {
            return 0;
        }
        int buf = 0;
        int acc = 0;
        int acc_len = 0;
        int u = 0;
        while (u < n) {
            acc = acc << 8 | srcin[buf++] & 0xFF;
            if ((acc_len += 8) < 14) continue;
            int w = acc >>> (acc_len -= 14) & 0x3FFF;
            if (w >= 12289) {
                return 0;
            }
            srcx[u] = (short)w;
            ++u;
        }
        if ((acc & (1 << acc_len) - 1) != 0) {
            return 0;
        }
        return in_len;
    }

    static int trim_i8_encode(byte[] srcout, int out, int max_out_len, byte[] srcx, int logn, int bits) {
        int u;
        int n = 1 << logn;
        int maxv = (1 << bits - 1) - 1;
        int minv = -maxv;
        for (u = 0; u < n; ++u) {
            if (srcx[u] >= minv && srcx[u] <= maxv) continue;
            return 0;
        }
        int out_len = n * bits + 7 >> 3;
        if (srcout == null) {
            return out_len;
        }
        if (out_len > max_out_len) {
            return 0;
        }
        int buf = out;
        int acc = 0;
        int acc_len = 0;
        int mask = (1 << bits) - 1;
        for (u = 0; u < n; ++u) {
            acc = acc << bits | srcx[u] & 0xFFFF & mask;
            acc_len += bits;
            while (acc_len >= 8) {
                srcout[buf++] = (byte)(acc >>> (acc_len -= 8));
            }
        }
        if (acc_len > 0) {
            srcout[buf] = (byte)(acc << 8 - acc_len);
        }
        return out_len;
    }

    static int trim_i8_decode(byte[] srcx, int logn, int bits, byte[] srcin, int in, int max_in_len) {
        int n = 1 << logn;
        int in_len = n * bits + 7 >> 3;
        if (in_len > max_in_len) {
            return 0;
        }
        int buf = in;
        int u = 0;
        int acc = 0;
        int acc_len = 0;
        int mask1 = (1 << bits) - 1;
        int mask2 = 1 << bits - 1;
        while (u < n) {
            acc = acc << 8 | srcin[buf++] & 0xFF;
            acc_len += 8;
            while (acc_len >= bits && u < n) {
                int w = acc >>> (acc_len -= bits) & mask1;
                if ((w |= -(w & mask2)) == -mask2) {
                    return 0;
                }
                srcx[u] = (byte)w;
                ++u;
            }
        }
        if ((acc & (1 << acc_len) - 1) != 0) {
            return 0;
        }
        return in_len;
    }

    static int comp_encode(byte[] srcout, int max_out_len, short[] srcx, int logn) {
        int u;
        int n = 1 << logn;
        int buf = 0;
        for (u = 0; u < n; ++u) {
            if (srcx[u] >= -2047 && srcx[u] <= 2047) continue;
            return 0;
        }
        int acc = 0;
        int acc_len = 0;
        int v = 0;
        for (u = 0; u < n; ++u) {
            acc <<= 1;
            int t = srcx[u];
            if (t < 0) {
                t = -t;
                acc |= 1;
            }
            int w = t;
            acc <<= 7;
            acc |= w & 0x7F;
            acc_len += 8;
            acc <<= (w >>>= 7) + 1;
            acc |= 1;
            acc_len += w + 1;
            while (acc_len >= 8) {
                acc_len -= 8;
                if (srcout != null) {
                    if (v >= max_out_len) {
                        return 0;
                    }
                    srcout[buf + v] = (byte)(acc >>> acc_len);
                }
                ++v;
            }
        }
        if (acc_len > 0) {
            if (srcout != null) {
                if (v >= max_out_len) {
                    return 0;
                }
                srcout[buf + v] = (byte)(acc << 8 - acc_len);
            }
            ++v;
        }
        return v;
    }

    static int comp_decode(short[] srcx, int logn, byte[] srcin, int max_in_len) {
        int n = 1 << logn;
        int buf = 0;
        int acc = 0;
        int acc_len = 0;
        int v = 0;
        for (int u = 0; u < n; ++u) {
            int m;
            int s;
            block7: {
                if (v >= max_in_len) {
                    return 0;
                }
                acc = acc << 8 | srcin[buf + v] & 0xFF;
                ++v;
                int b = acc >>> acc_len;
                s = b & 0x80;
                m = b & 0x7F;
                do {
                    if (acc_len == 0) {
                        if (v >= max_in_len) {
                            return 0;
                        }
                        acc = acc << 8 | srcin[buf + v] & 0xFF;
                        ++v;
                        acc_len = 8;
                    }
                    if ((acc >>> --acc_len & 1) != 0) break block7;
                } while ((m += 128) <= 2047);
                return 0;
            }
            if (s != 0 && m == 0) {
                return 0;
            }
            srcx[u] = (short)(s != 0 ? -m : m);
        }
        if ((acc & (1 << acc_len) - 1) != 0) {
            return 0;
        }
        return v;
    }
}

