/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import org.bouncycastle.util.Arrays;

public class DilithiumPrivateKeyParameters
extends DilithiumKeyParameters {
    final byte[] rho;
    final byte[] k;
    final byte[] tr;
    final byte[] s1;
    final byte[] s2;
    final byte[] t0;
    private final byte[] t1;

    public DilithiumPrivateKeyParameters(DilithiumParameters params, byte[] rho, byte[] K, byte[] tr, byte[] s1, byte[] s2, byte[] t0, byte[] t1) {
        super(true, params);
        this.rho = Arrays.clone(rho);
        this.k = Arrays.clone(K);
        this.tr = Arrays.clone(tr);
        this.s1 = Arrays.clone(s1);
        this.s2 = Arrays.clone(s2);
        this.t0 = Arrays.clone(t0);
        this.t1 = Arrays.clone(t1);
    }

    public DilithiumPrivateKeyParameters(DilithiumParameters params, byte[] encoding, DilithiumPublicKeyParameters pubKey) {
        super(true, params);
        DilithiumEngine eng = params.getEngine(null);
        int index = 0;
        this.rho = Arrays.copyOfRange(encoding, 0, 32);
        this.k = Arrays.copyOfRange(encoding, index += 32, index + 32);
        this.tr = Arrays.copyOfRange(encoding, index += 32, index + 64);
        int delta = eng.getDilithiumL() * eng.getDilithiumPolyEtaPackedBytes();
        this.s1 = Arrays.copyOfRange(encoding, index += 64, index + delta);
        index += delta;
        delta = eng.getDilithiumK() * eng.getDilithiumPolyEtaPackedBytes();
        this.s2 = Arrays.copyOfRange(encoding, index, index + delta);
        index += delta;
        delta = eng.getDilithiumK() * 416;
        this.t0 = Arrays.copyOfRange(encoding, index, index + delta);
        index += delta;
        this.t1 = (byte[])(pubKey != null ? pubKey.getT1() : null);
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(new byte[][]{this.rho, this.k, this.tr, this.s1, this.s2, this.t0});
    }

    public byte[] getK() {
        return Arrays.clone(this.k);
    }

    @Deprecated
    public byte[] getPrivateKey() {
        return this.getEncoded();
    }

    public byte[] getPublicKey() {
        return DilithiumPublicKeyParameters.getEncoded(this.rho, this.t1);
    }

    public DilithiumPublicKeyParameters getPublicKeyParameters() {
        return new DilithiumPublicKeyParameters(this.getParameters(), this.rho, this.t1);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getS1() {
        return Arrays.clone(this.s1);
    }

    public byte[] getS2() {
        return Arrays.clone(this.s2);
    }

    public byte[] getT0() {
        return Arrays.clone(this.t0);
    }

    public byte[] getT1() {
        return Arrays.clone(this.t1);
    }

    public byte[] getTr() {
        return Arrays.clone(this.tr);
    }
}

