/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.io.IOException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.internal.asn1.iana.IANAObjectIdentifiers;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.jcajce.CompositeUtil;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeIndex;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyFactorySpi;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositePublicKey
implements PublicKey {
    private final List<PublicKey> keys;
    private final List<Provider> providers;
    private final AlgorithmIdentifier algorithmIdentifier;

    public static Builder builder(ASN1ObjectIdentifier compAlgOid) {
        return new Builder(new AlgorithmIdentifier(compAlgOid));
    }

    public static Builder builder(String algorithmName) {
        return CompositePublicKey.builder(CompositeUtil.getOid(algorithmName));
    }

    public CompositePublicKey(PublicKey ... keys) {
        this(MiscObjectIdentifiers.id_composite_key, keys);
    }

    public CompositePublicKey(ASN1ObjectIdentifier algorithmIdentifier, PublicKey ... keys) {
        this(new AlgorithmIdentifier(algorithmIdentifier), keys);
    }

    public CompositePublicKey(AlgorithmIdentifier algorithmIdentifier, PublicKey ... keys) {
        this.algorithmIdentifier = algorithmIdentifier;
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException("at least one public key must be provided for the composite public key");
        }
        ArrayList<PublicKey> keyList = new ArrayList<PublicKey>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            keyList.add(keys[i]);
        }
        this.keys = Collections.unmodifiableList(keyList);
        this.providers = null;
    }

    public CompositePublicKey(SubjectPublicKeyInfo keyInfo) {
        ASN1ObjectIdentifier keyInfoIdentifier = keyInfo.getAlgorithm().getAlgorithm();
        CompositePublicKey publicKeyFromFactory = null;
        try {
            if (!CompositeIndex.isAlgorithmSupported(keyInfoIdentifier)) {
                throw new IllegalStateException("unable to create CompositePublicKey from SubjectPublicKeyInfo");
            }
            KeyFactorySpi keyInfoConverter = new KeyFactorySpi();
            publicKeyFromFactory = (CompositePublicKey)keyInfoConverter.generatePublic(keyInfo);
            if (publicKeyFromFactory == null) {
                throw new IllegalStateException("unable to create CompositePublicKey from SubjectPublicKeyInfo");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.keys = publicKeyFromFactory.getPublicKeys();
        this.algorithmIdentifier = publicKeyFromFactory.getAlgorithmIdentifier();
        this.providers = null;
    }

    private CompositePublicKey(AlgorithmIdentifier algorithmIdentifier, PublicKey[] keys, Provider[] providers) {
        this.algorithmIdentifier = algorithmIdentifier;
        if (keys.length != 2) {
            throw new IllegalArgumentException("two keys required for composite private key");
        }
        ArrayList<PublicKey> keyList = new ArrayList<PublicKey>(keys.length);
        if (providers == null) {
            for (int i = 0; i < keys.length; ++i) {
                keyList.add(keys[i]);
            }
            this.providers = null;
        } else {
            ArrayList<Provider> providerList = new ArrayList<Provider>(providers.length);
            for (int i = 0; i < keys.length; ++i) {
                providerList.add(providers[i]);
                keyList.add(keys[i]);
            }
            this.providers = Collections.unmodifiableList(providerList);
        }
        this.keys = Collections.unmodifiableList(keyList);
    }

    public List<PublicKey> getPublicKeys() {
        return this.keys;
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    @Override
    public String getAlgorithm() {
        return CompositeIndex.getAlgorithmName(this.algorithmIdentifier.getAlgorithm());
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.algorithmIdentifier.getAlgorithm().on(IANAObjectIdentifiers.id_alg)) {
            try {
                byte[] mldsaKey = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(PublicKeyFactory.createKey(this.keys.get(0).getEncoded())).getPublicKeyData().getBytes();
                byte[] tradKey = org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(org.bouncycastle.crypto.util.PublicKeyFactory.createKey(this.keys.get(1).getEncoded())).getPublicKeyData().getBytes();
                return new SubjectPublicKeyInfo(this.getAlgorithmIdentifier(), Arrays.concatenate(mldsaKey, tradKey)).getEncoded();
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to encode composite public key: " + e.getMessage());
            }
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < this.keys.size(); ++i) {
            if (this.algorithmIdentifier.getAlgorithm().equals(MiscObjectIdentifiers.id_composite_key)) {
                v.add(SubjectPublicKeyInfo.getInstance(this.keys.get(i).getEncoded()));
                continue;
            }
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(this.keys.get(i).getEncoded());
            v.add(keyInfo.getPublicKeyData());
        }
        try {
            return new SubjectPublicKeyInfo(this.algorithmIdentifier, new DERSequence(v)).getEncoded("DER");
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode composite public key: " + e.getMessage());
        }
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CompositePublicKey) {
            boolean isEqual = true;
            CompositePublicKey comparedKey = (CompositePublicKey)o;
            if (!comparedKey.getAlgorithmIdentifier().equals(this.algorithmIdentifier) || !this.keys.equals(comparedKey.keys)) {
                isEqual = false;
            }
            return isEqual;
        }
        return false;
    }

    public static class Builder {
        private final AlgorithmIdentifier algorithmIdentifier;
        private final PublicKey[] keys = new PublicKey[2];
        private final Provider[] providers = new Provider[2];
        private int count = 0;

        private Builder(AlgorithmIdentifier algorithmIdentifier) {
            this.algorithmIdentifier = algorithmIdentifier;
        }

        public Builder addPublicKey(PublicKey key) {
            return this.addPublicKey(key, (Provider)null);
        }

        public Builder addPublicKey(PublicKey key, String providerName) {
            return this.addPublicKey(key, Security.getProvider(providerName));
        }

        public Builder addPublicKey(PublicKey key, Provider provider) {
            if (this.count == this.keys.length) {
                throw new IllegalStateException("only " + this.keys.length + " allowed in composite");
            }
            this.keys[this.count] = key;
            this.providers[this.count++] = provider;
            return this;
        }

        public CompositePublicKey build() {
            if (this.providers[0] == null && this.providers[1] == null) {
                return new CompositePublicKey(this.algorithmIdentifier, this.keys, null);
            }
            return new CompositePublicKey(this.algorithmIdentifier, this.keys, this.providers);
        }
    }
}

