/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.internal.asn1.iana.IANAObjectIdentifiers;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.jcajce.CompositeUtil;
import org.bouncycastle.jcajce.interfaces.MLDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeIndex;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyFactorySpi;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositePrivateKey
implements PrivateKey {
    private final List<PrivateKey> keys;
    private final List<Provider> providers;
    private AlgorithmIdentifier algorithmIdentifier;

    public static Builder builder(ASN1ObjectIdentifier compAlgOid) {
        return new Builder(new AlgorithmIdentifier(compAlgOid));
    }

    public static Builder builder(String algorithmName) {
        return CompositePrivateKey.builder(CompositeUtil.getOid(algorithmName));
    }

    public CompositePrivateKey(PrivateKey ... keys) {
        this(MiscObjectIdentifiers.id_composite_key, keys);
    }

    public CompositePrivateKey(ASN1ObjectIdentifier algorithm, PrivateKey ... keys) {
        this(new AlgorithmIdentifier(algorithm), keys);
    }

    public CompositePrivateKey(AlgorithmIdentifier algorithmIdentifier, PrivateKey ... keys) {
        this.algorithmIdentifier = algorithmIdentifier;
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException("at least one private key must be provided for the composite private key");
        }
        ArrayList<PrivateKey> keyList = new ArrayList<PrivateKey>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            keyList.add(this.processKey(keys[i]));
        }
        this.keys = Collections.unmodifiableList(keyList);
        this.providers = null;
    }

    private PrivateKey processKey(PrivateKey key) {
        if (key instanceof MLDSAPrivateKey) {
            try {
                return ((MLDSAPrivateKey)key).getPrivateKey(true);
            }
            catch (Exception e) {
                return key;
            }
        }
        return key;
    }

    private CompositePrivateKey(AlgorithmIdentifier algorithmIdentifier, PrivateKey[] keys, Provider[] providers) {
        this.algorithmIdentifier = algorithmIdentifier;
        if (keys.length != 2) {
            throw new IllegalArgumentException("two keys required for composite private key");
        }
        ArrayList<PrivateKey> keyList = new ArrayList<PrivateKey>(keys.length);
        if (providers == null) {
            for (int i = 0; i < keys.length; ++i) {
                keyList.add(this.processKey(keys[i]));
            }
            this.providers = null;
        } else {
            ArrayList<Provider> providerList = new ArrayList<Provider>(providers.length);
            for (int i = 0; i < keys.length; ++i) {
                providerList.add(providers[i]);
                keyList.add(this.processKey(keys[i]));
            }
            this.providers = Collections.unmodifiableList(providerList);
        }
        this.keys = Collections.unmodifiableList(keyList);
    }

    public CompositePrivateKey(PrivateKeyInfo keyInfo) {
        CompositePrivateKey privateKeyFromFactory = null;
        ASN1ObjectIdentifier keyInfoIdentifier = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        try {
            if (!CompositeIndex.isAlgorithmSupported(keyInfoIdentifier)) {
                throw new IllegalStateException("Unable to create CompositePrivateKey from PrivateKeyInfo");
            }
            KeyFactorySpi keyInfoConverter = new KeyFactorySpi();
            privateKeyFromFactory = (CompositePrivateKey)keyInfoConverter.generatePrivate(keyInfo);
            if (privateKeyFromFactory == null) {
                throw new IllegalStateException("Unable to create CompositePrivateKey from PrivateKeyInfo");
            }
        }
        catch (IOException e) {
            throw Exceptions.illegalStateException(e.getMessage(), e);
        }
        this.keys = privateKeyFromFactory.getPrivateKeys();
        this.providers = null;
        this.algorithmIdentifier = privateKeyFromFactory.getAlgorithmIdentifier();
    }

    public List<PrivateKey> getPrivateKeys() {
        return this.keys;
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    @Override
    public String getAlgorithm() {
        return CompositeIndex.getAlgorithmName(this.algorithmIdentifier.getAlgorithm());
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        if (this.algorithmIdentifier.getAlgorithm().on(IANAObjectIdentifiers.id_alg)) {
            try {
                byte[] mldsaKey = ((MLDSAPrivateKey)this.keys.get(0)).getSeed();
                PrivateKeyInfo pki = PrivateKeyInfoFactory.createPrivateKeyInfo(PrivateKeyFactory.createKey(this.keys.get(1).getEncoded()));
                byte[] tradKey = pki.getPrivateKey().getOctets();
                if (this.keys.get(1).getAlgorithm().contains("Ed")) {
                    tradKey = ASN1OctetString.getInstance(tradKey).getOctets();
                } else if (this.keys.get(1).getAlgorithm().contains("EC")) {
                    ECPrivateKey ecPrivateKey = ECPrivateKey.getInstance(tradKey);
                    tradKey = new ECPrivateKey(ECNamedCurveTable.getByOID(ASN1ObjectIdentifier.getInstance(ecPrivateKey.getParametersObject())).getCurve().getFieldSize(), ecPrivateKey.getKey(), (ASN1Encodable)ecPrivateKey.getParametersObject()).getEncoded();
                }
                return new PrivateKeyInfo(this.algorithmIdentifier, Arrays.concatenate(mldsaKey, tradKey)).getEncoded();
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to encode composite public key: " + e.getMessage());
            }
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.algorithmIdentifier.getAlgorithm().equals(MiscObjectIdentifiers.id_composite_key)) {
            for (int i = 0; i < this.keys.size(); ++i) {
                PrivateKeyInfo info = PrivateKeyInfo.getInstance(this.keys.get(i).getEncoded());
                v.add(info);
            }
            try {
                return new PrivateKeyInfo(this.algorithmIdentifier, new DERSequence(v)).getEncoded("DER");
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to encode composite private key: " + e.getMessage());
            }
        }
        byte[] keyEncoding = null;
        for (int i = 0; i < this.keys.size(); ++i) {
            PrivateKeyInfo info = PrivateKeyInfo.getInstance(this.keys.get(i).getEncoded());
            keyEncoding = Arrays.concatenate(keyEncoding, info.getPrivateKey().getOctets());
        }
        try {
            return new PrivateKeyInfo(this.algorithmIdentifier, keyEncoding).getEncoded("DER");
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode composite private key: " + e.getMessage());
        }
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CompositePrivateKey) {
            boolean isEqual = true;
            CompositePrivateKey comparedKey = (CompositePrivateKey)o;
            if (!comparedKey.getAlgorithmIdentifier().equals(this.algorithmIdentifier) || !this.keys.equals(comparedKey.keys)) {
                isEqual = false;
            }
            return isEqual;
        }
        return false;
    }

    public static class Builder {
        private final AlgorithmIdentifier algorithmIdentifier;
        private final PrivateKey[] keys = new PrivateKey[2];
        private final Provider[] providers = new Provider[2];
        private int count = 0;

        private Builder(AlgorithmIdentifier algorithmIdentifier) {
            this.algorithmIdentifier = algorithmIdentifier;
        }

        public Builder addPrivateKey(PrivateKey key) {
            return this.addPrivateKey(key, (Provider)null);
        }

        public Builder addPrivateKey(PrivateKey key, String providerName) {
            return this.addPrivateKey(key, Security.getProvider(providerName));
        }

        public Builder addPrivateKey(PrivateKey key, Provider provider) {
            if (this.count == this.keys.length) {
                throw new IllegalStateException("only " + this.keys.length + " allowed in composite");
            }
            this.keys[this.count] = key;
            this.providers[this.count++] = provider;
            return this;
        }

        public CompositePrivateKey build() {
            if (this.providers[0] == null && this.providers[1] == null) {
                return new CompositePrivateKey(this.algorithmIdentifier, this.keys, null);
            }
            return new CompositePrivateKey(this.algorithmIdentifier, this.keys, this.providers);
        }
    }
}

