/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.threshold;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.threshold.Polynomial;
import org.bouncycastle.crypto.threshold.SecretShare;
import org.bouncycastle.crypto.threshold.SecretSplitter;
import org.bouncycastle.crypto.threshold.ShamirSplitSecret;
import org.bouncycastle.crypto.threshold.ShamirSplitSecretShare;
import org.bouncycastle.util.Arrays;

public class ShamirSecretSplitter
implements SecretSplitter {
    private final Polynomial poly;
    protected int l;
    protected SecureRandom random;

    public ShamirSecretSplitter(Algorithm algorithm, Mode mode, int l, SecureRandom random) {
        if (l < 0 || l > 65534) {
            throw new IllegalArgumentException("Invalid input: l ranges from 0 to 65534 (2^16-2) bytes.");
        }
        this.poly = Polynomial.newInstance(algorithm, mode);
        this.l = l;
        this.random = random;
    }

    public ShamirSplitSecret split(int m, int n) {
        int i;
        byte[][] p = this.initP(m, n);
        byte[][] sr = new byte[m][this.l];
        ShamirSplitSecretShare[] secretShares = new ShamirSplitSecretShare[this.l];
        for (i = 0; i < m; ++i) {
            this.random.nextBytes(sr[i]);
        }
        for (i = 0; i < p.length; ++i) {
            secretShares[i] = new ShamirSplitSecretShare(this.poly.gfVecMul(p[i], sr), i + 1);
        }
        return new ShamirSplitSecret(this.poly, secretShares);
    }

    public ShamirSplitSecret splitAround(SecretShare s, int m, int n) throws IOException {
        int i;
        byte[][] p = this.initP(m, n);
        byte[][] sr = new byte[m][this.l];
        ShamirSplitSecretShare[] secretShares = new ShamirSplitSecretShare[this.l];
        byte[] ss0 = s.getEncoded();
        secretShares[0] = new ShamirSplitSecretShare(ss0, 1);
        for (i = 0; i < m; ++i) {
            this.random.nextBytes(sr[i]);
        }
        for (i = 0; i < this.l; ++i) {
            byte tmp = sr[1][i];
            for (int j = 2; j < m; ++j) {
                tmp = (byte)(tmp ^ sr[j][i]);
            }
            sr[0][i] = (byte)(tmp ^ ss0[i]);
        }
        for (i = 1; i < p.length; ++i) {
            secretShares[i] = new ShamirSplitSecretShare(this.poly.gfVecMul(p[i], sr), i + 1);
        }
        return new ShamirSplitSecret(this.poly, secretShares);
    }

    public ShamirSplitSecret resplit(byte[] secret, int m, int n) {
        int i;
        byte[][] p = this.initP(m, n);
        byte[][] sr = new byte[m][this.l];
        ShamirSplitSecretShare[] secretShares = new ShamirSplitSecretShare[this.l];
        sr[0] = Arrays.clone(secret);
        for (i = 1; i < m; ++i) {
            this.random.nextBytes(sr[i]);
        }
        for (i = 0; i < p.length; ++i) {
            secretShares[i] = new ShamirSplitSecretShare(this.poly.gfVecMul(p[i], sr), i + 1);
        }
        return new ShamirSplitSecret(this.poly, secretShares);
    }

    private byte[][] initP(int m, int n) {
        if (m < 1 || m > 255) {
            throw new IllegalArgumentException("Invalid input: m must be less than 256 and positive.");
        }
        if (n < m || n > 255) {
            throw new IllegalArgumentException("Invalid input: n must be less than 256 and greater than or equal to n.");
        }
        byte[][] p = new byte[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                p[i][j] = this.poly.gfPow((byte)(i + 1), (byte)j);
            }
        }
        return p;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Algorithm {
        AES,
        RSA;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        Native,
        Table;

    }
}

