/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.threshold;

import org.bouncycastle.crypto.threshold.Polynomial;
import org.bouncycastle.crypto.threshold.ShamirSecretSplitter;

class PolynomialNative
extends Polynomial {
    private final int IRREDUCIBLE;

    public PolynomialNative(ShamirSecretSplitter.Algorithm algorithm) {
        switch (algorithm) {
            case AES: {
                this.IRREDUCIBLE = 283;
                break;
            }
            case RSA: {
                this.IRREDUCIBLE = 285;
                break;
            }
            default: {
                throw new IllegalArgumentException("The algorithm is not correct");
            }
        }
    }

    protected byte gfMul(int x, int y) {
        int result = 0;
        while (y > 0) {
            if ((y & 1) != 0) {
                result ^= x;
            }
            if (((x <<= 1) & 0x100) != 0) {
                x ^= this.IRREDUCIBLE;
            }
            y >>= 1;
        }
        while (result >= 256) {
            if ((result & 0x100) != 0) {
                result ^= this.IRREDUCIBLE;
            }
            result <<= 1;
        }
        return (byte)(result & 0xFF);
    }

    protected byte gfDiv(int x, int y) {
        return this.gfMul(x, this.gfPow((byte)y, (byte)-2) & 0xFF);
    }
}

