/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.kems;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.kems.SAKKEKEMExtractor;
import org.bouncycastle.crypto.kems.SecretWithEncapsulationImpl;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.SAKKEPublicKeyParameters;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class SAKKEKEMSGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom random;

    public SAKKEKEMSGenerator(SecureRandom random) {
        this.random = random;
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        ECPoint R_bS;
        SAKKEPublicKeyParameters keyParameters = (SAKKEPublicKeyParameters)recipientKey;
        ECPoint Z = keyParameters.getZ();
        BigInteger b = keyParameters.getIdentifier();
        BigInteger p = keyParameters.getPrime();
        BigInteger q = keyParameters.getQ();
        BigInteger g = keyParameters.getG();
        int n = keyParameters.getN();
        ECCurve curve = keyParameters.getCurve();
        ECPoint P = keyParameters.getPoint();
        Digest digest = keyParameters.getDigest();
        BigInteger ssv = BigIntegers.createRandomBigInteger(n, this.random);
        BigInteger r = SAKKEKEMSGenerator.hashToIntegerRange(Arrays.concatenate(ssv.toByteArray(), b.toByteArray()), q, digest);
        BigInteger order = curve.getOrder();
        if (order == null) {
            R_bS = P.multiply(b).add(Z).multiply(r).normalize();
        } else {
            BigInteger a = b.multiply(r).mod(order);
            R_bS = ECAlgorithms.sumOfTwoMultiplies(P, a, Z, r).normalize();
        }
        BigInteger pointX = BigInteger.ONE;
        BigInteger pointY = g;
        BigInteger v0 = BigInteger.ONE;
        BigInteger v1 = g;
        ECPoint current = curve.createPoint(v0, v1);
        for (int i = r.bitLength() - 2; i >= 0; --i) {
            BigInteger[] rlt = SAKKEKEMExtractor.fp2PointSquare(v0, v1, p);
            current = current.timesPow2(2);
            v0 = rlt[0];
            v1 = rlt[1];
            if (!r.testBit(i)) continue;
            rlt = SAKKEKEMExtractor.fp2Multiply(v0, v1, pointX, pointY, p);
            v0 = rlt[0];
            v1 = rlt[1];
        }
        BigInteger v0Inv = BigIntegers.modOddInverse(p, v0);
        BigInteger g_r = v1.multiply(v0Inv).mod(p);
        BigInteger mask = SAKKEKEMSGenerator.hashToIntegerRange(g_r.toByteArray(), BigInteger.ONE.shiftLeft(n), digest);
        BigInteger H = ssv.xor(mask);
        byte[] encapsulated = Arrays.concatenate(R_bS.getEncoded(false), BigIntegers.asUnsignedByteArray(16, H));
        return new SecretWithEncapsulationImpl(BigIntegers.asUnsignedByteArray(n / 8, ssv), encapsulated);
    }

    static BigInteger hashToIntegerRange(byte[] input, BigInteger q, Digest digest) {
        byte[] A = new byte[digest.getDigestSize()];
        digest.update(input, 0, input.length);
        digest.doFinal(A, 0);
        byte[] h = new byte[digest.getDigestSize()];
        int l = q.bitLength() >> 8;
        BigInteger v = BigInteger.ZERO;
        byte[] v_i = new byte[digest.getDigestSize()];
        for (int i = 0; i <= l; ++i) {
            digest.update(h, 0, h.length);
            digest.doFinal(h, 0);
            digest.update(h, 0, h.length);
            digest.update(A, 0, A.length);
            digest.doFinal(v_i, 0);
            v = v.shiftLeft(v_i.length * 8).add(new BigInteger(1, v_i));
        }
        return v.mod(q);
    }
}

