/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.hpke;

import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.modes.ChaCha20Poly1305;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;
import org.bouncycastle.util.Pack;

public class AEAD {
    private final short aeadId;
    private final byte[] key;
    private final byte[] baseNonce;
    private long seq = 0L;
    private AEADCipher cipher;

    public AEAD(short aeadId, byte[] key, byte[] baseNonce) {
        this.key = key;
        this.baseNonce = baseNonce;
        this.aeadId = aeadId;
        this.seq = 0L;
        switch (aeadId) {
            case 1: 
            case 2: {
                this.cipher = GCMBlockCipher.newInstance(AESEngine.newInstance());
                break;
            }
            case 3: {
                this.cipher = new ChaCha20Poly1305();
                break;
            }
        }
    }

    public byte[] seal(byte[] aad, byte[] pt) throws InvalidCipherTextException {
        return this.process(true, aad, pt, 0, pt.length);
    }

    public byte[] seal(byte[] aad, byte[] pt, int ptOffset, int ptLength) throws InvalidCipherTextException {
        Arrays.validateSegment(pt, ptOffset, ptLength);
        return this.process(true, aad, pt, ptOffset, ptLength);
    }

    public byte[] open(byte[] aad, byte[] ct) throws InvalidCipherTextException {
        return this.process(false, aad, ct, 0, ct.length);
    }

    public byte[] open(byte[] aad, byte[] ct, int ctOffset, int ctLength) throws InvalidCipherTextException {
        Arrays.validateSegment(ct, ctOffset, ctLength);
        return this.process(false, aad, ct, ctOffset, ctLength);
    }

    private byte[] computeNonce() {
        byte[] seq_bytes = Pack.longToBigEndian(this.seq++);
        byte[] nonce = Arrays.clone(this.baseNonce);
        Bytes.xorTo(8, seq_bytes, 0, nonce, nonce.length - 8);
        return nonce;
    }

    private byte[] process(boolean forEncryption, byte[] aad, byte[] buf, int off, int len) throws InvalidCipherTextException {
        ParametersWithIV params;
        switch (this.aeadId) {
            case 1: 
            case 2: 
            case 3: {
                params = new ParametersWithIV(new KeyParameter(this.key), this.computeNonce());
                break;
            }
            default: {
                throw new IllegalStateException("Export only mode, cannot be used to seal/open");
            }
        }
        this.cipher.init(forEncryption, params);
        this.cipher.processAADBytes(aad, 0, aad.length);
        byte[] output = new byte[this.cipher.getOutputSize(len)];
        int pos = this.cipher.processBytes(buf, off, len, output, 0);
        pos += this.cipher.doFinal(output, pos);
        if (pos != output.length) {
            throw new IllegalStateException();
        }
        return output;
    }
}

