/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.crypto.engines.AsconPermutationFriend;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;
import org.bouncycastle.util.Pack;

public class ISAPEngine
extends AEADBaseEngine {
    private static final int ISAP_STATE_SZ = 40;
    private byte[] k;
    private byte[] npub;
    private int ISAP_rH;
    private final ISAP_AEAD ISAPAEAD;

    public ISAPEngine(IsapType isapType) {
        this.MAC_SIZE = 16;
        this.IV_SIZE = 16;
        this.KEY_SIZE = 16;
        switch (isapType) {
            case ISAP_A_128A: {
                this.ISAPAEAD = new ISAPAEAD_A_128A();
                this.algorithmName = "ISAP-A-128A AEAD";
                break;
            }
            case ISAP_K_128A: {
                this.ISAPAEAD = new ISAPAEAD_K_128A();
                this.algorithmName = "ISAP-K-128A AEAD";
                break;
            }
            case ISAP_A_128: {
                this.ISAPAEAD = new ISAPAEAD_A_128();
                this.algorithmName = "ISAP-A-128 AEAD";
                break;
            }
            case ISAP_K_128: {
                this.ISAPAEAD = new ISAPAEAD_K_128();
                this.algorithmName = "ISAP-K-128 AEAD";
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect ISAP parameter");
            }
        }
        this.AADBufferSize = this.BlockSize;
        this.setInnerMembers(AEADBaseEngine.ProcessingBufferType.Immediate, AEADBaseEngine.AADOperatorType.Default, AEADBaseEngine.DataOperatorType.Counter);
    }

    protected void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        this.npub = iv;
        this.k = key;
        this.ISAPAEAD.init();
    }

    protected void processBufferAAD(byte[] input, int inOff) {
        this.ISAPAEAD.absorbMacBlock(input, inOff);
    }

    protected void processFinalAAD() {
        this.ISAPAEAD.absorbFinalAADBlock();
    }

    protected void finishAAD(AEADBaseEngine.State nextState, boolean isDoFinal) {
        this.finishAAD3(nextState, isDoFinal);
    }

    protected void processBufferEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.ISAPAEAD.processEncBlock(input, inOff, output, outOff);
        this.ISAPAEAD.absorbMacBlock(output, outOff);
    }

    protected void processBufferDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.ISAPAEAD.processEncBlock(input, inOff, output, outOff);
        this.ISAPAEAD.absorbMacBlock(input, inOff);
    }

    protected void processFinalBlock(byte[] output, int outOff) {
        this.ISAPAEAD.processEncFinalBlock(output, outOff);
        if (this.forEncryption) {
            this.ISAPAEAD.processMACFinal(output, outOff, this.m_bufPos, this.mac);
        } else {
            this.ISAPAEAD.processMACFinal(this.m_buf, 0, this.m_bufPos, this.mac);
        }
    }

    protected void reset(boolean clearMac) {
        super.reset(clearMac);
        this.ISAPAEAD.reset();
    }

    private abstract class ISAPAEAD_A
    implements ISAP_AEAD {
        protected long[] k64;
        protected long[] npub64;
        protected long ISAP_IV1_64;
        protected long ISAP_IV2_64;
        protected long ISAP_IV3_64;
        AsconPermutationFriend.AsconPermutation p;
        AsconPermutationFriend.AsconPermutation mac;

        public ISAPAEAD_A() {
            ISAPEngine.this.ISAP_rH = 64;
            ISAPEngine.this.BlockSize = ISAPEngine.this.ISAP_rH + 7 >> 3;
            this.p = new AsconPermutationFriend.AsconPermutation();
            this.mac = new AsconPermutationFriend.AsconPermutation();
        }

        public void init() {
            this.npub64 = new long[this.getLongSize(ISAPEngine.this.npub.length)];
            this.k64 = new long[this.getLongSize(ISAPEngine.this.k.length)];
            Pack.bigEndianToLong(ISAPEngine.this.npub, 0, this.npub64);
            Pack.bigEndianToLong(ISAPEngine.this.k, 0, this.k64);
        }

        protected abstract void PX1(AsconPermutationFriend.AsconPermutation var1);

        protected abstract void PX2(AsconPermutationFriend.AsconPermutation var1);

        public void absorbMacBlock(byte[] input, int inOff) {
            this.mac.x0 ^= Pack.bigEndianToLong(input, inOff);
            this.mac.p(12);
        }

        public void absorbFinalAADBlock() {
            for (int i = 0; i < ISAPEngine.this.m_aadPos; ++i) {
                this.mac.x0 ^= ((long)ISAPEngine.this.m_aad[i] & 0xFFL) << (7 - i << 3);
            }
            this.mac.x0 ^= 128L << (7 - ISAPEngine.this.m_aadPos << 3);
            this.mac.p(12);
            this.mac.x4 ^= 1L;
        }

        public void processMACFinal(byte[] input, int inOff, int len, byte[] tag) {
            for (int i = 0; i < len; ++i) {
                this.mac.x0 ^= ((long)input[inOff++] & 0xFFL) << (7 - i << 3);
            }
            this.mac.x0 ^= 128L << (7 - len << 3);
            this.mac.p(12);
            Pack.longToBigEndian(this.mac.x0, tag, 0);
            Pack.longToBigEndian(this.mac.x1, tag, 8);
            long tmp_x2 = this.mac.x2;
            long tmp_x3 = this.mac.x3;
            long tmp_x4 = this.mac.x4;
            this.isap_rk(this.mac, this.ISAP_IV2_64, tag, ISAPEngine.this.KEY_SIZE);
            this.mac.x2 = tmp_x2;
            this.mac.x3 = tmp_x3;
            this.mac.x4 = tmp_x4;
            this.mac.p(12);
            Pack.longToBigEndian(this.mac.x0, tag, 0);
            Pack.longToBigEndian(this.mac.x1, tag, 8);
        }

        private void isap_rk(AsconPermutationFriend.AsconPermutation p, long iv64, byte[] y, int ylen) {
            p.set(this.k64[0], this.k64[1], iv64, 0L, 0L);
            p.p(12);
            for (int i = 0; i < (ylen << 3) - 1; ++i) {
                p.x0 ^= ((long)((y[i >>> 3] >>> 7 - (i & 7) & 1) << 7) & 0xFFL) << 56;
                this.PX2(p);
            }
            p.x0 ^= ((long)y[ylen - 1] & 1L) << 7 << 56;
            p.p(12);
        }

        public void processEncBlock(byte[] input, int inOff, byte[] output, int outOff) {
            Pack.longToBigEndian(Pack.bigEndianToLong(input, inOff) ^ this.p.x0, output, outOff);
            this.PX1(this.p);
        }

        public void processEncFinalBlock(byte[] output, int outOff) {
            byte[] xo = Pack.longToLittleEndian(this.p.x0);
            Bytes.xor(ISAPEngine.this.m_bufPos, xo, ISAPEngine.this.BlockSize - ISAPEngine.this.m_bufPos, ISAPEngine.this.m_buf, 0, output, outOff);
        }

        public void reset() {
            this.isap_rk(this.p, this.ISAP_IV3_64, ISAPEngine.this.npub, ISAPEngine.this.IV_SIZE);
            this.p.x3 = this.npub64[0];
            this.p.x4 = this.npub64[1];
            this.PX1(this.p);
            this.mac.set(this.npub64[0], this.npub64[1], this.ISAP_IV1_64, 0L, 0L);
            this.mac.p(12);
        }

        private int getLongSize(int x) {
            return x + 7 >>> 3;
        }
    }

    private class ISAPAEAD_A_128
    extends ISAPAEAD_A {
        public ISAPAEAD_A_128() {
            this.ISAP_IV1_64 = 108156764298152972L;
            this.ISAP_IV2_64 = 180214358336080908L;
            this.ISAP_IV3_64 = 252271952374008844L;
        }

        protected void PX1(AsconPermutationFriend.AsconPermutation p) {
            p.p(12);
        }

        protected void PX2(AsconPermutationFriend.AsconPermutation p) {
            p.p(12);
        }
    }

    private class ISAPAEAD_A_128A
    extends ISAPAEAD_A {
        public ISAPAEAD_A_128A() {
            this.ISAP_IV1_64 = 108156764297430540L;
            this.ISAP_IV2_64 = 180214358335358476L;
            this.ISAP_IV3_64 = 252271952373286412L;
        }

        protected void PX1(AsconPermutationFriend.AsconPermutation p) {
            p.p(6);
        }

        protected void PX2(AsconPermutationFriend.AsconPermutation p) {
            p.round(75L);
        }
    }

    private abstract class ISAPAEAD_K
    implements ISAP_AEAD {
        protected final int ISAP_STATE_SZ_CRYPTO_NPUBBYTES;
        protected short[] ISAP_IV1_16;
        protected short[] ISAP_IV2_16;
        protected short[] ISAP_IV3_16;
        protected short[] k16;
        protected short[] iv16;
        private final int[] KeccakF400RoundConstants;
        protected short[] SX;
        protected short[] macSX;
        protected short[] E;
        protected short[] C;
        protected short[] macE;
        protected short[] macC;

        public ISAPAEAD_K() {
            this.ISAP_STATE_SZ_CRYPTO_NPUBBYTES = 40 - ISAPEngine.this.IV_SIZE;
            this.KeccakF400RoundConstants = new int[]{1, 32898, 32906, 32768, 32907, 1, 32897, 32777, 138, 136, 32777, 10, 32907, 139, 32905, 32771, 32770, 128, 32778, 10};
            this.SX = new short[25];
            this.macSX = new short[25];
            this.E = new short[25];
            this.C = new short[5];
            this.macE = new short[25];
            this.macC = new short[5];
            ISAPEngine.this.ISAP_rH = 144;
            ISAPEngine.this.BlockSize = ISAPEngine.this.ISAP_rH + 7 >> 3;
        }

        public void init() {
            this.k16 = new short[ISAPEngine.this.k.length >> 1];
            Pack.littleEndianToShort(ISAPEngine.this.k, 0, this.k16, 0, this.k16.length);
            this.iv16 = new short[ISAPEngine.this.npub.length >> 1];
            Pack.littleEndianToShort(ISAPEngine.this.npub, 0, this.iv16, 0, this.iv16.length);
        }

        public void reset() {
            Arrays.fill(this.SX, (short)0);
            this.isap_rk(this.ISAP_IV3_16, ISAPEngine.this.npub, ISAPEngine.this.IV_SIZE, this.SX, this.ISAP_STATE_SZ_CRYPTO_NPUBBYTES, this.C);
            System.arraycopy(this.iv16, 0, this.SX, 17, 8);
            this.PermuteRoundsKX(this.SX, this.E, this.C);
            Arrays.fill(this.macSX, 12, 25, (short)0);
            System.arraycopy(this.iv16, 0, this.macSX, 0, 8);
            System.arraycopy(this.ISAP_IV1_16, 0, this.macSX, 8, 4);
            this.PermuteRoundsHX(this.macSX, this.macE, this.macC);
        }

        protected abstract void PermuteRoundsHX(short[] var1, short[] var2, short[] var3);

        protected abstract void PermuteRoundsKX(short[] var1, short[] var2, short[] var3);

        protected abstract void PermuteRoundsBX(short[] var1, short[] var2, short[] var3);

        public void absorbMacBlock(byte[] input, int inOff) {
            this.byteToShortXor(input, inOff, this.macSX, ISAPEngine.this.BlockSize >> 1);
            this.PermuteRoundsHX(this.macSX, this.macE, this.macC);
        }

        public void absorbFinalAADBlock() {
            for (int i = 0; i < ISAPEngine.this.m_aadPos; ++i) {
                int n = i >> 1;
                this.macSX[n] = (short)(this.macSX[n] ^ (ISAPEngine.this.m_aad[i] & 0xFF) << ((i & 1) << 3));
            }
            int n = ISAPEngine.this.m_aadPos >> 1;
            this.macSX[n] = (short)(this.macSX[n] ^ 128 << ((ISAPEngine.this.m_aadPos & 1) << 3));
            this.PermuteRoundsHX(this.macSX, this.macE, this.macC);
            this.macSX[24] = (short)(this.macSX[24] ^ 0x100);
        }

        public void isap_rk(short[] iv16, byte[] y, int ylen, short[] out16, int outlen, short[] C) {
            short[] SX = new short[25];
            short[] E = new short[25];
            System.arraycopy(this.k16, 0, SX, 0, 8);
            System.arraycopy(iv16, 0, SX, 8, 4);
            this.PermuteRoundsKX(SX, E, C);
            for (int i = 0; i < (ylen << 3) - 1; ++i) {
                SX[0] = (short)(SX[0] ^ (y[i >> 3] >>> 7 - (i & 7) & 1) << 7);
                this.PermuteRoundsBX(SX, E, C);
            }
            SX[0] = (short)(SX[0] ^ (y[ylen - 1] & 1) << 7);
            this.PermuteRoundsKX(SX, E, C);
            System.arraycopy(SX, 0, out16, 0, outlen == this.ISAP_STATE_SZ_CRYPTO_NPUBBYTES ? 17 : 8);
        }

        public void processMACFinal(byte[] input, int inOff, int len, byte[] tag) {
            for (int i = 0; i < len; ++i) {
                int n = i >> 1;
                this.macSX[n] = (short)(this.macSX[n] ^ (input[inOff++] & 0xFF) << ((i & 1) << 3));
            }
            int n = len >> 1;
            this.macSX[n] = (short)(this.macSX[n] ^ 128 << ((len & 1) << 3));
            this.PermuteRoundsHX(this.macSX, this.macE, this.macC);
            Pack.shortToLittleEndian(this.macSX, 0, 8, tag, 0);
            this.isap_rk(this.ISAP_IV2_16, tag, ISAPEngine.this.KEY_SIZE, this.macSX, ISAPEngine.this.KEY_SIZE, this.macC);
            this.PermuteRoundsHX(this.macSX, this.macE, this.macC);
            Pack.shortToLittleEndian(this.macSX, 0, 8, tag, 0);
        }

        public void processEncBlock(byte[] input, int inOff, byte[] output, int outOff) {
            for (int i = 0; i < ISAPEngine.this.BlockSize; ++i) {
                output[outOff++] = (byte)(this.SX[i >> 1] >>> ((i & 1) << 3) ^ input[inOff++]);
            }
            this.PermuteRoundsKX(this.SX, this.E, this.C);
        }

        public void processEncFinalBlock(byte[] output, int outOff) {
            for (int i = 0; i < ISAPEngine.this.m_bufPos; ++i) {
                output[outOff++] = (byte)(this.SX[i >> 1] >>> ((i & 1) << 3) ^ ISAPEngine.this.m_buf[i]);
            }
        }

        private void byteToShortXor(byte[] input, int inOff, short[] output, int outLen) {
            for (int i = 0; i < outLen; ++i) {
                int n = i;
                output[n] = (short)(output[n] ^ Pack.littleEndianToShort(input, inOff + (i << 1)));
            }
        }

        protected void rounds12X(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.rounds_8_18(SX, E, C);
        }

        protected void rounds_4_18(short[] SX, short[] E, short[] C) {
            this.thetaRhoPiChiIotaPrepareTheta(4, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(5, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(6, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(7, E, SX, C);
            this.rounds_8_18(SX, E, C);
        }

        protected void rounds_8_18(short[] SX, short[] E, short[] C) {
            this.thetaRhoPiChiIotaPrepareTheta(8, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(9, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(10, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(11, E, SX, C);
            this.rounds_12_18(SX, E, C);
        }

        protected void rounds_12_18(short[] SX, short[] E, short[] C) {
            this.thetaRhoPiChiIotaPrepareTheta(12, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(13, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(14, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(15, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(16, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(17, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(18, SX, E, C);
            this.thetaRhoPiChiIota(E, SX, C);
        }

        protected void prepareThetaX(short[] SX, short[] C) {
            C[0] = (short)(SX[0] ^ SX[5] ^ SX[10] ^ SX[15] ^ SX[20]);
            C[1] = (short)(SX[1] ^ SX[6] ^ SX[11] ^ SX[16] ^ SX[21]);
            C[2] = (short)(SX[2] ^ SX[7] ^ SX[12] ^ SX[17] ^ SX[22]);
            C[3] = (short)(SX[3] ^ SX[8] ^ SX[13] ^ SX[18] ^ SX[23]);
            C[4] = (short)(SX[4] ^ SX[9] ^ SX[14] ^ SX[19] ^ SX[24]);
        }

        private short ROL16(short a, int offset) {
            return (short)((a & 0xFFFF) << offset ^ (a & 0xFFFF) >>> 16 - offset);
        }

        protected void thetaRhoPiChiIotaPrepareTheta(int i, short[] A, short[] E, short[] C) {
            short Da = (short)(C[4] ^ this.ROL16(C[1], 1));
            short De = (short)(C[0] ^ this.ROL16(C[2], 1));
            short Di = (short)(C[1] ^ this.ROL16(C[3], 1));
            short Do = (short)(C[2] ^ this.ROL16(C[4], 1));
            short Du = (short)(C[3] ^ this.ROL16(C[0], 1));
            short Ba = A[0] = (short)(A[0] ^ Da);
            A[6] = (short)(A[6] ^ De);
            short Be = this.ROL16(A[6], 12);
            A[12] = (short)(A[12] ^ Di);
            short Bi = this.ROL16(A[12], 11);
            A[18] = (short)(A[18] ^ Do);
            short Bo = this.ROL16(A[18], 5);
            A[24] = (short)(A[24] ^ Du);
            short Bu = this.ROL16(A[24], 14);
            C[0] = E[0] = (short)(Ba ^ ~Be & Bi ^ this.KeccakF400RoundConstants[i]);
            C[1] = E[1] = (short)(Be ^ ~Bi & Bo);
            C[2] = E[2] = (short)(Bi ^ ~Bo & Bu);
            C[3] = E[3] = (short)(Bo ^ ~Bu & Ba);
            C[4] = E[4] = (short)(Bu ^ ~Ba & Be);
            A[3] = (short)(A[3] ^ Do);
            Ba = this.ROL16(A[3], 12);
            A[9] = (short)(A[9] ^ Du);
            Be = this.ROL16(A[9], 4);
            A[10] = (short)(A[10] ^ Da);
            Bi = this.ROL16(A[10], 3);
            A[16] = (short)(A[16] ^ De);
            Bo = this.ROL16(A[16], 13);
            A[22] = (short)(A[22] ^ Di);
            Bu = this.ROL16(A[22], 13);
            E[5] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[5]);
            E[6] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[6]);
            E[7] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[7]);
            E[8] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[8]);
            E[9] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[9]);
            A[1] = (short)(A[1] ^ De);
            Ba = this.ROL16(A[1], 1);
            A[7] = (short)(A[7] ^ Di);
            Be = this.ROL16(A[7], 6);
            A[13] = (short)(A[13] ^ Do);
            Bi = this.ROL16(A[13], 9);
            A[19] = (short)(A[19] ^ Du);
            Bo = this.ROL16(A[19], 8);
            A[20] = (short)(A[20] ^ Da);
            Bu = this.ROL16(A[20], 2);
            E[10] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[10]);
            E[11] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[11]);
            E[12] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[12]);
            E[13] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[13]);
            E[14] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[14]);
            A[4] = (short)(A[4] ^ Du);
            Ba = this.ROL16(A[4], 11);
            A[5] = (short)(A[5] ^ Da);
            Be = this.ROL16(A[5], 4);
            A[11] = (short)(A[11] ^ De);
            Bi = this.ROL16(A[11], 10);
            A[17] = (short)(A[17] ^ Di);
            Bo = this.ROL16(A[17], 15);
            A[23] = (short)(A[23] ^ Do);
            Bu = this.ROL16(A[23], 8);
            E[15] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[15]);
            E[16] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[16]);
            E[17] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[17]);
            E[18] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[18]);
            E[19] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[19]);
            A[2] = (short)(A[2] ^ Di);
            Ba = this.ROL16(A[2], 14);
            A[8] = (short)(A[8] ^ Do);
            Be = this.ROL16(A[8], 7);
            A[14] = (short)(A[14] ^ Du);
            Bi = this.ROL16(A[14], 7);
            A[15] = (short)(A[15] ^ Da);
            Bo = this.ROL16(A[15], 9);
            A[21] = (short)(A[21] ^ De);
            Bu = this.ROL16(A[21], 2);
            E[20] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[20]);
            E[21] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[21]);
            E[22] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[22]);
            E[23] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[23]);
            E[24] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[24]);
        }

        protected void thetaRhoPiChiIota(short[] A, short[] E, short[] C) {
            short Da = (short)(C[4] ^ this.ROL16(C[1], 1));
            short De = (short)(C[0] ^ this.ROL16(C[2], 1));
            short Di = (short)(C[1] ^ this.ROL16(C[3], 1));
            short Do = (short)(C[2] ^ this.ROL16(C[4], 1));
            short Du = (short)(C[3] ^ this.ROL16(C[0], 1));
            short Ba = A[0] = (short)(A[0] ^ Da);
            A[6] = (short)(A[6] ^ De);
            short Be = this.ROL16(A[6], 12);
            A[12] = (short)(A[12] ^ Di);
            short Bi = this.ROL16(A[12], 11);
            A[18] = (short)(A[18] ^ Do);
            short Bo = this.ROL16(A[18], 5);
            A[24] = (short)(A[24] ^ Du);
            short Bu = this.ROL16(A[24], 14);
            E[0] = (short)(Ba ^ ~Be & Bi ^ this.KeccakF400RoundConstants[19]);
            E[1] = (short)(Be ^ ~Bi & Bo);
            E[2] = (short)(Bi ^ ~Bo & Bu);
            E[3] = (short)(Bo ^ ~Bu & Ba);
            E[4] = (short)(Bu ^ ~Ba & Be);
            A[3] = (short)(A[3] ^ Do);
            Ba = this.ROL16(A[3], 12);
            A[9] = (short)(A[9] ^ Du);
            Be = this.ROL16(A[9], 4);
            A[10] = (short)(A[10] ^ Da);
            Bi = this.ROL16(A[10], 3);
            A[16] = (short)(A[16] ^ De);
            Bo = this.ROL16(A[16], 13);
            A[22] = (short)(A[22] ^ Di);
            Bu = this.ROL16(A[22], 13);
            E[5] = (short)(Ba ^ ~Be & Bi);
            E[6] = (short)(Be ^ ~Bi & Bo);
            E[7] = (short)(Bi ^ ~Bo & Bu);
            E[8] = (short)(Bo ^ ~Bu & Ba);
            E[9] = (short)(Bu ^ ~Ba & Be);
            A[1] = (short)(A[1] ^ De);
            Ba = this.ROL16(A[1], 1);
            A[7] = (short)(A[7] ^ Di);
            Be = this.ROL16(A[7], 6);
            A[13] = (short)(A[13] ^ Do);
            Bi = this.ROL16(A[13], 9);
            A[19] = (short)(A[19] ^ Du);
            Bo = this.ROL16(A[19], 8);
            A[20] = (short)(A[20] ^ Da);
            Bu = this.ROL16(A[20], 2);
            E[10] = (short)(Ba ^ ~Be & Bi);
            E[11] = (short)(Be ^ ~Bi & Bo);
            E[12] = (short)(Bi ^ ~Bo & Bu);
            E[13] = (short)(Bo ^ ~Bu & Ba);
            E[14] = (short)(Bu ^ ~Ba & Be);
            A[4] = (short)(A[4] ^ Du);
            Ba = this.ROL16(A[4], 11);
            A[5] = (short)(A[5] ^ Da);
            Be = this.ROL16(A[5], 4);
            A[11] = (short)(A[11] ^ De);
            Bi = this.ROL16(A[11], 10);
            A[17] = (short)(A[17] ^ Di);
            Bo = this.ROL16(A[17], 15);
            A[23] = (short)(A[23] ^ Do);
            Bu = this.ROL16(A[23], 8);
            E[15] = (short)(Ba ^ ~Be & Bi);
            E[16] = (short)(Be ^ ~Bi & Bo);
            E[17] = (short)(Bi ^ ~Bo & Bu);
            E[18] = (short)(Bo ^ ~Bu & Ba);
            E[19] = (short)(Bu ^ ~Ba & Be);
            A[2] = (short)(A[2] ^ Di);
            Ba = this.ROL16(A[2], 14);
            A[8] = (short)(A[8] ^ Do);
            Be = this.ROL16(A[8], 7);
            A[14] = (short)(A[14] ^ Du);
            Bi = this.ROL16(A[14], 7);
            A[15] = (short)(A[15] ^ Da);
            Bo = this.ROL16(A[15], 9);
            A[21] = (short)(A[21] ^ De);
            Bu = this.ROL16(A[21], 2);
            E[20] = (short)(Ba ^ ~Be & Bi);
            E[21] = (short)(Be ^ ~Bi & Bo);
            E[22] = (short)(Bi ^ ~Bo & Bu);
            E[23] = (short)(Bo ^ ~Bu & Ba);
            E[24] = (short)(Bu ^ ~Ba & Be);
        }
    }

    private class ISAPAEAD_K_128
    extends ISAPAEAD_K {
        public ISAPAEAD_K_128() {
            this.ISAP_IV1_16 = new short[]{-32767, 400, 3092, 3084};
            this.ISAP_IV2_16 = new short[]{-32766, 400, 3092, 3084};
            this.ISAP_IV3_16 = new short[]{-32765, 400, 3092, 3084};
        }

        protected void PermuteRoundsHX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(0, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(1, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(2, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(3, E, SX, C);
            this.rounds_4_18(SX, E, C);
        }

        protected void PermuteRoundsKX(short[] SX, short[] E, short[] C) {
            this.rounds12X(SX, E, C);
        }

        protected void PermuteRoundsBX(short[] SX, short[] E, short[] C) {
            this.rounds12X(SX, E, C);
        }
    }

    private class ISAPAEAD_K_128A
    extends ISAPAEAD_K {
        public ISAPAEAD_K_128A() {
            this.ISAP_IV1_16 = new short[]{-32767, 400, 272, 2056};
            this.ISAP_IV2_16 = new short[]{-32766, 400, 272, 2056};
            this.ISAP_IV3_16 = new short[]{-32765, 400, 272, 2056};
        }

        protected void PermuteRoundsHX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.rounds_4_18(SX, E, C);
        }

        protected void PermuteRoundsKX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.rounds_12_18(SX, E, C);
        }

        protected void PermuteRoundsBX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(19, SX, E, C);
            System.arraycopy(E, 0, SX, 0, E.length);
        }
    }

    private static interface ISAP_AEAD {
        public void init();

        public void reset();

        public void absorbMacBlock(byte[] var1, int var2);

        public void absorbFinalAADBlock();

        public void processEncBlock(byte[] var1, int var2, byte[] var3, int var4);

        public void processEncFinalBlock(byte[] var1, int var2);

        public void processMACFinal(byte[] var1, int var2, int var3, byte[] var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IsapType {
        ISAP_A_128A,
        ISAP_K_128A,
        ISAP_A_128,
        ISAP_K_128;

    }
}

