/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.crypto.engines.AsconPermutationFriend;

abstract class AsconBaseEngine
extends AEADBaseEngine {
    protected int nr;
    protected long K0;
    protected long K1;
    protected long N0;
    protected long N1;
    protected long ASCON_IV;
    AsconPermutationFriend.AsconPermutation p = new AsconPermutationFriend.AsconPermutation();
    protected long dsep;

    AsconBaseEngine() {
    }

    protected abstract long pad(int var1);

    protected abstract long loadBytes(byte[] var1, int var2);

    protected abstract void setBytes(long var1, byte[] var3, int var4);

    protected abstract void ascon_aeadinit();

    protected void finishAAD(AEADBaseEngine.State nextState, boolean isDofinal) {
        switch (this.m_state.ord) {
            case 2: 
            case 6: {
                this.processFinalAAD();
                this.p.p(this.nr);
                break;
            }
        }
        this.p.x4 ^= this.dsep;
        this.m_aadPos = 0;
        this.m_state = nextState;
    }

    protected abstract void processFinalDecrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void processFinalEncrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected void processBufferAAD(byte[] buffer, int inOff) {
        this.p.x0 ^= this.loadBytes(buffer, inOff);
        if (this.BlockSize == 16) {
            this.p.x1 ^= this.loadBytes(buffer, 8 + inOff);
        }
        this.p.p(this.nr);
    }

    protected void processFinalBlock(byte[] output, int outOff) {
        if (this.forEncryption) {
            this.processFinalEncrypt(this.m_buf, this.m_bufPos, output, outOff);
        } else {
            this.processFinalDecrypt(this.m_buf, this.m_bufPos, output, outOff);
        }
        this.setBytes(this.p.x3, this.mac, 0);
        this.setBytes(this.p.x4, this.mac, 8);
    }

    protected void processBufferDecrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        long t0 = this.loadBytes(buffer, bufOff);
        this.setBytes(this.p.x0 ^ t0, output, outOff);
        this.p.x0 = t0;
        if (this.BlockSize == 16) {
            long t1 = this.loadBytes(buffer, bufOff + 8);
            this.setBytes(this.p.x1 ^ t1, output, outOff + 8);
            this.p.x1 = t1;
        }
        this.p.p(this.nr);
    }

    protected void processBufferEncrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        this.p.x0 ^= this.loadBytes(buffer, bufOff);
        this.setBytes(this.p.x0, output, outOff);
        if (this.BlockSize == 16) {
            this.p.x1 ^= this.loadBytes(buffer, bufOff + 8);
            this.setBytes(this.p.x1, output, outOff + 8);
        }
        this.p.p(this.nr);
    }

    protected void reset(boolean clearMac) {
        super.reset(clearMac);
        this.ascon_aeadinit();
    }

    public abstract String getAlgorithmVersion();
}

