/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.bc;

import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.util.Arrays;

public class ExternalValue
extends ASN1Object {
    private final GeneralNames location;
    private final AlgorithmIdentifier hashAlg;
    private final byte[] hashValue;

    public ExternalValue(GeneralName location, AlgorithmIdentifier hashAlg, byte[] hashVal) {
        this.location = new GeneralNames(location);
        this.hashAlg = hashAlg;
        this.hashValue = Arrays.clone(hashVal);
    }

    private ExternalValue(ASN1Sequence seq) {
        if (seq.size() == 3) {
            this.location = GeneralNames.getInstance(seq.getObjectAt(0));
            this.hashAlg = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
            this.hashValue = seq.getObjectAt(2) instanceof ASN1BitString ? ASN1BitString.getInstance(seq.getObjectAt(2)).getOctets() : ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets();
        } else {
            throw new IllegalArgumentException("unknown sequence");
        }
    }

    public static ExternalValue getInstance(Object o) {
        if (o instanceof ExternalValue) {
            return (ExternalValue)o;
        }
        if (o != null) {
            return new ExternalValue(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public GeneralName getLocation() {
        return this.location.getNames()[0];
    }

    public GeneralName[] getLocations() {
        return this.location.getNames();
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.hashAlg;
    }

    public byte[] getHashValue() {
        return Arrays.clone(this.hashValue);
    }

    public ASN1BitString getHashVal() {
        return new DERBitString(this.hashValue);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.location);
        v.add(this.hashAlg);
        v.add(new DEROctetString(this.hashValue));
        return new DERSequence(v);
    }
}

