/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.OIDTokenizer;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

public class ASN1RelativeOID
extends ASN1Primitive {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1RelativeOID.class, 13){

        ASN1Primitive fromImplicitPrimitive(DEROctetString octetString) {
            return ASN1RelativeOID.createPrimitive(octetString.getOctets(), false);
        }
    };
    private static final int MAX_CONTENTS_LENGTH = 4096;
    private static final int MAX_IDENTIFIER_LENGTH = 16383;
    private static final long LONG_LIMIT = 0xFFFFFFFFFFFF80L;
    private static final ConcurrentMap<ASN1ObjectIdentifier.OidHandle, ASN1RelativeOID> pool = new ConcurrentHashMap<ASN1ObjectIdentifier.OidHandle, ASN1RelativeOID>();
    private final byte[] contents;
    private String identifier;

    public static ASN1RelativeOID fromContents(byte[] contents) {
        if (contents == null) {
            throw new NullPointerException("'contents' cannot be null");
        }
        return ASN1RelativeOID.createPrimitive(contents, true);
    }

    public static ASN1RelativeOID getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1RelativeOID) {
            return (ASN1RelativeOID)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (primitive instanceof ASN1RelativeOID) {
                return (ASN1RelativeOID)primitive;
            }
        } else if (obj instanceof byte[]) {
            byte[] enc = (byte[])obj;
            try {
                return (ASN1RelativeOID)TYPE.fromByteArray(enc);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct relative OID from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1RelativeOID getInstance(ASN1TaggedObject taggedObject, boolean declaredExplicit) {
        return (ASN1RelativeOID)TYPE.getContextTagged(taggedObject, declaredExplicit);
    }

    public static ASN1RelativeOID getTagged(ASN1TaggedObject taggedObject, boolean declaredExplicit) {
        return (ASN1RelativeOID)TYPE.getTagged(taggedObject, declaredExplicit);
    }

    public static ASN1RelativeOID tryFromID(String identifier) {
        byte[] contents;
        if (identifier == null) {
            throw new NullPointerException("'identifier' cannot be null");
        }
        if (identifier.length() <= 16383 && ASN1RelativeOID.isValidIdentifier(identifier, 0) && (contents = ASN1RelativeOID.parseIdentifier(identifier)).length <= 4096) {
            return new ASN1RelativeOID(contents, identifier);
        }
        return null;
    }

    public ASN1RelativeOID(String identifier) {
        ASN1RelativeOID.checkIdentifier(identifier);
        byte[] contents = ASN1RelativeOID.parseIdentifier(identifier);
        ASN1RelativeOID.checkContentsLength(contents.length);
        this.contents = contents;
        this.identifier = identifier;
    }

    private ASN1RelativeOID(byte[] contents, String identifier) {
        this.contents = contents;
        this.identifier = identifier;
    }

    public ASN1RelativeOID branch(String branchID) {
        byte[] contents;
        ASN1RelativeOID.checkIdentifier(branchID);
        if (branchID.length() <= 2) {
            ASN1RelativeOID.checkContentsLength(this.contents.length + 1);
            int subID = branchID.charAt(0) - 48;
            if (branchID.length() == 2) {
                subID *= 10;
                subID += branchID.charAt(1) - 48;
            }
            contents = Arrays.append(this.contents, (byte)subID);
        } else {
            byte[] branchContents = ASN1RelativeOID.parseIdentifier(branchID);
            ASN1RelativeOID.checkContentsLength(this.contents.length + branchContents.length);
            contents = Arrays.concatenate(this.contents, branchContents);
        }
        String rootID = this.getId();
        String identifier = rootID + "." + branchID;
        return new ASN1RelativeOID(contents, identifier);
    }

    public synchronized String getId() {
        if (this.identifier == null) {
            this.identifier = ASN1RelativeOID.parseContents(this.contents);
        }
        return this.identifier;
    }

    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    public String toString() {
        return this.getId();
    }

    boolean asn1Equals(ASN1Primitive other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ASN1RelativeOID)) {
            return false;
        }
        ASN1RelativeOID that = (ASN1RelativeOID)other;
        return Arrays.areEqual(this.contents, that.contents);
    }

    int encodedLength(boolean withTag) {
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.contents.length);
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodingDL(withTag, 13, this.contents);
    }

    boolean encodeConstructed() {
        return false;
    }

    static void checkContentsLength(int contentsLength) {
        if (contentsLength > 4096) {
            throw new IllegalArgumentException("exceeded relative OID contents length limit");
        }
    }

    static void checkIdentifier(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("'identifier' cannot be null");
        }
        if (identifier.length() > 16383) {
            throw new IllegalArgumentException("exceeded relative OID contents length limit");
        }
        if (!ASN1RelativeOID.isValidIdentifier(identifier, 0)) {
            throw new IllegalArgumentException("string " + identifier + " not a valid relative OID");
        }
    }

    static ASN1RelativeOID createPrimitive(byte[] contents, boolean clone) {
        ASN1RelativeOID.checkContentsLength(contents.length);
        ASN1ObjectIdentifier.OidHandle hdl = new ASN1ObjectIdentifier.OidHandle(contents);
        ASN1RelativeOID oid = (ASN1RelativeOID)pool.get(hdl);
        if (oid != null) {
            return oid;
        }
        if (!ASN1RelativeOID.isValidContents(contents)) {
            throw new IllegalArgumentException("invalid relative OID contents");
        }
        return new ASN1RelativeOID(clone ? Arrays.clone(contents) : contents, null);
    }

    static boolean isValidContents(byte[] contents) {
        if (Properties.isOverrideSet("org.bouncycastle.asn1.allow_wrong_oid_enc")) {
            return true;
        }
        if (contents.length < 1) {
            return false;
        }
        boolean subIDStart = true;
        for (int i = 0; i < contents.length; ++i) {
            if (subIDStart && (contents[i] & 0xFF) == 128) {
                return false;
            }
            subIDStart = (contents[i] & 0x80) == 0;
        }
        return subIDStart;
    }

    static boolean isValidIdentifier(String identifier, int from) {
        int digitCount = 0;
        int pos = identifier.length();
        while (--pos >= from) {
            char ch = identifier.charAt(pos);
            if (ch == '.') {
                if (0 == digitCount || digitCount > 1 && identifier.charAt(pos + 1) == '0') {
                    return false;
                }
                digitCount = 0;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                ++digitCount;
                continue;
            }
            return false;
        }
        return 0 != digitCount && (digitCount <= true || identifier.charAt(pos + 1) != '0');
    }

    static String parseContents(byte[] contents) {
        StringBuilder objId = new StringBuilder();
        long value = 0L;
        BigInteger bigValue = null;
        boolean first = true;
        for (int i = 0; i != contents.length; ++i) {
            int b = contents[i] & 0xFF;
            if (value <= 0xFFFFFFFFFFFF80L) {
                value += (long)(b & 0x7F);
                if ((b & 0x80) == 0) {
                    if (first) {
                        first = false;
                    } else {
                        objId.append('.');
                    }
                    objId.append(value);
                    value = 0L;
                    continue;
                }
                value <<= 7;
                continue;
            }
            if (bigValue == null) {
                bigValue = BigInteger.valueOf(value);
            }
            bigValue = bigValue.or(BigInteger.valueOf(b & 0x7F));
            if ((b & 0x80) == 0) {
                if (first) {
                    first = false;
                } else {
                    objId.append('.');
                }
                objId.append(bigValue);
                bigValue = null;
                value = 0L;
                continue;
            }
            bigValue = bigValue.shiftLeft(7);
        }
        return objId.toString();
    }

    static byte[] parseIdentifier(String identifier) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OIDTokenizer tok = new OIDTokenizer(identifier);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.length() <= 18) {
                ASN1RelativeOID.writeField(bOut, Long.parseLong(token));
                continue;
            }
            ASN1RelativeOID.writeField(bOut, new BigInteger(token));
        }
        return bOut.toByteArray();
    }

    static void writeField(ByteArrayOutputStream out, long fieldValue) {
        byte[] result = new byte[9];
        int pos = 8;
        result[pos] = (byte)((int)fieldValue & 0x7F);
        while (fieldValue >= 128L) {
            result[--pos] = (byte)((int)(fieldValue >>= 7) | 0x80);
        }
        out.write(result, pos, 9 - pos);
    }

    static void writeField(ByteArrayOutputStream out, BigInteger fieldValue) {
        int byteCount = (fieldValue.bitLength() + 6) / 7;
        if (byteCount == 0) {
            out.write(0);
        } else {
            BigInteger tmpValue = fieldValue;
            byte[] tmp = new byte[byteCount];
            for (int i = byteCount - 1; i >= 0; --i) {
                tmp[i] = (byte)(tmpValue.intValue() | 0x80);
                tmpValue = tmpValue.shiftRight(7);
            }
            int n = byteCount - 1;
            tmp[n] = (byte)(tmp[n] & 0x7F);
            out.write(tmp, 0, tmp.length);
        }
    }
}

