/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class ElephantEngine
implements AEADCipher {
    private boolean forEncryption;
    private final String algorithmName;
    private final ElephantParameters parameters;
    private final int BLOCK_SIZE;
    private int nBits;
    private int nSBox;
    private final int nRounds;
    private byte lfsrIV;
    private byte[] tag;
    private byte[] npub;
    private byte[] expanded_key;
    private final byte CRYPTO_KEYBYTES = (byte)16;
    private final byte CRYPTO_NPUBBYTES = (byte)12;
    private final byte CRYPTO_ABYTES;
    private boolean initialised;
    private int nb_its;
    private byte[] ad;
    private int adOff;
    private int adlen;
    private final byte[] tag_buffer;
    private byte[] previous_mask;
    private byte[] current_mask;
    private byte[] next_mask;
    private final byte[] buffer;
    private final byte[] previous_outputMessage;
    private State m_state = State.Uninitialized;
    private final ByteArrayOutputStream aadData = new ByteArrayOutputStream();
    private int inputOff;
    private byte[] inputMessage;
    private int messageLen;
    private final byte[] sBoxLayer = new byte[]{-18, -19, -21, -32, -30, -31, -28, -17, -25, -22, -24, -27, -23, -20, -29, -26, -34, -35, -37, -48, -46, -47, -44, -33, -41, -38, -40, -43, -39, -36, -45, -42, -66, -67, -69, -80, -78, -79, -76, -65, -73, -70, -72, -75, -71, -68, -77, -74, 14, 13, 11, 0, 2, 1, 4, 15, 7, 10, 8, 5, 9, 12, 3, 6, 46, 45, 43, 32, 34, 33, 36, 47, 39, 42, 40, 37, 41, 44, 35, 38, 30, 29, 27, 16, 18, 17, 20, 31, 23, 26, 24, 21, 25, 28, 19, 22, 78, 77, 75, 64, 66, 65, 68, 79, 71, 74, 72, 69, 73, 76, 67, 70, -2, -3, -5, -16, -14, -15, -12, -1, -9, -6, -8, -11, -7, -4, -13, -10, 126, 125, 123, 112, 114, 113, 116, 127, 119, 122, 120, 117, 121, 124, 115, 118, -82, -83, -85, -96, -94, -95, -92, -81, -89, -86, -88, -91, -87, -84, -93, -90, -114, -115, -117, -128, -126, -127, -124, -113, -121, -118, -120, -123, -119, -116, -125, -122, 94, 93, 91, 80, 82, 81, 84, 95, 87, 90, 88, 85, 89, 92, 83, 86, -98, -99, -101, -112, -110, -111, -108, -97, -105, -102, -104, -107, -103, -100, -109, -106, -50, -51, -53, -64, -62, -63, -60, -49, -57, -54, -56, -59, -55, -52, -61, -58, 62, 61, 59, 48, 50, 49, 52, 63, 55, 58, 56, 53, 57, 60, 51, 54, 110, 109, 107, 96, 98, 97, 100, 111, 103, 106, 104, 101, 105, 108, 99, 102};
    private final byte[] KeccakRoundConstants = new byte[]{1, -126, -118, 0, -117, 1, -127, 9, -118, -120, 9, 10, -117, -117, -119, 3, 2, -128};
    private final int[] KeccakRhoOffsets = new int[]{0, 1, 6, 4, 3, 4, 4, 6, 7, 4, 3, 2, 3, 1, 7, 1, 5, 7, 5, 0, 2, 2, 5, 0, 6};

    public ElephantEngine(ElephantParameters parameters) {
        switch (parameters) {
            case elephant160: {
                this.BLOCK_SIZE = 20;
                this.nBits = 160;
                this.nSBox = 20;
                this.nRounds = 80;
                this.lfsrIV = (byte)117;
                this.CRYPTO_ABYTES = (byte)8;
                this.algorithmName = "Elephant 160 AEAD";
                break;
            }
            case elephant176: {
                this.BLOCK_SIZE = 22;
                this.nBits = 176;
                this.nSBox = 22;
                this.nRounds = 90;
                this.lfsrIV = (byte)69;
                this.algorithmName = "Elephant 176 AEAD";
                this.CRYPTO_ABYTES = (byte)8;
                break;
            }
            case elephant200: {
                this.BLOCK_SIZE = 25;
                this.nRounds = 18;
                this.algorithmName = "Elephant 200 AEAD";
                this.CRYPTO_ABYTES = (byte)16;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Elephant");
            }
        }
        this.parameters = parameters;
        this.tag_buffer = new byte[this.BLOCK_SIZE];
        this.previous_mask = new byte[this.BLOCK_SIZE];
        this.current_mask = new byte[this.BLOCK_SIZE];
        this.next_mask = new byte[this.BLOCK_SIZE];
        this.buffer = new byte[this.BLOCK_SIZE];
        this.previous_outputMessage = new byte[this.BLOCK_SIZE];
        this.initialised = false;
        this.reset(false);
    }

    private void permutation(byte[] state) {
        switch (this.parameters) {
            case elephant160: 
            case elephant176: {
                byte IV = this.lfsrIV;
                byte[] tmp = new byte[this.nSBox];
                for (int i = 0; i < this.nRounds; ++i) {
                    state[0] = (byte)(state[0] ^ IV);
                    int n = this.nSBox - 1;
                    state[n] = (byte)(state[n] ^ (byte)((IV & 1) << 7 | (IV & 2) << 5 | (IV & 4) << 3 | (IV & 8) << 1 | (IV & 0x10) >>> 1 | (IV & 0x20) >>> 3 | (IV & 0x40) >>> 5 | (IV & 0x80) >>> 7));
                    IV = (byte)((IV << 1 | (0x40 & IV) >>> 6 ^ (0x20 & IV) >>> 5) & 0x7F);
                    for (int j = 0; j < this.nSBox; ++j) {
                        state[j] = this.sBoxLayer[state[j] & 0xFF];
                    }
                    Arrays.fill(tmp, (byte)0);
                    for (int j = 0; j < this.nSBox; ++j) {
                        for (int k = 0; k < 8; ++k) {
                            int PermutedBitNo = (j << 3) + k;
                            if (PermutedBitNo != this.nBits - 1) {
                                PermutedBitNo = (PermutedBitNo * this.nBits >> 2) % (this.nBits - 1);
                            }
                            int n2 = PermutedBitNo >>> 3;
                            tmp[n2] = (byte)(tmp[n2] ^ ((state[j] & 0xFF) >>> k & 1) << (PermutedBitNo & 7));
                        }
                    }
                    System.arraycopy(tmp, 0, state, 0, this.nSBox);
                }
                break;
            }
            case elephant200: {
                for (int i = 0; i < this.nRounds; ++i) {
                    this.KeccakP200Round(state, i);
                }
                break;
            }
        }
    }

    private byte rotl(byte b) {
        return (byte)((b & 0xFF) << 1 | (b & 0xFF) >>> 7);
    }

    private byte ROL8(byte a, int offset) {
        return (byte)(offset != 0 ? (a & 0xFF) << offset ^ (a & 0xFF) >>> 8 - offset : a);
    }

    private int index(int x, int y) {
        return x + y * 5;
    }

    private void KeccakP200Round(byte[] state, int indexRound) {
        int y;
        int x;
        byte[] tempA = new byte[25];
        for (x = 0; x < 5; ++x) {
            for (y = 0; y < 5; ++y) {
                int n = x;
                tempA[n] = (byte)(tempA[n] ^ state[this.index(x, y)]);
            }
        }
        for (x = 0; x < 5; ++x) {
            tempA[x + 5] = (byte)(this.ROL8(tempA[(x + 1) % 5], 1) ^ tempA[(x + 4) % 5]);
        }
        for (x = 0; x < 5; ++x) {
            for (y = 0; y < 5; ++y) {
                int n = this.index(x, y);
                state[n] = (byte)(state[n] ^ tempA[x + 5]);
            }
        }
        for (x = 0; x < 5; ++x) {
            for (y = 0; y < 5; ++y) {
                tempA[this.index((int)x, (int)y)] = this.ROL8(state[this.index(x, y)], this.KeccakRhoOffsets[this.index(x, y)]);
            }
        }
        for (x = 0; x < 5; ++x) {
            for (y = 0; y < 5; ++y) {
                state[this.index((int)y, (int)((2 * x + 3 * y) % 5))] = tempA[this.index(x, y)];
            }
        }
        for (y = 0; y < 5; ++y) {
            for (x = 0; x < 5; ++x) {
                tempA[x] = (byte)(state[this.index(x, y)] ^ ~state[this.index((x + 1) % 5, y)] & state[this.index((x + 2) % 5, y)]);
            }
            for (x = 0; x < 5; ++x) {
                state[this.index((int)x, (int)y)] = tempA[x];
            }
        }
        state[0] = (byte)(state[0] ^ this.KeccakRoundConstants[indexRound]);
    }

    private void lfsr_step(byte[] output, byte[] input) {
        switch (this.parameters) {
            case elephant160: {
                output[this.BLOCK_SIZE - 1] = (byte)(((input[0] & 0xFF) << 3 | (input[0] & 0xFF) >>> 5) ^ (input[3] & 0xFF) << 7 ^ (input[13] & 0xFF) >>> 7);
                break;
            }
            case elephant176: {
                output[this.BLOCK_SIZE - 1] = (byte)(this.rotl(input[0]) ^ (input[3] & 0xFF) << 7 ^ (input[19] & 0xFF) >>> 7);
                break;
            }
            case elephant200: {
                output[this.BLOCK_SIZE - 1] = (byte)(this.rotl(input[0]) ^ this.rotl(input[2]) ^ input[13] << 1);
            }
        }
        System.arraycopy(input, 1, output, 0, this.BLOCK_SIZE - 1);
    }

    private void xor_block(byte[] state, byte[] block, int bOff, int size) {
        for (int i = 0; i < size; ++i) {
            int n = i;
            state[n] = (byte)(state[n] ^ block[i + bOff]);
        }
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException(this.algorithmName + " init parameters must include an IV");
        }
        ParametersWithIV ivParams = (ParametersWithIV)params;
        this.npub = ivParams.getIV();
        if (this.npub == null || this.npub.length != 12) {
            throw new IllegalArgumentException(this.algorithmName + " requires exactly 12 bytes of IV");
        }
        if (!(ivParams.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException(this.algorithmName + " init parameters must include a key");
        }
        KeyParameter key = (KeyParameter)ivParams.getParameters();
        byte[] k = key.getKey();
        if (k.length != 16) {
            throw new IllegalArgumentException(this.algorithmName + " key must be 128 bits long");
        }
        this.expanded_key = new byte[this.BLOCK_SIZE];
        System.arraycopy(k, 0, this.expanded_key, 0, 16);
        this.permutation(this.expanded_key);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.initialised = true;
        this.m_state = forEncryption ? State.EncInit : State.DecInit;
        this.inputMessage = new byte[this.BLOCK_SIZE + (forEncryption ? (byte)0 : this.CRYPTO_ABYTES)];
        this.reset(false);
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void processAADByte(byte input) {
        this.aadData.write(input);
    }

    public void processAADBytes(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.aadData.write(input, inOff, len);
    }

    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{input}, 0, 1, output, outOff);
    }

    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (this.inputOff + len - (this.forEncryption ? (byte)0 : this.CRYPTO_ABYTES) >= this.BLOCK_SIZE) {
            int mlen = this.inputOff + len - (this.forEncryption ? (byte)0 : this.CRYPTO_ABYTES);
            int adlen = this.processAADBytes();
            int nblocks_c = 1 + mlen / this.BLOCK_SIZE;
            int nblocks_m = mlen % this.BLOCK_SIZE != 0 ? nblocks_c : nblocks_c - 1;
            int nblocks_ad = 1 + (12 + adlen) / this.BLOCK_SIZE;
            int nb_it = Math.max(nblocks_c + 1, nblocks_ad - 1);
            byte[] tempInput = new byte[Math.max(nblocks_c, 1) * this.BLOCK_SIZE];
            System.arraycopy(this.inputMessage, 0, tempInput, 0, this.inputOff);
            System.arraycopy(input, inOff, tempInput, this.inputOff, Math.min(len, tempInput.length));
            int rv = this.processBytes(tempInput, output, outOff, nb_it, nblocks_m, nblocks_c, mlen, nblocks_ad, false);
            int copyLen = rv - this.inputOff;
            this.inputOff = this.inputOff + len - rv;
            System.arraycopy(input, inOff + copyLen, this.inputMessage, 0, this.inputOff);
            this.messageLen += rv;
            return rv;
        }
        System.arraycopy(input, inOff, this.inputMessage, this.inputOff, len);
        this.inputOff += len;
        return 0;
    }

    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        if (!this.initialised) {
            throw new IllegalArgumentException(this.algorithmName + " needs call init function before doFinal");
        }
        int len = this.inputOff;
        if (this.forEncryption && len + outOff + this.CRYPTO_ABYTES > output.length || !this.forEncryption && len + outOff - this.CRYPTO_ABYTES > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        int mlen = len + this.messageLen - (this.forEncryption ? (byte)0 : this.CRYPTO_ABYTES);
        int adlen = this.processAADBytes();
        int nblocks_c = 1 + mlen / this.BLOCK_SIZE;
        int nblocks_m = mlen % this.BLOCK_SIZE != 0 ? nblocks_c : nblocks_c - 1;
        int nblocks_ad = 1 + (12 + adlen) / this.BLOCK_SIZE;
        int nb_it = Math.max(nblocks_c + 1, nblocks_ad - 1);
        outOff += this.processBytes(this.inputMessage, output, outOff, nb_it, nblocks_m, nblocks_c, mlen, nblocks_ad, true);
        this.tag = new byte[this.CRYPTO_ABYTES];
        this.xor_block(this.tag_buffer, this.expanded_key, 0, this.BLOCK_SIZE);
        this.permutation(this.tag_buffer);
        this.xor_block(this.tag_buffer, this.expanded_key, 0, this.BLOCK_SIZE);
        if (this.forEncryption) {
            System.arraycopy(this.tag_buffer, 0, this.tag, 0, this.CRYPTO_ABYTES);
            System.arraycopy(this.tag, 0, output, outOff, this.tag.length);
            mlen += this.CRYPTO_ABYTES;
        } else {
            this.inputOff -= this.CRYPTO_ABYTES;
            for (int i = 0; i < this.CRYPTO_ABYTES; ++i) {
                if (this.tag_buffer[i] == this.inputMessage[this.inputOff + i]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
        }
        this.reset(false);
        return mlen;
    }

    public byte[] getMac() {
        return this.tag;
    }

    public int getUpdateOutputSize(int len) {
        switch (this.m_state) {
            case Uninitialized: {
                throw new IllegalArgumentException(this.algorithmName + " needs call init function before getUpdateOutputSize");
            }
            case DecFinal: 
            case EncFinal: {
                return 0;
            }
            case EncAad: 
            case EncData: 
            case EncInit: {
                return this.inputOff + len + this.CRYPTO_ABYTES;
            }
        }
        return Math.max(0, len + this.inputOff - this.CRYPTO_ABYTES);
    }

    public int getOutputSize(int len) {
        switch (this.m_state) {
            case Uninitialized: {
                throw new IllegalArgumentException(this.algorithmName + " needs call init function before getUpdateOutputSize");
            }
            case DecFinal: 
            case EncFinal: {
                return 0;
            }
            case EncAad: 
            case EncData: 
            case EncInit: {
                return len + this.CRYPTO_ABYTES;
            }
        }
        return Math.max(0, len - this.CRYPTO_ABYTES);
    }

    public void reset() {
        this.reset(true);
    }

    private int processAADBytes() {
        byte[] ad = this.aadData.toByteArray();
        switch (this.m_state) {
            case EncInit: 
            case DecInit: {
                this.processAADBytes(this.tag_buffer);
            }
        }
        return ad.length;
    }

    private void reset(boolean clearMac) {
        if (clearMac) {
            this.tag = null;
        }
        this.aadData.reset();
        Arrays.fill(this.tag_buffer, (byte)0);
        Arrays.fill(this.previous_outputMessage, (byte)0);
        this.inputOff = 0;
        this.nb_its = 0;
        this.adOff = -1;
        this.messageLen = 0;
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 12;
    }

    public int getBlockSize() {
        return this.CRYPTO_ABYTES;
    }

    private void checkAad() {
        switch (this.m_state) {
            case DecData: {
                throw new IllegalArgumentException(this.algorithmName + " cannot process AAD when the length of the plaintext to be processed exceeds the a block size");
            }
            case EncData: {
                throw new IllegalArgumentException(this.algorithmName + " cannot process AAD when the length of the ciphertext to be processed exceeds the a block size");
            }
            case EncFinal: {
                throw new IllegalArgumentException(this.algorithmName + " cannot be reused for encryption");
            }
        }
    }

    private void processAADBytes(byte[] output) {
        this.checkAad();
        if (this.adOff == -1) {
            this.adlen = this.aadData.size();
            this.ad = this.aadData.toByteArray();
            this.adOff = 0;
        }
        int len = 0;
        switch (this.m_state) {
            case DecInit: {
                System.arraycopy(this.expanded_key, 0, this.current_mask, 0, this.BLOCK_SIZE);
                System.arraycopy(this.npub, 0, output, 0, 12);
                len += 12;
                this.m_state = State.DecAad;
                break;
            }
            case EncInit: {
                System.arraycopy(this.expanded_key, 0, this.current_mask, 0, this.BLOCK_SIZE);
                System.arraycopy(this.npub, 0, output, 0, 12);
                len += 12;
                this.m_state = State.EncAad;
                break;
            }
            case EncAad: 
            case DecAad: {
                if (this.adOff != this.adlen) break;
                Arrays.fill(output, 0, this.BLOCK_SIZE, (byte)0);
                output[0] = 1;
                return;
            }
            case DecData: {
                throw new IllegalArgumentException(this.algorithmName + " cannot process AAD when the length of the plaintext to be processed exceeds the a block size");
            }
            case EncData: {
                throw new IllegalArgumentException(this.algorithmName + " cannot process AAD when the length of the ciphertext to be processed exceeds the a block size");
            }
            case EncFinal: {
                throw new IllegalArgumentException(this.algorithmName + " cannot be reused for encryption");
            }
        }
        int r_outlen = this.BLOCK_SIZE - len;
        int r_adlen = this.adlen - this.adOff;
        if (r_outlen <= r_adlen) {
            System.arraycopy(this.ad, this.adOff, output, len, r_outlen);
            this.adOff += r_outlen;
        } else {
            if (r_adlen > 0) {
                System.arraycopy(this.ad, this.adOff, output, len, r_adlen);
                this.adOff += r_adlen;
            }
            Arrays.fill(output, len + r_adlen, len + r_outlen, (byte)0);
            output[len + r_adlen] = 1;
            switch (this.m_state) {
                case DecAad: {
                    this.m_state = State.DecData;
                    break;
                }
                case EncAad: {
                    this.m_state = State.EncData;
                }
            }
        }
    }

    private int processBytes(byte[] m, byte[] output, int outOff, int nb_it, int nblocks_m, int nblocks_c, int mlen, int nblocks_ad, boolean isDofinal) {
        int i;
        int rv = 0;
        byte[] outputMessage = new byte[this.BLOCK_SIZE];
        for (i = this.nb_its; i < nb_it; ++i) {
            int r_size;
            int n = r_size = i == nblocks_m - 1 ? mlen - i * this.BLOCK_SIZE : this.BLOCK_SIZE;
            if (!isDofinal && (r_size % this.BLOCK_SIZE != 0 || mlen <= i * this.BLOCK_SIZE)) break;
            this.lfsr_step(this.next_mask, this.current_mask);
            if (i < nblocks_m) {
                System.arraycopy(this.npub, 0, this.buffer, 0, 12);
                Arrays.fill(this.buffer, 12, this.BLOCK_SIZE, (byte)0);
                this.xor_block(this.buffer, this.current_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.permutation(this.buffer);
                this.xor_block(this.buffer, this.current_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, m, rv, r_size);
                System.arraycopy(this.buffer, 0, output, outOff, r_size);
                if (this.forEncryption) {
                    System.arraycopy(this.buffer, 0, outputMessage, 0, r_size);
                } else {
                    System.arraycopy(m, rv, outputMessage, 0, r_size);
                }
                outOff += r_size;
                rv += r_size;
            }
            if (i > 0 && i <= nblocks_c) {
                int block_offset = (i - 1) * this.BLOCK_SIZE;
                if (block_offset == mlen) {
                    Arrays.fill(this.buffer, 0, this.BLOCK_SIZE, (byte)0);
                    this.buffer[0] = 1;
                } else {
                    int r_clen = mlen - block_offset;
                    if (this.BLOCK_SIZE <= r_clen) {
                        System.arraycopy(this.previous_outputMessage, 0, this.buffer, 0, this.BLOCK_SIZE);
                    } else if (r_clen > 0) {
                        System.arraycopy(this.previous_outputMessage, 0, this.buffer, 0, r_clen);
                        Arrays.fill(this.buffer, r_clen, this.BLOCK_SIZE, (byte)0);
                        this.buffer[r_clen] = 1;
                    }
                }
                this.xor_block(this.buffer, this.previous_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.permutation(this.buffer);
                this.xor_block(this.buffer, this.previous_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.tag_buffer, this.buffer, 0, this.BLOCK_SIZE);
            }
            if (i + 1 < nblocks_ad) {
                this.processAADBytes(this.buffer);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.permutation(this.buffer);
                this.xor_block(this.buffer, this.next_mask, 0, this.BLOCK_SIZE);
                this.xor_block(this.tag_buffer, this.buffer, 0, this.BLOCK_SIZE);
            }
            byte[] temp = this.previous_mask;
            this.previous_mask = this.current_mask;
            this.current_mask = this.next_mask;
            this.next_mask = temp;
            System.arraycopy(outputMessage, 0, this.previous_outputMessage, 0, this.BLOCK_SIZE);
        }
        this.nb_its = i;
        return rv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElephantParameters {
        elephant160,
        elephant176,
        elephant200;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Uninitialized,
        EncInit,
        EncAad,
        EncData,
        EncFinal,
        DecInit,
        DecAad,
        DecData,
        DecFinal;

    }
}

