/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public class XoodyakDigest
implements Digest {
    private byte[] state;
    private int phase;
    private MODE mode;
    private int Rabsorb;
    private final int f_bPrime = 48;
    private final int Rhash = 16;
    private final int PhaseDown = 1;
    private final int PhaseUp = 2;
    private final int MAXROUNDS = 12;
    private final int TAGLEN = 16;
    private final int[] RC = new int[]{88, 56, 960, 208, 288, 20, 96, 44, 896, 240, 416, 18};
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public XoodyakDigest() {
        this.state = new byte[48];
        this.reset();
    }

    public String getAlgorithmName() {
        return "Xoodyak Hash";
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte input) {
        this.buffer.write(input);
    }

    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.buffer.write(input, inOff, len);
    }

    public int doFinal(byte[] output, int outOff) {
        int splitLen;
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] input = this.buffer.toByteArray();
        int inOff = 0;
        int len = this.buffer.size();
        int Cd = 3;
        do {
            if (this.phase != 2) {
                this.Up(null, 0, 0, 0);
            }
            splitLen = Math.min(len, this.Rabsorb);
            this.Down(input, inOff, splitLen, Cd);
            Cd = 0;
            inOff += splitLen;
        } while ((len -= splitLen) != 0);
        this.Up(output, outOff, 16, 64);
        this.Down(null, 0, 0, 0);
        this.Up(output, outOff + 16, 16, 0);
        this.reset();
        return 32;
    }

    public void reset() {
        Arrays.fill(this.state, (byte)0);
        this.phase = 2;
        this.mode = MODE.ModeHash;
        this.Rabsorb = 16;
        this.buffer.reset();
    }

    private void Up(byte[] Yi, int YiOff, int YiLen, int Cu) {
        if (this.mode != MODE.ModeHash) {
            this.state[47] = (byte)(this.state[47] ^ Cu);
        }
        int a0 = Pack.littleEndianToInt(this.state, 0);
        int a1 = Pack.littleEndianToInt(this.state, 4);
        int a2 = Pack.littleEndianToInt(this.state, 8);
        int a3 = Pack.littleEndianToInt(this.state, 12);
        int a4 = Pack.littleEndianToInt(this.state, 16);
        int a5 = Pack.littleEndianToInt(this.state, 20);
        int a6 = Pack.littleEndianToInt(this.state, 24);
        int a7 = Pack.littleEndianToInt(this.state, 28);
        int a8 = Pack.littleEndianToInt(this.state, 32);
        int a9 = Pack.littleEndianToInt(this.state, 36);
        int a10 = Pack.littleEndianToInt(this.state, 40);
        int a11 = Pack.littleEndianToInt(this.state, 44);
        for (int i = 0; i < 12; ++i) {
            int p0 = a0 ^ a4 ^ a8;
            int p1 = a1 ^ a5 ^ a9;
            int p2 = a2 ^ a6 ^ a10;
            int p3 = a3 ^ a7 ^ a11;
            int e0 = Integers.rotateLeft(p3, 5) ^ Integers.rotateLeft(p3, 14);
            int e1 = Integers.rotateLeft(p0, 5) ^ Integers.rotateLeft(p0, 14);
            int e2 = Integers.rotateLeft(p1, 5) ^ Integers.rotateLeft(p1, 14);
            int e3 = Integers.rotateLeft(p2, 5) ^ Integers.rotateLeft(p2, 14);
            a0 ^= e0;
            a4 ^= e0;
            a8 ^= e0;
            a1 ^= e1;
            a5 ^= e1;
            a9 ^= e1;
            a2 ^= e2;
            a6 ^= e2;
            a10 ^= e2;
            a3 ^= e3;
            a7 ^= e3;
            a11 ^= e3;
            int b0 = a0;
            int b1 = a1;
            int b2 = a2;
            int b3 = a3;
            int b4 = a7;
            int b5 = a4;
            int b6 = a5;
            int b7 = a6;
            int b8 = Integers.rotateLeft(a8, 11);
            int b9 = Integers.rotateLeft(a9, 11);
            int b10 = Integers.rotateLeft(a10, 11);
            int b11 = Integers.rotateLeft(a11, 11);
            a0 = (b0 ^= this.RC[i]) ^ ~b4 & b8;
            a1 = b1 ^ ~b5 & b9;
            a2 = b2 ^ ~b6 & b10;
            a3 = b3 ^ ~b7 & b11;
            a4 = b4 ^ ~b8 & b0;
            a5 = b5 ^ ~b9 & b1;
            a6 = b6 ^ ~b10 & b2;
            a7 = b7 ^ ~b11 & b3;
            b8 ^= ~b0 & b4;
            b9 ^= ~b1 & b5;
            b10 ^= ~b2 & b6;
            b11 ^= ~b3 & b7;
            a4 = Integers.rotateLeft(a4, 1);
            a5 = Integers.rotateLeft(a5, 1);
            a6 = Integers.rotateLeft(a6, 1);
            a7 = Integers.rotateLeft(a7, 1);
            a8 = Integers.rotateLeft(b10, 8);
            a9 = Integers.rotateLeft(b11, 8);
            a10 = Integers.rotateLeft(b8, 8);
            a11 = Integers.rotateLeft(b9, 8);
        }
        Pack.intToLittleEndian(a0, this.state, 0);
        Pack.intToLittleEndian(a1, this.state, 4);
        Pack.intToLittleEndian(a2, this.state, 8);
        Pack.intToLittleEndian(a3, this.state, 12);
        Pack.intToLittleEndian(a4, this.state, 16);
        Pack.intToLittleEndian(a5, this.state, 20);
        Pack.intToLittleEndian(a6, this.state, 24);
        Pack.intToLittleEndian(a7, this.state, 28);
        Pack.intToLittleEndian(a8, this.state, 32);
        Pack.intToLittleEndian(a9, this.state, 36);
        Pack.intToLittleEndian(a10, this.state, 40);
        Pack.intToLittleEndian(a11, this.state, 44);
        this.phase = 2;
        if (Yi != null) {
            System.arraycopy(this.state, 0, Yi, YiOff, YiLen);
        }
    }

    void Down(byte[] Xi, int XiOff, int XiLen, int Cd) {
        int i = 0;
        while (i < XiLen) {
            int n = i++;
            this.state[n] = (byte)(this.state[n] ^ Xi[XiOff++]);
        }
        int n = XiLen;
        this.state[n] = (byte)(this.state[n] ^ 1);
        this.state[47] = (byte)(this.state[47] ^ (this.mode == MODE.ModeHash ? Cd & 1 : Cd));
        this.phase = 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MODE {
        ModeHash,
        ModeKeyed;

    }
}

