/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.gmss;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import org.bouncycastle.pqc.legacy.crypto.gmss.GMSSDigestProvider;
import org.bouncycastle.pqc.legacy.crypto.gmss.GMSSPrivateKeyParameters;
import org.bouncycastle.pqc.legacy.crypto.gmss.GMSSSigner;
import org.bouncycastle.util.Memoable;

public class GMSSStateAwareSigner
implements StateAwareMessageSigner {
    private final GMSSSigner gmssSigner;
    private GMSSPrivateKeyParameters key;

    public GMSSStateAwareSigner(Digest digest) {
        if (!(digest instanceof Memoable)) {
            throw new IllegalArgumentException("digest must implement Memoable");
        }
        final Memoable dig = ((Memoable)((Object)digest)).copy();
        this.gmssSigner = new GMSSSigner(new GMSSDigestProvider(){

            public Digest get() {
                return (Digest)((Object)dig.copy());
            }
        });
    }

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.key = (GMSSPrivateKeyParameters)rParam.getParameters();
            } else {
                this.key = (GMSSPrivateKeyParameters)param;
            }
        }
        this.gmssSigner.init(forSigning, param);
    }

    public byte[] generateSignature(byte[] message) {
        if (this.key == null) {
            throw new IllegalStateException("signing key no longer usable");
        }
        byte[] sig = this.gmssSigner.generateSignature(message);
        this.key = this.key.nextKey();
        return sig;
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        return this.gmssSigner.verifySignature(message, signature);
    }

    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        GMSSPrivateKeyParameters k = this.key;
        this.key = null;
        return k;
    }
}

