/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;

class Rounding {
    Rounding() {
    }

    public static int[] power2Round(int a) {
        int[] out;
        out = new int[]{a + 4096 - 1 >> 13, a - (out[0] << 13)};
        return out;
    }

    public static int[] decompose(int a, int gamma2) {
        int a1 = a + 127 >> 7;
        if (gamma2 == 261888) {
            a1 = a1 * 1025 + 0x200000 >> 22;
            a1 &= 0xF;
        } else if (gamma2 == 95232) {
            a1 = a1 * 11275 + 0x800000 >> 24;
            a1 ^= 43 - a1 >> 31 & a1;
        } else {
            throw new RuntimeException("Wrong Gamma2!");
        }
        int a0 = a - a1 * 2 * gamma2;
        a0 -= 0x3FF000 - a0 >> 31 & 0x7FE001;
        return new int[]{a0, a1};
    }

    public static int makeHint(int a0, int a1, DilithiumEngine engine) {
        int g2 = engine.getDilithiumGamma2();
        int q = 8380417;
        if (a0 <= g2 || a0 > q - g2 || a0 == q - g2 && a1 == 0) {
            return 0;
        }
        return 1;
    }

    public static int useHint(int a, int hint, int gamma2) {
        int[] intArray = Rounding.decompose(a, gamma2);
        int a0 = intArray[0];
        int a1 = intArray[1];
        if (hint == 0) {
            return a1;
        }
        if (gamma2 == 261888) {
            if (a0 > 0) {
                return a1 + 1 & 0xF;
            }
            return a1 - 1 & 0xF;
        }
        if (gamma2 == 95232) {
            if (a0 > 0) {
                return a1 == 43 ? 0 : a1 + 1;
            }
            return a1 == 0 ? 43 : a1 - 1;
        }
        throw new RuntimeException("Wrong Gamma2!");
    }
}

