/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;

public class DilithiumSigner
implements MessageSigner {
    private DilithiumPrivateKeyParameters privKey;
    private DilithiumPublicKeyParameters pubKey;
    private SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                this.privKey = (DilithiumPrivateKeyParameters)((ParametersWithRandom)param).getParameters();
                this.random = ((ParametersWithRandom)param).getRandom();
            } else {
                this.privKey = (DilithiumPrivateKeyParameters)param;
                this.random = null;
            }
        } else {
            this.pubKey = (DilithiumPublicKeyParameters)param;
        }
    }

    public byte[] generateSignature(byte[] message) {
        DilithiumEngine engine = this.privKey.getParameters().getEngine(this.random);
        return engine.sign(message, message.length, this.privKey.rho, this.privKey.k, this.privKey.tr, this.privKey.t0, this.privKey.s1, this.privKey.s2);
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        DilithiumEngine engine = this.pubKey.getParameters().getEngine(this.random);
        return engine.signOpen(message, signature, signature.length, this.pubKey.rho, this.pubKey.t1);
    }
}

