/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import org.bouncycastle.pqc.legacy.crypto.sike.Fpx;
import org.bouncycastle.pqc.legacy.crypto.sike.PointProj;
import org.bouncycastle.pqc.legacy.crypto.sike.PointProjFull;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;

class Isogeny {
    SIKEEngine engine;

    Isogeny(SIKEEngine engine) {
        this.engine = engine;
    }

    protected void Double(PointProj P, PointProj Q, long[][] A24, int k) {
        long[][] temp = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] a = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] b = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] c = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] aa = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] bb = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2copy(P.X, Q.X);
        this.engine.fpx.fp2copy(P.Z, Q.Z);
        for (int j = 0; j < k; ++j) {
            this.engine.fpx.fp2add(Q.X, Q.Z, a);
            this.engine.fpx.fp2sub(Q.X, Q.Z, b);
            this.engine.fpx.fp2sqr_mont(a, aa);
            this.engine.fpx.fp2sqr_mont(b, bb);
            this.engine.fpx.fp2sub(aa, bb, c);
            this.engine.fpx.fp2mul_mont(aa, bb, Q.X);
            this.engine.fpx.fp2mul_mont(A24, c, temp);
            this.engine.fpx.fp2add(temp, bb, temp);
            this.engine.fpx.fp2mul_mont(c, temp, Q.Z);
        }
    }

    protected void CompleteMPoint(long[][] A, PointProj P, PointProjFull R) {
        long[][] zero = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] one = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] xz = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] yz = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] s2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] r2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] invz = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] temp0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] temp1 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, one[0]);
        if (!Fpx.subarrayEquals(P.Z[0], zero[0], this.engine.params.NWORDS_FIELD) || !Fpx.subarrayEquals(P.Z[1], zero[1], this.engine.params.NWORDS_FIELD)) {
            this.engine.fpx.fp2mul_mont(P.X, P.Z, xz);
            this.engine.fpx.fpsubPRIME(P.X[0], P.Z[1], temp0[0]);
            this.engine.fpx.fpaddPRIME(P.X[1], P.Z[0], temp0[1]);
            this.engine.fpx.fpaddPRIME(P.X[0], P.Z[1], temp1[0]);
            this.engine.fpx.fpsubPRIME(P.X[1], P.Z[0], temp1[1]);
            this.engine.fpx.fp2mul_mont(temp0, temp1, s2);
            this.engine.fpx.fp2mul_mont(A, xz, temp0);
            this.engine.fpx.fp2add(temp0, s2, temp1);
            this.engine.fpx.fp2mul_mont(xz, temp1, r2);
            this.engine.fpx.sqrt_Fp2(r2, yz);
            this.engine.fpx.fp2copy(P.Z, invz);
            this.engine.fpx.fp2inv_mont_bingcd(invz);
            this.engine.fpx.fp2mul_mont(P.X, invz, R.X);
            this.engine.fpx.fp2sqr_mont(invz, temp0);
            this.engine.fpx.fp2mul_mont(yz, temp0, R.Y);
            this.engine.fpx.fp2copy(one, R.Z);
        } else {
            this.engine.fpx.fp2copy(zero, R.X);
            this.engine.fpx.fp2copy(one, R.Y);
            this.engine.fpx.fp2copy(zero, R.Z);
        }
    }

    void Ladder(PointProj P, long[] m, long[][] A, int order_bits, PointProj R) {
        long mask;
        int swap;
        PointProj R0 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj R1 = new PointProj(this.engine.params.NWORDS_FIELD);
        long[][] A24 = new long[2][this.engine.params.NWORDS_FIELD];
        int bit = 0;
        int prevbit = 0;
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, A24[0]);
        this.engine.fpx.fpaddPRIME(A24[0], A24[0], A24[0]);
        this.engine.fpx.fp2add(A, A24, A24);
        this.engine.fpx.fp2div2(A24, A24);
        this.engine.fpx.fp2div2(A24, A24);
        int j = order_bits - 1;
        bit = (int)(m[j >> 6] >>> (j & 0x3F) & 1L);
        while (bit == 0) {
            bit = (int)(m[--j >> 6] >>> (j & 0x3F) & 1L);
        }
        this.engine.fpx.fp2copy(P.X, R0.X);
        this.engine.fpx.fp2copy(P.Z, R0.Z);
        this.xDBL_e(P, R1, A24, 1);
        for (int i = j - 1; i >= 0; --i) {
            bit = (int)(m[i >> 6] >>> (i & 0x3F) & 1L);
            swap = bit ^ prevbit;
            prevbit = bit;
            mask = 0 - swap;
            this.swap_points(R0, R1, mask);
            this.xDBLADD_proj(R0, R1, P.X, P.Z, A24);
        }
        swap = 0 ^ prevbit;
        mask = 0 - swap;
        this.swap_points(R0, R1, mask);
        this.engine.fpx.fp2copy(R0.X, R.X);
        this.engine.fpx.fp2copy(R0.Z, R.Z);
    }

    private void xDBLADD_proj(PointProj P, PointProj Q, long[][] XPQ, long[][] ZPQ, long[][] A24) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(P.X, P.Z, t0);
        this.engine.fpx.fp2sub(P.X, P.Z, t1);
        this.engine.fpx.fp2sqr_mont(t0, P.X);
        this.engine.fpx.fp2sub(Q.X, Q.Z, t2);
        this.engine.fpx.fp2correction(t2);
        this.engine.fpx.fp2add(Q.X, Q.Z, Q.X);
        this.engine.fpx.fp2mul_mont(t0, t2, t0);
        this.engine.fpx.fp2sqr_mont(t1, P.Z);
        this.engine.fpx.fp2mul_mont(t1, Q.X, t1);
        this.engine.fpx.fp2sub(P.X, P.Z, t2);
        this.engine.fpx.fp2mul_mont(P.X, P.Z, P.X);
        this.engine.fpx.fp2mul_mont(t2, A24, Q.X);
        this.engine.fpx.fp2sub(t0, t1, Q.Z);
        this.engine.fpx.fp2add(Q.X, P.Z, P.Z);
        this.engine.fpx.fp2add(t0, t1, Q.X);
        this.engine.fpx.fp2mul_mont(P.Z, t2, P.Z);
        this.engine.fpx.fp2sqr_mont(Q.Z, Q.Z);
        this.engine.fpx.fp2sqr_mont(Q.X, Q.X);
        this.engine.fpx.fp2mul_mont(Q.X, ZPQ, Q.X);
        this.engine.fpx.fp2mul_mont(Q.Z, XPQ, Q.Z);
    }

    private void xDBL_e(PointProj P, PointProj Q, long[][] A24, int e) {
        long[][] temp = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] a = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] b = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] c = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] aa = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] bb = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2copy(P.X, Q.X);
        this.engine.fpx.fp2copy(P.Z, Q.Z);
        for (int j = 0; j < e; ++j) {
            this.engine.fpx.fp2add(Q.X, Q.Z, a);
            this.engine.fpx.fp2sub(Q.X, Q.Z, b);
            this.engine.fpx.fp2sqr_mont(a, aa);
            this.engine.fpx.fp2sqr_mont(b, bb);
            this.engine.fpx.fp2sub(aa, bb, c);
            this.engine.fpx.fp2mul_mont(aa, bb, Q.X);
            this.engine.fpx.fp2mul_mont(A24, c, temp);
            this.engine.fpx.fp2add(temp, bb, temp);
            this.engine.fpx.fp2mul_mont(c, temp, Q.Z);
        }
    }

    void xTPLe_fast(PointProj P, PointProj Q, long[][] A2, int e) {
        PointProj T = new PointProj(this.engine.params.NWORDS_FIELD);
        this.engine.fpx.copy_words(P, T);
        for (int j = 0; j < e; ++j) {
            this.xTPL_fast(T, T, A2);
        }
        this.engine.fpx.copy_words(T, Q);
    }

    private void xTPL_fast(PointProj P, PointProj Q, long[][] A2) {
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t4 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2sqr_mont(P.X, t1);
        this.engine.fpx.fp2sqr_mont(P.Z, t2);
        this.engine.fpx.fp2add(t1, t2, t3);
        this.engine.fpx.fp2add(P.X, P.Z, t4);
        this.engine.fpx.fp2sqr_mont(t4, t4);
        this.engine.fpx.fp2sub(t4, t3, t4);
        this.engine.fpx.fp2mul_mont(A2, t4, t4);
        this.engine.fpx.fp2add(t3, t4, t4);
        this.engine.fpx.fp2sub(t1, t2, t3);
        this.engine.fpx.fp2sqr_mont(t3, t3);
        this.engine.fpx.fp2mul_mont(t1, t4, t1);
        this.engine.fpx.fp2shl(t1, 2, t1);
        this.engine.fpx.fp2sub(t1, t3, t1);
        this.engine.fpx.fp2sqr_mont(t1, t1);
        this.engine.fpx.fp2mul_mont(t2, t4, t2);
        this.engine.fpx.fp2shl(t2, 2, t2);
        this.engine.fpx.fp2sub(t2, t3, t2);
        this.engine.fpx.fp2sqr_mont(t2, t2);
        this.engine.fpx.fp2mul_mont(P.X, t2, Q.X);
        this.engine.fpx.fp2mul_mont(P.Z, t1, Q.Z);
    }

    protected void LADDER3PT(long[][] xP, long[][] xQ, long[][] xPQ, long[] m, int AliceOrBob, PointProj R, long[][] A) {
        long mask;
        int swap;
        PointProj R0 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj R2 = new PointProj(this.engine.params.NWORDS_FIELD);
        long[][] A24 = new long[2][this.engine.params.NWORDS_FIELD];
        int prevbit = 0;
        int nbits = AliceOrBob == this.engine.params.ALICE ? this.engine.params.OALICE_BITS : this.engine.params.OBOB_BITS - 1;
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, A24[0]);
        this.engine.fpx.mp2_add(A24, A24, A24);
        this.engine.fpx.mp2_add(A, A24, A24);
        this.engine.fpx.fp2div2(A24, A24);
        this.engine.fpx.fp2div2(A24, A24);
        this.engine.fpx.fp2copy(xQ, R0.X);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, R0.Z[0]);
        this.engine.fpx.fp2copy(xPQ, R2.X);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, R2.Z[0]);
        this.engine.fpx.fp2copy(xP, R.X);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, R.Z[0]);
        this.engine.fpx.fpzero(R.Z[1]);
        for (int i = 0; i < nbits; ++i) {
            int bit = (int)(m[i >>> 6] >>> (i & 0x3F) & 1L);
            swap = bit ^ prevbit;
            prevbit = bit;
            mask = 0L - (long)swap;
            this.swap_points(R, R2, mask);
            this.xDBLADD(R0, R2, R.X, A24);
            this.engine.fpx.fp2mul_mont(R2.X, R.Z, R2.X);
        }
        swap = 0 ^ prevbit;
        mask = 0L - (long)swap;
        this.swap_points(R, R2, mask);
    }

    protected void CompletePoint(PointProj P, PointProjFull R) {
        long[][] xz = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] s2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] r2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] yz = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] invz = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] one = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, one[0]);
        this.engine.fpx.fp2mul_mont(P.X, P.Z, xz);
        this.engine.fpx.fpsubPRIME(P.X[0], P.Z[1], t0[0]);
        this.engine.fpx.fpaddPRIME(P.X[1], P.Z[0], t0[1]);
        this.engine.fpx.fpaddPRIME(P.X[0], P.Z[1], t1[0]);
        this.engine.fpx.fpsubPRIME(P.X[1], P.Z[0], t1[1]);
        this.engine.fpx.fp2mul_mont(t0, t1, s2);
        this.engine.fpx.fp2mul_mont(xz, s2, r2);
        this.engine.fpx.sqrt_Fp2(r2, yz);
        this.engine.fpx.fp2copy(P.Z, invz);
        this.engine.fpx.fp2inv_mont_bingcd(invz);
        this.engine.fpx.fp2mul_mont(P.X, invz, R.X);
        this.engine.fpx.fp2sqr_mont(invz, t0);
        this.engine.fpx.fp2mul_mont(yz, t0, R.Y);
        this.engine.fpx.fp2copy(one, R.Z);
    }

    protected void swap_points(PointProj P, PointProj Q, long option) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            long temp = option & (P.X[0][i] ^ Q.X[0][i]);
            P.X[0][i] = temp ^ P.X[0][i];
            Q.X[0][i] = temp ^ Q.X[0][i];
            temp = option & (P.X[1][i] ^ Q.X[1][i]);
            P.X[1][i] = temp ^ P.X[1][i];
            Q.X[1][i] = temp ^ Q.X[1][i];
            temp = option & (P.Z[0][i] ^ Q.Z[0][i]);
            P.Z[0][i] = temp ^ P.Z[0][i];
            Q.Z[0][i] = temp ^ Q.Z[0][i];
            temp = option & (P.Z[1][i] ^ Q.Z[1][i]);
            P.Z[1][i] = temp ^ P.Z[1][i];
            Q.Z[1][i] = temp ^ Q.Z[1][i];
        }
    }

    protected void xDBLADD(PointProj P, PointProj Q, long[][] xPQ, long[][] A24) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.mp2_add(P.X, P.Z, t0);
        this.engine.fpx.mp2_sub_p2(P.X, P.Z, t1);
        this.engine.fpx.fp2sqr_mont(t0, P.X);
        this.engine.fpx.mp2_sub_p2(Q.X, Q.Z, t2);
        this.engine.fpx.mp2_add(Q.X, Q.Z, Q.X);
        this.engine.fpx.fp2mul_mont(t0, t2, t0);
        this.engine.fpx.fp2sqr_mont(t1, P.Z);
        this.engine.fpx.fp2mul_mont(t1, Q.X, t1);
        this.engine.fpx.mp2_sub_p2(P.X, P.Z, t2);
        this.engine.fpx.fp2mul_mont(P.X, P.Z, P.X);
        this.engine.fpx.fp2mul_mont(A24, t2, Q.X);
        this.engine.fpx.mp2_sub_p2(t0, t1, Q.Z);
        this.engine.fpx.mp2_add(Q.X, P.Z, P.Z);
        this.engine.fpx.mp2_add(t0, t1, Q.X);
        this.engine.fpx.fp2mul_mont(P.Z, t2, P.Z);
        this.engine.fpx.fp2sqr_mont(Q.Z, Q.Z);
        this.engine.fpx.fp2sqr_mont(Q.X, Q.X);
        this.engine.fpx.fp2mul_mont(Q.Z, xPQ, Q.Z);
    }

    protected void xDBLe(PointProj P, PointProj Q, long[][] A24plus, long[][] C24, int e) {
        this.engine.fpx.copy_words(P, Q);
        for (int i = 0; i < e; ++i) {
            this.xDBL(Q, Q, A24plus, C24);
        }
    }

    protected void xDBL(PointProj P, PointProj Q, long[][] A24plus, long[][] C24) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.mp2_sub_p2(P.X, P.Z, t0);
        this.engine.fpx.mp2_add(P.X, P.Z, t1);
        this.engine.fpx.fp2sqr_mont(t0, t0);
        this.engine.fpx.fp2sqr_mont(t1, t1);
        this.engine.fpx.fp2mul_mont(C24, t0, Q.Z);
        this.engine.fpx.fp2mul_mont(t1, Q.Z, Q.X);
        this.engine.fpx.mp2_sub_p2(t1, t0, t1);
        this.engine.fpx.fp2mul_mont(A24plus, t1, t0);
        this.engine.fpx.mp2_add(Q.Z, t0, Q.Z);
        this.engine.fpx.fp2mul_mont(Q.Z, t1, Q.Z);
    }

    private void xTPL(PointProj P, PointProj Q, long[][] A24minus, long[][] A24plus) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t6 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.mp2_sub_p2(P.X, P.Z, t0);
        this.engine.fpx.fp2sqr_mont(t0, t2);
        this.engine.fpx.mp2_add(P.X, P.Z, t1);
        this.engine.fpx.fp2sqr_mont(t1, t3);
        this.engine.fpx.mp2_add(P.X, P.X, t4);
        this.engine.fpx.mp2_add(P.Z, P.Z, t0);
        this.engine.fpx.fp2sqr_mont(t4, t1);
        this.engine.fpx.mp2_sub_p2(t1, t3, t1);
        this.engine.fpx.mp2_sub_p2(t1, t2, t1);
        this.engine.fpx.fp2mul_mont(A24plus, t3, t5);
        this.engine.fpx.fp2mul_mont(t3, t5, t3);
        this.engine.fpx.fp2mul_mont(A24minus, t2, t6);
        this.engine.fpx.fp2mul_mont(t2, t6, t2);
        this.engine.fpx.mp2_sub_p2(t2, t3, t3);
        this.engine.fpx.mp2_sub_p2(t5, t6, t2);
        this.engine.fpx.fp2mul_mont(t1, t2, t1);
        this.engine.fpx.fp2add(t3, t1, t2);
        this.engine.fpx.fp2sqr_mont(t2, t2);
        this.engine.fpx.fp2mul_mont(t4, t2, Q.X);
        this.engine.fpx.fp2sub(t3, t1, t1);
        this.engine.fpx.fp2sqr_mont(t1, t1);
        this.engine.fpx.fp2mul_mont(t0, t1, Q.Z);
    }

    protected void xTPLe(PointProj P, PointProj Q, long[][] A24minus, long[][] A24plus, int e) {
        this.engine.fpx.copy_words(P, Q);
        for (int i = 0; i < e; ++i) {
            this.xTPL(Q, Q, A24minus, A24plus);
        }
    }

    protected void get_A(long[][] xP, long[][] xQ, long[][] xR, long[][] A) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] one = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, one[0]);
        this.engine.fpx.fp2add(xP, xQ, t1);
        this.engine.fpx.fp2mul_mont(xP, xQ, t0);
        this.engine.fpx.fp2mul_mont(xR, t1, A);
        this.engine.fpx.fp2add(t0, A, A);
        this.engine.fpx.fp2mul_mont(t0, xR, t0);
        this.engine.fpx.fp2sub(A, one, A);
        this.engine.fpx.fp2add(t0, t0, t0);
        this.engine.fpx.fp2add(t1, xR, t1);
        this.engine.fpx.fp2add(t0, t0, t0);
        this.engine.fpx.fp2sqr_mont(A, A);
        this.engine.fpx.fp2inv_mont(t0);
        this.engine.fpx.fp2mul_mont(A, t0, A);
        this.engine.fpx.fp2sub(A, t1, A);
    }

    protected void j_inv(long[][] A, long[][] C, long[][] jinv) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2sqr_mont(A, jinv);
        this.engine.fpx.fp2sqr_mont(C, t1);
        this.engine.fpx.fp2add(t1, t1, t0);
        this.engine.fpx.fp2sub(jinv, t0, t0);
        this.engine.fpx.fp2sub(t0, t1, t0);
        this.engine.fpx.fp2sub(t0, t1, jinv);
        this.engine.fpx.fp2sqr_mont(t1, t1);
        this.engine.fpx.fp2mul_mont(jinv, t1, jinv);
        this.engine.fpx.fp2add(t0, t0, t0);
        this.engine.fpx.fp2add(t0, t0, t0);
        this.engine.fpx.fp2sqr_mont(t0, t1);
        this.engine.fpx.fp2mul_mont(t0, t1, t0);
        this.engine.fpx.fp2add(t0, t0, t0);
        this.engine.fpx.fp2add(t0, t0, t0);
        this.engine.fpx.fp2inv_mont(jinv);
        this.engine.fpx.fp2mul_mont(jinv, t0, jinv);
    }

    protected void get_3_isog(PointProj P, long[][] A24minus, long[][] A24plus, long[][][] coeff) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t4 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.mp2_sub_p2(P.X, P.Z, coeff[0]);
        this.engine.fpx.fp2sqr_mont(coeff[0], t0);
        this.engine.fpx.mp2_add(P.X, P.Z, coeff[1]);
        this.engine.fpx.fp2sqr_mont(coeff[1], t1);
        this.engine.fpx.mp2_add(P.X, P.X, t3);
        this.engine.fpx.fp2sqr_mont(t3, t3);
        this.engine.fpx.fp2sub(t3, t0, t2);
        this.engine.fpx.fp2sub(t3, t1, t3);
        this.engine.fpx.mp2_add(t0, t3, t4);
        this.engine.fpx.mp2_add(t4, t4, t4);
        this.engine.fpx.mp2_add(t1, t4, t4);
        this.engine.fpx.fp2mul_mont(t2, t4, A24minus);
        this.engine.fpx.mp2_add(t1, t2, t4);
        this.engine.fpx.mp2_add(t4, t4, t4);
        this.engine.fpx.mp2_add(t0, t4, t4);
        this.engine.fpx.fp2mul_mont(t3, t4, A24plus);
    }

    protected void eval_3_isog(PointProj Q, long[][][] coeff) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.mp2_add(Q.X, Q.Z, t0);
        this.engine.fpx.mp2_sub_p2(Q.X, Q.Z, t1);
        this.engine.fpx.fp2mul_mont(coeff[0], t0, t0);
        this.engine.fpx.fp2mul_mont(coeff[1], t1, t1);
        this.engine.fpx.mp2_add(t0, t1, t2);
        this.engine.fpx.mp2_sub_p2(t1, t0, t0);
        this.engine.fpx.fp2sqr_mont(t2, t2);
        this.engine.fpx.fp2sqr_mont(t0, t0);
        this.engine.fpx.fp2mul_mont(Q.X, t2, Q.X);
        this.engine.fpx.fp2mul_mont(Q.Z, t0, Q.Z);
    }

    protected void inv_3_way(long[][] z1, long[][] z2, long[][] z3) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t3 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2mul_mont(z1, z2, t0);
        this.engine.fpx.fp2mul_mont(z3, t0, t1);
        this.engine.fpx.fp2inv_mont(t1);
        this.engine.fpx.fp2mul_mont(z3, t1, t2);
        this.engine.fpx.fp2mul_mont(t2, z2, t3);
        this.engine.fpx.fp2mul_mont(t2, z1, z2);
        this.engine.fpx.fp2mul_mont(t0, t1, z3);
        this.engine.fpx.fp2copy(t3, z1);
    }

    protected void get_2_isog(PointProj P, long[][] A, long[][] C) {
        this.engine.fpx.fp2sqr_mont(P.X, A);
        this.engine.fpx.fp2sqr_mont(P.Z, C);
        this.engine.fpx.mp2_sub_p2(C, A, A);
    }

    protected void eval_2_isog(PointProj P, PointProj Q) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t3 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.mp2_add(Q.X, Q.Z, t0);
        this.engine.fpx.mp2_sub_p2(Q.X, Q.Z, t1);
        this.engine.fpx.mp2_add(P.X, P.Z, t2);
        this.engine.fpx.mp2_sub_p2(P.X, P.Z, t3);
        this.engine.fpx.fp2mul_mont(t0, t3, t0);
        this.engine.fpx.fp2mul_mont(t1, t2, t1);
        this.engine.fpx.mp2_add(t0, t1, t2);
        this.engine.fpx.mp2_sub_p2(t0, t1, t3);
        this.engine.fpx.fp2mul_mont(P.X, t2, P.X);
        this.engine.fpx.fp2mul_mont(P.Z, t3, P.Z);
    }

    protected void get_4_isog(PointProj P, long[][] A24plus, long[][] C24, long[][][] coeff) {
        this.engine.fpx.mp2_sub_p2(P.X, P.Z, coeff[1]);
        this.engine.fpx.mp2_add(P.X, P.Z, coeff[2]);
        this.engine.fpx.fp2sqr_mont(P.Z, coeff[0]);
        this.engine.fpx.mp2_add(coeff[0], coeff[0], coeff[0]);
        this.engine.fpx.fp2sqr_mont(coeff[0], C24);
        this.engine.fpx.mp2_add(coeff[0], coeff[0], coeff[0]);
        this.engine.fpx.fp2sqr_mont(P.X, A24plus);
        this.engine.fpx.mp2_add(A24plus, A24plus, A24plus);
        this.engine.fpx.fp2sqr_mont(A24plus, A24plus);
    }

    protected void eval_4_isog(PointProj P, long[][][] coeff) {
        long[][] t0 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] t1 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.mp2_add(P.X, P.Z, t0);
        this.engine.fpx.mp2_sub_p2(P.X, P.Z, t1);
        this.engine.fpx.fp2mul_mont(t0, coeff[1], P.X);
        this.engine.fpx.fp2mul_mont(t1, coeff[2], P.Z);
        this.engine.fpx.fp2mul_mont(t0, t1, t0);
        this.engine.fpx.fp2mul_mont(coeff[0], t0, t0);
        this.engine.fpx.mp2_add(P.X, P.Z, t1);
        this.engine.fpx.mp2_sub_p2(P.X, P.Z, P.Z);
        this.engine.fpx.fp2sqr_mont(t1, t1);
        this.engine.fpx.fp2sqr_mont(P.Z, P.Z);
        this.engine.fpx.mp2_add(t1, t0, P.X);
        this.engine.fpx.mp2_sub_p2(P.Z, t0, t0);
        this.engine.fpx.fp2mul_mont(P.X, t1, P.X);
        this.engine.fpx.fp2mul_mont(P.Z, t0, P.Z);
    }
}

