/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.pqc.asn1.SABERPublicKey;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class SABERPrivateKey
extends ASN1Object {
    private int version;
    private byte[] z;
    private byte[] s;
    private byte[] hpk;
    private SABERPublicKey PublicKey;

    public SABERPrivateKey(int version, byte[] z, byte[] s, byte[] hpk) {
        this.version = version;
        if (version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.z = z;
        this.s = s;
        this.hpk = hpk;
    }

    public SABERPrivateKey(int version, byte[] z, byte[] s, byte[] hpk, SABERPublicKey publicKey) {
        this.version = version;
        if (version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.z = z;
        this.s = s;
        this.hpk = hpk;
        this.PublicKey = publicKey;
    }

    private SABERPrivateKey(ASN1Sequence seq) {
        this.version = BigIntegers.intValueExact(ASN1Integer.getInstance(seq.getObjectAt(0)).getValue());
        if (this.version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.z = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.s = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
        this.PublicKey = SABERPublicKey.getInstance(seq.getObjectAt(3));
        this.hpk = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(4)).getOctets());
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getZ() {
        return this.z;
    }

    public byte[] getS() {
        return this.s;
    }

    public byte[] getHpk() {
        return this.hpk;
    }

    public SABERPublicKey getPublicKey() {
        return this.PublicKey;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.version));
        v.add(new DEROctetString(this.z));
        v.add(new DEROctetString(this.s));
        v.add(new DEROctetString(this.hpk));
        return new DERSequence(v);
    }

    public static SABERPrivateKey getInstance(Object o) {
        if (o instanceof SABERPrivateKey) {
            return (SABERPrivateKey)o;
        }
        if (o != null) {
            return new SABERPrivateKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

