/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat512;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SecP521R1Field {
    static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511};
    private static final int P16 = 511;

    public static void add(int[] x, int[] y, int[] z) {
        int c = Nat.add(16, x, y, z) + x[16] + y[16];
        if (c > 511 || c == 511 && Nat.eq(16, z, P)) {
            c += Nat.inc(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    public static void addOne(int[] x, int[] z) {
        int c = Nat.inc(16, x, z) + x[16];
        if (c > 511 || c == 511 && Nat.eq(16, z, P)) {
            c += Nat.inc(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] z = Nat.fromBigInteger(521, x);
        if (Nat.eq(17, z, P)) {
            Nat.zero(17, z);
        }
        return z;
    }

    public static void half(int[] x, int[] z) {
        int x16 = x[16];
        int c = Nat.shiftDownBit(16, x, x16, z);
        z[16] = x16 >>> 1 | c >>> 23;
    }

    public static void inv(int[] x, int[] z) {
        if (0 != SecP521R1Field.isZero(x)) {
            throw new IllegalArgumentException("'x' cannot be 0");
        }
        int[] x1 = x;
        int[] x2 = Nat.create(17);
        SecP521R1Field.square(x1, x2);
        SecP521R1Field.multiply(x2, x1, x2);
        int[] x4 = Nat.create(17);
        SecP521R1Field.squareN(x2, 2, x4);
        SecP521R1Field.multiply(x4, x2, x4);
        int[] x8 = Nat.create(17);
        SecP521R1Field.squareN(x4, 4, x8);
        SecP521R1Field.multiply(x8, x4, x8);
        int[] x16 = Nat.create(17);
        SecP521R1Field.squareN(x8, 8, x16);
        SecP521R1Field.multiply(x16, x8, x16);
        int[] x32 = x8;
        SecP521R1Field.squareN(x16, 16, x32);
        SecP521R1Field.multiply(x32, x16, x32);
        int[] x64 = x16;
        SecP521R1Field.squareN(x32, 32, x64);
        SecP521R1Field.multiply(x64, x32, x64);
        int[] x128 = x32;
        SecP521R1Field.squareN(x64, 64, x128);
        SecP521R1Field.multiply(x128, x64, x128);
        int[] x256 = x64;
        SecP521R1Field.squareN(x128, 128, x256);
        SecP521R1Field.multiply(x256, x128, x256);
        int[] x512 = x128;
        SecP521R1Field.squareN(x256, 256, x512);
        SecP521R1Field.multiply(x512, x256, x512);
        int[] x516 = x256;
        SecP521R1Field.squareN(x512, 4, x516);
        SecP521R1Field.multiply(x516, x4, x516);
        int[] x518 = x4;
        SecP521R1Field.squareN(x516, 2, x518);
        SecP521R1Field.multiply(x518, x2, x518);
        int[] x519 = x2;
        SecP521R1Field.square(x518, x519);
        SecP521R1Field.multiply(x519, x1, x519);
        int[] t = x519;
        SecP521R1Field.squareN(t, 2, t);
        SecP521R1Field.multiply(x1, t, z);
    }

    public static int isZero(int[] x) {
        int d = 0;
        for (int i = 0; i < 17; ++i) {
            d |= x[i];
        }
        d = d >>> 1 | d & 1;
        return d - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] tt = Nat.create(33);
        SecP521R1Field.implMultiply(x, y, tt);
        SecP521R1Field.reduce(tt, z);
    }

    public static void negate(int[] x, int[] z) {
        if (0 != SecP521R1Field.isZero(x)) {
            Nat.sub(17, P, P, z);
        } else {
            Nat.sub(17, P, x, z);
        }
    }

    public static void random(SecureRandom r, int[] z) {
        byte[] bb = new byte[68];
        do {
            r.nextBytes(bb);
            Pack.littleEndianToInt(bb, 0, z, 0, 17);
            z[16] = (int)((long)z[16] & 0x1FFL);
        } while (0 == Nat.lessThan(17, z, P));
    }

    public static void randomMult(SecureRandom r, int[] z) {
        do {
            SecP521R1Field.random(r, z);
        } while (0 != SecP521R1Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        int xx32 = xx[32];
        int c = Nat.shiftDownBits(16, xx, 16, 9, xx32, z, 0) >>> 23;
        c += xx32 >>> 9;
        if ((c += Nat.addTo(16, xx, z)) > 511 || c == 511 && Nat.eq(16, z, P)) {
            c += Nat.inc(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    public static void reduce23(int[] z) {
        int z16 = z[16];
        int c = Nat.addWordTo(16, z16 >>> 9, z) + (z16 & 0x1FF);
        if (c > 511 || c == 511 && Nat.eq(16, z, P)) {
            c += Nat.inc(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    public static void square(int[] x, int[] z) {
        int[] tt = Nat.create(33);
        SecP521R1Field.implSquare(x, tt);
        SecP521R1Field.reduce(tt, z);
    }

    public static void squareN(int[] x, int n, int[] z) {
        int[] tt = Nat.create(33);
        SecP521R1Field.implSquare(x, tt);
        SecP521R1Field.reduce(tt, z);
        while (--n > 0) {
            SecP521R1Field.implSquare(z, tt);
            SecP521R1Field.reduce(tt, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(16, x, y, z) + x[16] - y[16];
        if (c < 0) {
            c += Nat.dec(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    public static void twice(int[] x, int[] z) {
        int x16 = x[16];
        int c = Nat.shiftUpBit(16, x, x16 << 23, z) | x16 << 1;
        z[16] = c & 0x1FF;
    }

    protected static void implMultiply(int[] x, int[] y, int[] zz) {
        Nat512.mul(x, y, zz);
        int x16 = x[16];
        int y16 = y[16];
        zz[32] = Nat.mul31BothAdd(16, x16, y, y16, x, zz, 16) + x16 * y16;
    }

    protected static void implSquare(int[] x, int[] zz) {
        Nat512.square(x, zz);
        int x16 = x[16];
        zz[32] = Nat.mulWordAddTo(16, x16 << 1, x, 0, zz, 16) + x16 * x16;
    }
}

