/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntruprime;

import org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import org.bouncycastle.util.Arrays;

public class NTRULPRimePublicKeyParameters
extends NTRULPRimeKeyParameters {
    private final byte[] seed;
    private final byte[] roundEncA;

    public NTRULPRimePublicKeyParameters(NTRULPRimeParameters params, byte[] encoding) {
        super(false, params);
        this.seed = Arrays.copyOfRange(encoding, 0, 32);
        this.roundEncA = Arrays.copyOfRange(encoding, this.seed.length, encoding.length);
    }

    NTRULPRimePublicKeyParameters(NTRULPRimeParameters params, byte[] seed, byte[] roundEncA) {
        super(false, params);
        this.seed = Arrays.clone(seed);
        this.roundEncA = Arrays.clone(roundEncA);
    }

    byte[] getSeed() {
        return this.seed;
    }

    byte[] getRoundEncA() {
        return this.roundEncA;
    }

    public byte[] getEncoded() {
        byte[] key = new byte[this.getParameters().getPublicKeyBytes()];
        System.arraycopy(this.seed, 0, key, 0, this.seed.length);
        System.arraycopy(this.roundEncA, 0, key, this.seed.length, this.roundEncA.length);
        return key;
    }
}

