/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.util.Pack;

class FalconRNG {
    byte[] bd = new byte[512];
    int ptr = 0;
    byte[] sd = new byte[256];

    FalconRNG() {
    }

    void prng_init(SHAKEDigest src) {
        src.doOutput(this.sd, 0, 56);
        this.prng_refill();
    }

    void prng_refill() {
        int[] CW = new int[]{1634760805, 857760878, 2036477234, 1797285236};
        long cc = Pack.littleEndianToLong(this.sd, 48);
        int[] state = new int[16];
        for (int u = 0; u < 8; ++u) {
            int v;
            System.arraycopy(CW, 0, state, 0, CW.length);
            Pack.littleEndianToInt(this.sd, 0, state, 4, 12);
            state[14] = state[14] ^ (int)cc;
            state[15] = state[15] ^ (int)(cc >>> 32);
            for (int i = 0; i < 10; ++i) {
                this.QROUND(0, 4, 8, 12, state);
                this.QROUND(1, 5, 9, 13, state);
                this.QROUND(2, 6, 10, 14, state);
                this.QROUND(3, 7, 11, 15, state);
                this.QROUND(0, 5, 10, 15, state);
                this.QROUND(1, 6, 11, 12, state);
                this.QROUND(2, 7, 8, 13, state);
                this.QROUND(3, 4, 9, 14, state);
            }
            for (v = 0; v < 4; ++v) {
                int n = v;
                state[n] = state[n] + CW[v];
            }
            for (v = 4; v < 14; ++v) {
                int n = v;
                state[n] = state[n] + Pack.littleEndianToInt(this.sd, 4 * v - 16);
            }
            state[14] = state[14] + (Pack.littleEndianToInt(this.sd, 40) ^ (int)cc);
            state[15] = state[15] + (Pack.littleEndianToInt(this.sd, 44) ^ (int)(cc >>> 32));
            ++cc;
            for (v = 0; v < 16; ++v) {
                Pack.intToLittleEndian(state[v], this.bd, (u << 2) + (v << 5));
            }
        }
        Pack.longToLittleEndian(cc, this.sd, 48);
        this.ptr = 0;
    }

    private void QROUND(int a, int b, int c, int d, int[] state) {
        int n = a;
        state[n] = state[n] + state[b];
        int n2 = d;
        state[n2] = state[n2] ^ state[a];
        state[d] = state[d] << 16 | state[d] >>> 16;
        int n3 = c;
        state[n3] = state[n3] + state[d];
        int n4 = b;
        state[n4] = state[n4] ^ state[c];
        state[b] = state[b] << 12 | state[b] >>> 20;
        int n5 = a;
        state[n5] = state[n5] + state[b];
        int n6 = d;
        state[n6] = state[n6] ^ state[a];
        state[d] = state[d] << 8 | state[d] >>> 24;
        int n7 = c;
        state[n7] = state[n7] + state[d];
        int n8 = b;
        state[n8] = state[n8] ^ state[c];
        state[b] = state[b] << 7 | state[b] >>> 25;
    }

    long prng_get_u64() {
        int u = this.ptr;
        if (u >= this.bd.length - 9) {
            this.prng_refill();
            u = 0;
        }
        this.ptr = u + 8;
        return Pack.littleEndianToLong(this.bd, u);
    }

    byte prng_get_u8() {
        byte v = this.bd[this.ptr++];
        if (this.ptr == this.bd.length) {
            this.prng_refill();
        }
        return v;
    }
}

