/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.CSHAKEDigest;
import org.bouncycastle.crypto.digests.EncodableDigest;
import org.bouncycastle.crypto.digests.XofUtils;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

public class KMAC
implements Mac,
Xof,
Memoable,
EncodableDigest {
    private static final byte[] padding = new byte[100];
    private final CSHAKEDigest cshake;
    private int bitLength;
    private int outputLength;
    private byte[] key;
    private boolean initialised;
    private boolean firstOutput;

    public KMAC(int bitLength, byte[] S) {
        this.cshake = new CSHAKEDigest(bitLength, Strings.toByteArray("KMAC"), S);
        this.bitLength = bitLength;
        this.outputLength = bitLength * 2 / 8;
    }

    public KMAC(KMAC original) {
        this.cshake = new CSHAKEDigest(original.cshake);
        this.bitLength = original.bitLength;
        this.outputLength = original.outputLength;
        this.key = original.key;
        this.initialised = original.initialised;
        this.firstOutput = original.firstOutput;
    }

    public KMAC(byte[] state) {
        this.key = new byte[state[0] & 0xFF];
        System.arraycopy(state, 1, this.key, 0, this.key.length);
        this.cshake = new CSHAKEDigest(Arrays.copyOfRange(state, 1 + this.key.length, state.length - 10));
        this.bitLength = Pack.bigEndianToInt(state, state.length - 10);
        this.outputLength = Pack.bigEndianToInt(state, state.length - 6);
        this.initialised = state[state.length - 2] != 0;
        this.firstOutput = state[state.length - 1] != 0;
    }

    private void copyIn(KMAC original) {
        this.cshake.reset(original.cshake);
        this.bitLength = original.bitLength;
        this.outputLength = original.outputLength;
        this.initialised = original.initialised;
        this.firstOutput = original.firstOutput;
    }

    public void init(CipherParameters params) throws IllegalArgumentException {
        KeyParameter kParam = (KeyParameter)params;
        this.key = Arrays.clone(kParam.getKey());
        if (this.key.length > 255) {
            throw new IllegalArgumentException("key length must be between 0 and 2040 bits");
        }
        this.initialised = true;
        this.reset();
    }

    public String getAlgorithmName() {
        return "KMAC" + this.cshake.getAlgorithmName().substring(6);
    }

    public int getByteLength() {
        return this.cshake.getByteLength();
    }

    public int getMacSize() {
        return this.outputLength;
    }

    public int getDigestSize() {
        return this.outputLength;
    }

    public void update(byte in) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("KMAC not initialized");
        }
        this.cshake.update(in);
    }

    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("KMAC not initialized");
        }
        this.cshake.update(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.firstOutput) {
            if (!this.initialised) {
                throw new IllegalStateException("KMAC not initialized");
            }
            byte[] encOut = XofUtils.rightEncode(this.getMacSize() * 8);
            this.cshake.update(encOut, 0, encOut.length);
        }
        int rv = this.cshake.doFinal(out, outOff, this.getMacSize());
        this.reset();
        return rv;
    }

    public int doFinal(byte[] out, int outOff, int outLen) {
        if (this.firstOutput) {
            if (!this.initialised) {
                throw new IllegalStateException("KMAC not initialized");
            }
            byte[] encOut = XofUtils.rightEncode(outLen * 8);
            this.cshake.update(encOut, 0, encOut.length);
        }
        int rv = this.cshake.doFinal(out, outOff, outLen);
        this.reset();
        return rv;
    }

    public int doOutput(byte[] out, int outOff, int outLen) {
        if (this.firstOutput) {
            if (!this.initialised) {
                throw new IllegalStateException("KMAC not initialized");
            }
            byte[] encOut = XofUtils.rightEncode(0L);
            this.cshake.update(encOut, 0, encOut.length);
            this.firstOutput = false;
        }
        return this.cshake.doOutput(out, outOff, outLen);
    }

    public void reset() {
        this.cshake.reset();
        if (this.key != null) {
            if (this.bitLength == 128) {
                this.bytePad(this.key, 168);
            } else {
                this.bytePad(this.key, 136);
            }
        }
        this.firstOutput = true;
    }

    private void bytePad(byte[] X, int w) {
        int required;
        byte[] bytes = XofUtils.leftEncode(w);
        this.update(bytes, 0, bytes.length);
        byte[] encX = KMAC.encode(X);
        this.update(encX, 0, encX.length);
        if (required > 0 && required != w) {
            for (required = w - (bytes.length + encX.length) % w; required > padding.length; required -= padding.length) {
                this.update(padding, 0, padding.length);
            }
            this.update(padding, 0, required);
        }
    }

    private static byte[] encode(byte[] X) {
        return Arrays.concatenate(XofUtils.leftEncode(X.length * 8), X);
    }

    public byte[] getEncodedState() {
        if (!this.initialised) {
            throw new IllegalStateException("KMAC not initialised");
        }
        byte[] cshakeState = this.cshake.getEncodedState();
        byte[] extraState = new byte[10];
        Pack.intToBigEndian(this.bitLength, extraState, 0);
        Pack.intToBigEndian(this.outputLength, extraState, 4);
        extraState[8] = this.initialised ? (byte)1 : 0;
        extraState[9] = this.firstOutput ? (byte)1 : 0;
        byte[] enc = new byte[1 + this.key.length + cshakeState.length + extraState.length];
        enc[0] = (byte)this.key.length;
        System.arraycopy(this.key, 0, enc, 1, this.key.length);
        System.arraycopy(cshakeState, 0, enc, 1 + this.key.length, cshakeState.length);
        System.arraycopy(extraState, 0, enc, 1 + this.key.length + cshakeState.length, extraState.length);
        return enc;
    }

    public Memoable copy() {
        return new KMAC(this);
    }

    public void reset(Memoable other) {
        this.copyIn((KMAC)other);
    }
}

