/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.kems;

import javax.security.auth.DestroyFailedException;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.util.Arrays;

class SecretWithEncapsulationImpl
implements SecretWithEncapsulation {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] sessionKey;
    private final byte[] cipher_text;

    public SecretWithEncapsulationImpl(byte[] sessionKey, byte[] cipher_text) {
        this.sessionKey = sessionKey;
        this.cipher_text = cipher_text;
    }

    public byte[] getSecret() {
        this.checkDestroyed();
        return Arrays.clone(this.sessionKey);
    }

    public byte[] getEncapsulation() {
        this.checkDestroyed();
        return Arrays.clone(this.cipher_text);
    }

    public void destroy() throws DestroyFailedException {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.sessionKey);
            Arrays.clear(this.cipher_text);
        }
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("data has been destroyed");
        }
    }

    private static class AtomicBoolean {
        private volatile boolean value;

        AtomicBoolean(boolean value) {
            this.value = value;
        }

        public synchronized void set(boolean value) {
            this.value = value;
        }

        public synchronized boolean getAndSet(boolean value) {
            boolean tmp = this.value;
            this.value = value;
            return tmp;
        }

        public synchronized boolean get() {
            return this.value;
        }
    }
}

