/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

abstract class AEADBaseEngine
implements AEADCipher {
    protected boolean forEncryption;
    protected String algorithmName;
    protected int KEY_SIZE;
    protected int IV_SIZE;
    protected int MAC_SIZE;
    protected int macSizeLowerBound = 0;
    protected byte[] initialAssociatedText;
    protected byte[] mac;
    protected byte[] m_buf;
    protected byte[] m_aad;
    protected int m_bufPos;
    protected int m_aadPos;
    protected int AADBufferSize;
    protected int BlockSize;
    protected State m_state = State.Uninitialized;
    protected int m_bufferSizeDecrypt;
    protected AADProcessingBuffer processor;
    protected AADOperator aadOperator;
    protected DataOperator dataOperator;
    protected DecryptionFailureCounter decryptionFailureCounter = null;
    protected DataLimitCounter dataLimitCounter = null;

    AEADBaseEngine() {
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getKeyBytesSize() {
        return this.KEY_SIZE;
    }

    public int getIVBytesSize() {
        return this.IV_SIZE;
    }

    public byte[] getMac() {
        return this.mac;
    }

    /*
     * WARNING - void declaration
     */
    public void init(boolean forEncryption, CipherParameters params) {
        void var4_6;
        void var3_5;
        byte[] npub;
        KeyParameter key;
        this.forEncryption = forEncryption;
        if (params instanceof AEADParameters) {
            AEADParameters aeadParameters = (AEADParameters)params;
            key = aeadParameters.getKey();
            npub = aeadParameters.getNonce();
            this.initialAssociatedText = aeadParameters.getAssociatedText();
            int macSizeBits = aeadParameters.getMacSize();
            if (this.macSizeLowerBound == 0) {
                if (macSizeBits != this.MAC_SIZE << 3) {
                    throw new IllegalArgumentException("Invalid value for MAC size: " + macSizeBits);
                }
            } else {
                if (macSizeBits > 128 || macSizeBits < this.macSizeLowerBound << 3 || (macSizeBits & 7) != 0) {
                    throw new IllegalArgumentException("MAC size must be between " + (this.macSizeLowerBound << 3) + " and 128 bits for " + this.algorithmName);
                }
                this.MAC_SIZE = macSizeBits >>> 3;
            }
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV withIV = (ParametersWithIV)params;
            key = (KeyParameter)withIV.getParameters();
            npub = withIV.getIV();
            this.initialAssociatedText = null;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to " + this.algorithmName);
        }
        if (var3_5 == null) {
            throw new IllegalArgumentException(this.algorithmName + " Init parameters must include a key");
        }
        if (var4_6 == null || ((void)var4_6).length != this.IV_SIZE) {
            throw new IllegalArgumentException(this.algorithmName + " requires exactly " + this.IV_SIZE + " bytes of IV");
        }
        byte[] k = var3_5.getKey();
        if (k.length != this.KEY_SIZE) {
            throw new IllegalArgumentException(this.algorithmName + " key must be " + this.KEY_SIZE + " bytes long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.m_state = forEncryption ? State.EncInit : State.DecInit;
        this.init(k, (byte[])var4_6);
        if (this.dataLimitCounter != null) {
            this.dataLimitCounter.increment(((void)var4_6).length);
        }
        this.reset(true);
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public void reset() {
        this.reset(true);
    }

    protected void reset(boolean clearMac) {
        this.ensureInitialized();
        if (clearMac) {
            this.mac = null;
        }
        if (this.m_buf != null) {
            Arrays.fill(this.m_buf, (byte)0);
            this.m_bufPos = 0;
        }
        if (this.m_aad != null) {
            Arrays.fill(this.m_aad, (byte)0);
            this.m_aadPos = 0;
        }
        switch (this.m_state.ord) {
            case 1: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.m_state = State.DecFinal;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.m_state = State.EncFinal;
                return;
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
        this.aadOperator.reset();
        this.dataOperator.reset();
    }

    protected void setInnerMembers(ProcessingBufferType type, AADOperatorType aadOperatorType, DataOperatorType dataOperatorType) {
        switch (type.ord) {
            case 0: {
                this.processor = new BufferedAADProcessor();
                break;
            }
            case 1: {
                this.processor = new ImmediateAADProcessor();
            }
        }
        this.m_bufferSizeDecrypt = this.BlockSize + this.MAC_SIZE;
        switch (aadOperatorType.ord) {
            case 0: {
                this.m_aad = new byte[this.AADBufferSize];
                this.aadOperator = new DefaultAADOperator();
                break;
            }
            case 1: {
                this.m_aad = new byte[this.AADBufferSize];
                this.aadOperator = new CounterAADOperator();
                break;
            }
            case 2: {
                this.AADBufferSize = 0;
                this.aadOperator = new StreamAADOperator();
                break;
            }
            case 3: {
                this.m_aad = new byte[this.AADBufferSize];
                this.dataLimitCounter = new DataLimitCounter();
                this.aadOperator = new DataLimitAADOperator();
            }
        }
        switch (dataOperatorType.ord) {
            case 0: {
                this.m_buf = new byte[this.m_bufferSizeDecrypt];
                this.dataOperator = new DefaultDataOperator();
                break;
            }
            case 1: {
                this.m_buf = new byte[this.m_bufferSizeDecrypt];
                this.dataOperator = new CounterDataOperator();
                break;
            }
            case 2: {
                this.m_buf = new byte[this.MAC_SIZE];
                this.dataOperator = new StreamDataOperator();
                break;
            }
            case 3: {
                this.BlockSize = 0;
                this.m_buf = new byte[this.m_bufferSizeDecrypt];
                this.dataOperator = new StreamCipherOperator();
                break;
            }
            case 4: {
                this.m_buf = new byte[this.m_bufferSizeDecrypt];
                this.dataOperator = new DataLimitDataOperator();
            }
        }
    }

    public void processAADByte(byte input) {
        this.checkAAD();
        this.aadOperator.processAADByte(input);
    }

    public void processAADBytes(byte[] input, int inOff, int len) {
        this.ensureSufficientInputBuffer(input, inOff, len);
        if (len <= 0) {
            return;
        }
        this.checkAAD();
        this.aadOperator.processAADBytes(input, inOff, len);
    }

    private void processAadBytes(byte[] input, int inOff, int len) {
        if (this.m_aadPos > 0) {
            int available = this.AADBufferSize - this.m_aadPos;
            if (this.processor.isLengthWithinAvailableSpace(len, available)) {
                System.arraycopy(input, inOff, this.m_aad, this.m_aadPos, len);
                this.m_aadPos += len;
                return;
            }
            System.arraycopy(input, inOff, this.m_aad, this.m_aadPos, available);
            inOff += available;
            len -= available;
            this.processBufferAAD(this.m_aad, 0);
        }
        while (this.processor.isLengthExceedingBlockSize(len, this.AADBufferSize)) {
            this.processBufferAAD(input, inOff);
            inOff += this.AADBufferSize;
            len -= this.AADBufferSize;
        }
        System.arraycopy(input, inOff, this.m_aad, 0, len);
        this.m_aadPos = len;
    }

    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.dataOperator.processByte(in, out, outOff);
    }

    protected int processEncDecByte(byte[] output, int outOff) {
        int rlt = 0;
        int available = (this.forEncryption ? this.BlockSize : this.m_bufferSizeDecrypt) - this.m_bufPos;
        if (available == 0) {
            this.ensureSufficientOutputBuffer(output, outOff, this.BlockSize);
            if (this.forEncryption) {
                this.processBufferEncrypt(this.m_buf, 0, output, outOff);
            } else {
                this.processBufferDecrypt(this.m_buf, 0, output, outOff);
                System.arraycopy(this.m_buf, this.BlockSize, this.m_buf, 0, this.m_bufPos - this.BlockSize);
            }
            this.m_bufPos -= this.BlockSize;
            rlt = this.BlockSize;
        }
        return rlt;
    }

    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        this.ensureSufficientInputBuffer(input, inOff, len);
        return this.dataOperator.processBytes(input, inOff, len, output, outOff);
    }

    protected int processEncDecBytes(byte[] input, int inOff, int len, byte[] output, int outOff) {
        boolean forEncryption = this.checkData(false);
        int available = (forEncryption ? this.BlockSize : this.m_bufferSizeDecrypt) - this.m_bufPos;
        if (this.processor.isLengthWithinAvailableSpace(len, available)) {
            System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
            this.m_bufPos += len;
            return 0;
        }
        int length = this.processor.getUpdateOutputSize(len);
        int resultLength = length + this.m_bufPos - (forEncryption ? 0 : this.MAC_SIZE);
        this.ensureSufficientOutputBuffer(output, outOff, resultLength - resultLength % this.BlockSize);
        resultLength = 0;
        if (input == output && Arrays.segmentsOverlap(inOff, len, outOff, length)) {
            input = new byte[len];
            System.arraycopy(output, inOff, input, 0, len);
            inOff = 0;
        }
        if (forEncryption) {
            if (this.m_bufPos > 0) {
                System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
                inOff += available;
                len -= available;
                this.processBufferEncrypt(this.m_buf, 0, output, outOff);
                resultLength = this.BlockSize;
            }
            while (this.processor.isLengthExceedingBlockSize(len, this.BlockSize)) {
                this.processBufferEncrypt(input, inOff, output, outOff + resultLength);
                inOff += this.BlockSize;
                len -= this.BlockSize;
                resultLength += this.BlockSize;
            }
        } else {
            while (this.processor.isLengthExceedingBlockSize(this.m_bufPos, this.BlockSize) && this.processor.isLengthExceedingBlockSize(len + this.m_bufPos, this.m_bufferSizeDecrypt)) {
                this.processBufferDecrypt(this.m_buf, resultLength, output, outOff + resultLength);
                this.m_bufPos -= this.BlockSize;
                resultLength += this.BlockSize;
            }
            if (this.m_bufPos > 0) {
                System.arraycopy(this.m_buf, resultLength, this.m_buf, 0, this.m_bufPos);
                if (this.processor.isLengthWithinAvailableSpace(this.m_bufPos + len, this.m_bufferSizeDecrypt)) {
                    System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
                    this.m_bufPos += len;
                    return resultLength;
                }
                available = Math.max(this.BlockSize - this.m_bufPos, 0);
                System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
                inOff += available;
                len -= available;
                this.processBufferDecrypt(this.m_buf, 0, output, outOff + resultLength);
                resultLength += this.BlockSize;
            }
            while (this.processor.isLengthExceedingBlockSize(len, this.m_bufferSizeDecrypt)) {
                this.processBufferDecrypt(input, inOff, output, outOff + resultLength);
                inOff += this.BlockSize;
                len -= this.BlockSize;
                resultLength += this.BlockSize;
            }
        }
        System.arraycopy(input, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
        return resultLength;
    }

    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int resultLength;
        boolean forEncryption = this.checkData(true);
        if (forEncryption) {
            resultLength = this.m_bufPos + this.MAC_SIZE;
        } else {
            if (this.m_bufPos < this.MAC_SIZE) {
                throw new InvalidCipherTextException("data too short");
            }
            this.m_bufPos -= this.MAC_SIZE;
            resultLength = this.m_bufPos;
        }
        this.ensureSufficientOutputBuffer(output, outOff, resultLength);
        this.mac = new byte[this.MAC_SIZE];
        this.processFinalBlock(output, outOff);
        if (forEncryption) {
            System.arraycopy(this.mac, 0, output, outOff + resultLength - this.MAC_SIZE, this.MAC_SIZE);
        } else if (!Arrays.constantTimeAreEqual(this.MAC_SIZE, this.mac, 0, this.m_buf, this.m_bufPos)) {
            if (this.decryptionFailureCounter != null && this.decryptionFailureCounter.increment()) {
                throw new InvalidCipherTextException(this.algorithmName + " decryption failure limit exceeded");
            }
            throw new InvalidCipherTextException(this.algorithmName + " mac does not match");
        }
        this.reset(!forEncryption);
        return resultLength;
    }

    public final int getBlockSize() {
        return this.BlockSize;
    }

    public int getUpdateOutputSize(int len) {
        int total = this.getTotalBytesForUpdate(len);
        return total - total % this.BlockSize;
    }

    protected int getTotalBytesForUpdate(int len) {
        int total = this.processor.getUpdateOutputSize(len);
        switch (this.m_state.ord) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                total = Math.max(0, total + this.m_bufPos - this.MAC_SIZE);
                break;
            }
            case 3: 
            case 4: {
                total = Math.max(0, total + this.m_bufPos);
                break;
            }
        }
        return total;
    }

    public int getOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state.ord) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Math.max(0, total + this.m_bufPos - this.MAC_SIZE);
            }
            case 3: 
            case 4: {
                return total + this.m_bufPos + this.MAC_SIZE;
            }
        }
        return total + this.MAC_SIZE;
    }

    protected void checkAAD() {
        switch (this.m_state.ord) {
            case 5: {
                this.m_state = State.DecAad;
                break;
            }
            case 1: {
                this.m_state = State.EncAad;
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    protected boolean checkData(boolean isDoFinal) {
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                this.finishAAD(State.DecData, isDoFinal);
                return false;
            }
            case 1: 
            case 2: {
                this.finishAAD(State.EncData, isDoFinal);
                return true;
            }
            case 7: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
    }

    protected final void ensureSufficientOutputBuffer(byte[] output, int outOff, int len) {
        if (outOff + len > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
    }

    protected final void ensureSufficientInputBuffer(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
    }

    protected final void ensureInitialized() {
        if (this.m_state == State.Uninitialized) {
            throw new IllegalStateException("Need to call init function before operation");
        }
    }

    protected void finishAAD1(State nextState) {
        switch (this.m_state.ord) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.processFinalAAD();
                break;
            }
        }
        this.m_state = nextState;
    }

    protected void finishAAD2(State nextState) {
        switch (this.m_state.ord) {
            case 2: 
            case 6: {
                this.processFinalAAD();
                break;
            }
        }
        this.m_aadPos = 0;
        this.m_state = nextState;
    }

    protected void finishAAD3(State nextState, boolean isDoFinal) {
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                if (!isDoFinal && this.dataOperator.getLen() <= this.MAC_SIZE) {
                    return;
                }
            }
            case 1: 
            case 2: {
                this.processFinalAAD();
            }
        }
        this.m_aadPos = 0;
        this.m_state = nextState;
    }

    protected abstract void finishAAD(State var1, boolean var2);

    protected abstract void init(byte[] var1, byte[] var2);

    protected abstract void processFinalBlock(byte[] var1, int var2);

    protected abstract void processBufferAAD(byte[] var1, int var2);

    protected abstract void processFinalAAD();

    protected abstract void processBufferEncrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void processBufferDecrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected static final class ErasableOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }
    }

    protected static class DataLimitCounter {
        private long count;
        private long max;
        private int n;

        protected DataLimitCounter() {
        }

        public void init(int n) {
            this.n = n;
            this.max = 1L << n;
        }

        public void increment() {
            if (++this.count > this.max) {
                throw new IllegalStateException("Total data limit exceeded: maximum 2^" + this.n + " bytes per key (including nonce, AAD, and message)");
            }
        }

        public void increment(int n) {
            this.count += (long)n;
            if (this.count > this.max) {
                throw new IllegalStateException("Total data limit exceeded: maximum 2^" + n + " bytes per key (including nonce, AAD, and message)");
            }
        }

        public void reset() {
            this.count = 0L;
        }
    }

    protected static class DecryptionFailureCounter {
        private int n;
        private int[] counter;

        protected DecryptionFailureCounter() {
        }

        public void init(int n) {
            if (this.n != n) {
                this.n = n;
                int len = n + 31 >>> 5;
                if (this.counter == null || len != this.counter.length) {
                    this.counter = new int[len];
                } else {
                    this.reset();
                }
            }
        }

        public boolean increment() {
            int i = this.counter.length;
            while (--i >= 0) {
                int n = i;
                this.counter[n] = this.counter[n] + 1;
                if (this.counter[n] == 0) continue;
            }
            int r = this.n & 0x1F;
            return i <= 0 && this.counter[0] == (r == 0 ? 0 : 1 << r);
        }

        public void reset() {
            Arrays.fill(this.counter, 0);
        }
    }

    private class DataLimitDataOperator
    implements DataOperator {
        private DataLimitDataOperator() {
        }

        public int processByte(byte input, byte[] output, int outOff) {
            AEADBaseEngine.this.dataLimitCounter.increment();
            return AEADBaseEngine.this.processor.processByte(input, output, outOff);
        }

        public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) {
            AEADBaseEngine.this.dataLimitCounter.increment(len);
            return AEADBaseEngine.this.processEncDecBytes(input, inOff, len, output, outOff);
        }

        public int getLen() {
            return AEADBaseEngine.this.m_bufPos;
        }

        public void reset() {
        }
    }

    private class StreamCipherOperator
    implements DataOperator {
        private int len;

        private StreamCipherOperator() {
        }

        public int processByte(byte input, byte[] output, int outOff) {
            boolean forEncryption = AEADBaseEngine.this.checkData(false);
            if (forEncryption) {
                this.len = 1;
                AEADBaseEngine.this.processBufferEncrypt(new byte[]{input}, 0, output, outOff);
                return 1;
            }
            if (AEADBaseEngine.this.m_bufPos == AEADBaseEngine.this.MAC_SIZE) {
                this.len = 1;
                AEADBaseEngine.this.processBufferDecrypt(AEADBaseEngine.this.m_buf, 0, output, outOff);
                System.arraycopy(AEADBaseEngine.this.m_buf, 1, AEADBaseEngine.this.m_buf, 0, AEADBaseEngine.this.m_bufPos - 1);
                AEADBaseEngine.this.m_buf[AEADBaseEngine.this.m_bufPos - 1] = input;
                return 1;
            }
            AEADBaseEngine.this.m_buf[AEADBaseEngine.this.m_bufPos++] = input;
            return 0;
        }

        public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) {
            boolean forEncryption;
            if (input == output && Arrays.segmentsOverlap(inOff, len, outOff, AEADBaseEngine.this.processor.getUpdateOutputSize(len))) {
                input = new byte[len];
                System.arraycopy(output, inOff, input, 0, len);
                inOff = 0;
            }
            if (forEncryption = AEADBaseEngine.this.checkData(false)) {
                this.len = len;
                AEADBaseEngine.this.processBufferEncrypt(input, inOff, output, outOff);
                return len;
            }
            int available = Math.max(AEADBaseEngine.this.m_bufPos + len - AEADBaseEngine.this.MAC_SIZE, 0);
            int rlt = 0;
            if (AEADBaseEngine.this.m_bufPos > 0) {
                rlt = this.len = Math.min(available, AEADBaseEngine.this.m_bufPos);
                AEADBaseEngine.this.processBufferDecrypt(AEADBaseEngine.this.m_buf, 0, output, outOff);
                available -= rlt;
                AEADBaseEngine.this.m_bufPos -= rlt;
                System.arraycopy(AEADBaseEngine.this.m_buf, rlt, AEADBaseEngine.this.m_buf, 0, AEADBaseEngine.this.m_bufPos);
            }
            if (available > 0) {
                this.len = available;
                AEADBaseEngine.this.processBufferDecrypt(input, inOff, output, outOff);
                rlt += available;
                len -= available;
                inOff += available;
            }
            System.arraycopy(input, inOff, AEADBaseEngine.this.m_buf, AEADBaseEngine.this.m_bufPos, len);
            AEADBaseEngine.this.m_bufPos += len;
            return rlt;
        }

        public int getLen() {
            return this.len;
        }

        public void reset() {
        }
    }

    protected class StreamDataOperator
    implements DataOperator {
        private final ErasableOutputStream stream = new ErasableOutputStream();

        protected StreamDataOperator() {
        }

        public int processByte(byte input, byte[] output, int outOff) {
            AEADBaseEngine.this.checkData(false);
            AEADBaseEngine.this.ensureInitialized();
            this.stream.write(input);
            AEADBaseEngine.this.m_bufPos = this.stream.size();
            return 0;
        }

        public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) {
            AEADBaseEngine.this.checkData(false);
            AEADBaseEngine.this.ensureInitialized();
            this.stream.write(input, inOff, len);
            AEADBaseEngine.this.m_bufPos = this.stream.size();
            return 0;
        }

        public byte[] getBytes() {
            return this.stream.getBuf();
        }

        public int getLen() {
            return this.stream.size();
        }

        public void reset() {
            this.stream.reset();
        }
    }

    private class CounterDataOperator
    implements DataOperator {
        private int messegeLen;

        private CounterDataOperator() {
        }

        public int processByte(byte input, byte[] output, int outOff) {
            ++this.messegeLen;
            return AEADBaseEngine.this.processor.processByte(input, output, outOff);
        }

        public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) {
            this.messegeLen += len;
            return AEADBaseEngine.this.processEncDecBytes(input, inOff, len, output, outOff);
        }

        public int getLen() {
            return this.messegeLen;
        }

        public void reset() {
            this.messegeLen = 0;
        }
    }

    private class DefaultDataOperator
    implements DataOperator {
        private DefaultDataOperator() {
        }

        public int processByte(byte input, byte[] output, int outOff) {
            return AEADBaseEngine.this.processor.processByte(input, output, outOff);
        }

        public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) {
            return AEADBaseEngine.this.processEncDecBytes(input, inOff, len, output, outOff);
        }

        public int getLen() {
            return AEADBaseEngine.this.m_bufPos;
        }

        public void reset() {
        }
    }

    protected static interface DataOperator {
        public int processByte(byte var1, byte[] var2, int var3);

        public int processBytes(byte[] var1, int var2, int var3, byte[] var4, int var5);

        public int getLen();

        public void reset();
    }

    private class DataLimitAADOperator
    implements AADOperator {
        private DataLimitAADOperator() {
        }

        public void processAADByte(byte input) {
            AEADBaseEngine.this.dataLimitCounter.increment();
            AEADBaseEngine.this.processor.processAADByte(input);
        }

        public void processAADBytes(byte[] input, int inOff, int len) {
            AEADBaseEngine.this.dataLimitCounter.increment(len);
            AEADBaseEngine.this.processAadBytes(input, inOff, len);
        }

        public void reset() {
        }

        public int getLen() {
            return AEADBaseEngine.this.m_aadPos;
        }
    }

    protected static class StreamAADOperator
    implements AADOperator {
        private final ErasableOutputStream stream = new ErasableOutputStream();

        protected StreamAADOperator() {
        }

        public void processAADByte(byte input) {
            this.stream.write(input);
        }

        public void processAADBytes(byte[] input, int inOff, int len) {
            this.stream.write(input, inOff, len);
        }

        public byte[] getBytes() {
            return this.stream.getBuf();
        }

        public void reset() {
            this.stream.reset();
        }

        public int getLen() {
            return this.stream.size();
        }
    }

    private class CounterAADOperator
    implements AADOperator {
        private int aadLen;

        private CounterAADOperator() {
        }

        public void processAADByte(byte input) {
            ++this.aadLen;
            AEADBaseEngine.this.processor.processAADByte(input);
        }

        public void processAADBytes(byte[] input, int inOff, int len) {
            this.aadLen += len;
            AEADBaseEngine.this.processAadBytes(input, inOff, len);
        }

        public int getLen() {
            return this.aadLen;
        }

        public void reset() {
            this.aadLen = 0;
        }
    }

    private class DefaultAADOperator
    implements AADOperator {
        private DefaultAADOperator() {
        }

        public void processAADByte(byte input) {
            AEADBaseEngine.this.processor.processAADByte(input);
        }

        public void processAADBytes(byte[] input, int inOff, int len) {
            AEADBaseEngine.this.processAadBytes(input, inOff, len);
        }

        public void reset() {
        }

        public int getLen() {
            return AEADBaseEngine.this.m_aadPos;
        }
    }

    protected static interface AADOperator {
        public void processAADByte(byte var1);

        public void processAADBytes(byte[] var1, int var2, int var3);

        public void reset();

        public int getLen();
    }

    private class ImmediateAADProcessor
    implements AADProcessingBuffer {
        private ImmediateAADProcessor() {
        }

        public void processAADByte(byte input) {
            AEADBaseEngine.this.m_aad[AEADBaseEngine.this.m_aadPos++] = input;
            if (AEADBaseEngine.this.m_aadPos == AEADBaseEngine.this.AADBufferSize) {
                AEADBaseEngine.this.processBufferAAD(AEADBaseEngine.this.m_aad, 0);
                AEADBaseEngine.this.m_aadPos = 0;
            }
        }

        public int processByte(byte input, byte[] output, int outOff) {
            AEADBaseEngine.this.checkData(false);
            AEADBaseEngine.this.m_buf[AEADBaseEngine.this.m_bufPos++] = input;
            return AEADBaseEngine.this.processEncDecByte(output, outOff);
        }

        public int getUpdateOutputSize(int len) {
            return Math.max(0, len);
        }

        public boolean isLengthWithinAvailableSpace(int len, int available) {
            return len < available;
        }

        public boolean isLengthExceedingBlockSize(int len, int size) {
            return len >= size;
        }
    }

    private class BufferedAADProcessor
    implements AADProcessingBuffer {
        private BufferedAADProcessor() {
        }

        public void processAADByte(byte input) {
            if (AEADBaseEngine.this.m_aadPos == AEADBaseEngine.this.AADBufferSize) {
                AEADBaseEngine.this.processBufferAAD(AEADBaseEngine.this.m_aad, 0);
                AEADBaseEngine.this.m_aadPos = 0;
            }
            AEADBaseEngine.this.m_aad[AEADBaseEngine.this.m_aadPos++] = input;
        }

        public int processByte(byte input, byte[] output, int outOff) {
            AEADBaseEngine.this.checkData(false);
            int rlt = AEADBaseEngine.this.processEncDecByte(output, outOff);
            AEADBaseEngine.this.m_buf[AEADBaseEngine.this.m_bufPos++] = input;
            return rlt;
        }

        public boolean isLengthWithinAvailableSpace(int len, int available) {
            return len <= available;
        }

        public boolean isLengthExceedingBlockSize(int len, int size) {
            return len > size;
        }

        public int getUpdateOutputSize(int len) {
            return Math.max(0, len) - 1;
        }
    }

    private static interface AADProcessingBuffer {
        public void processAADByte(byte var1);

        public int processByte(byte var1, byte[] var2, int var3);

        public int getUpdateOutputSize(int var1);

        public boolean isLengthWithinAvailableSpace(int var1, int var2);

        public boolean isLengthExceedingBlockSize(int var1, int var2);
    }

    protected static class State {
        public static final int UNINITIALIZED = 0;
        public static final int ENC_INIT = 1;
        public static final int ENC_AAD = 2;
        public static final int ENC_DATA = 3;
        public static final int ENC_FINAL = 4;
        public static final int DEC_INIT = 5;
        public static final int DEC_AAD = 6;
        public static final int DEC_DATA = 7;
        public static final int DEC_FINAL = 8;
        public static final State Uninitialized = new State(0);
        public static final State EncInit = new State(1);
        public static final State EncAad = new State(2);
        public static final State EncData = new State(3);
        public static final State EncFinal = new State(4);
        public static final State DecInit = new State(5);
        public static final State DecAad = new State(6);
        public static final State DecData = new State(7);
        public static final State DecFinal = new State(8);
        final int ord;

        State(int ord) {
            this.ord = ord;
        }
    }

    protected static class DataOperatorType {
        public static final int DEFAULT = 0;
        public static final int COUNTER = 1;
        public static final int STREAM = 2;
        public static final int STREAM_CIPHER = 3;
        public static final int DATA_LIMIT = 4;
        public static final DataOperatorType Default = new DataOperatorType(0);
        public static final DataOperatorType Counter = new DataOperatorType(1);
        public static final DataOperatorType Stream = new DataOperatorType(2);
        public static final DataOperatorType StreamCipher = new DataOperatorType(3);
        public static final DataOperatorType DataLimit = new DataOperatorType(4);
        private final int ord;

        DataOperatorType(int ord) {
            this.ord = ord;
        }
    }

    protected static class AADOperatorType {
        public static final int DEFAULT = 0;
        public static final int COUNTER = 1;
        public static final int STREAM = 2;
        public static final int DATA_LIMIT = 3;
        public static final AADOperatorType Default = new AADOperatorType(0);
        public static final AADOperatorType Counter = new AADOperatorType(1);
        public static final AADOperatorType Stream = new AADOperatorType(2);
        public static final AADOperatorType DataLimit = new AADOperatorType(3);
        private final int ord;

        AADOperatorType(int ord) {
            this.ord = ord;
        }
    }

    protected static class ProcessingBufferType {
        public static final int BUFFERED = 0;
        public static final int IMMEDIATE = 1;
        public static final ProcessingBufferType Buffered = new ProcessingBufferType(0);
        public static final ProcessingBufferType Immediate = new ProcessingBufferType(1);
        private final int ord;

        ProcessingBufferType(int ord) {
            this.ord = ord;
        }
    }
}

