/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.digests.XofUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Memoable;

public class CSHAKEDigest
extends SHAKEDigest {
    private static final byte[] padding = new byte[100];
    private byte[] diff;

    public CSHAKEDigest(int bitLength, byte[] N, byte[] S) {
        this(bitLength, CryptoServicePurpose.ANY, N, S);
    }

    public CSHAKEDigest(int bitLength, CryptoServicePurpose purpose, byte[] N, byte[] S) {
        super(bitLength, purpose);
        if (!(N != null && N.length != 0 || S != null && S.length != 0)) {
            this.diff = null;
        } else {
            this.diff = Arrays.concatenate(XofUtils.leftEncode(this.rate / 8), this.encodeString(N), this.encodeString(S));
            this.diffPadAndAbsorb();
        }
    }

    public CSHAKEDigest(CSHAKEDigest source) {
        super(source);
        this.diff = Arrays.clone(source.diff);
    }

    public CSHAKEDigest(byte[] encodedState) {
        super(encodedState);
        int sha3StateLength = this.state.length * 8 + this.dataQueue.length + 12 + 2;
        if (encodedState.length != sha3StateLength) {
            this.diff = new byte[encodedState.length - sha3StateLength];
            System.arraycopy(encodedState, sha3StateLength, this.diff, 0, this.diff.length);
        } else {
            this.diff = null;
        }
    }

    private void copyIn(CSHAKEDigest source) {
        super.copyIn(source);
        this.diff = Arrays.clone(source.diff);
    }

    private void diffPadAndAbsorb() {
        int blockSize = this.rate / 8;
        this.absorb(this.diff, 0, this.diff.length);
        int delta = this.diff.length % blockSize;
        if (delta != 0) {
            int required;
            for (required = blockSize - delta; required > padding.length; required -= padding.length) {
                this.absorb(padding, 0, padding.length);
            }
            this.absorb(padding, 0, required);
        }
    }

    private byte[] encodeString(byte[] str) {
        if (str == null || str.length == 0) {
            return XofUtils.leftEncode(0L);
        }
        return Arrays.concatenate(XofUtils.leftEncode((long)str.length * 8L), str);
    }

    public String getAlgorithmName() {
        return "CSHAKE" + this.fixedOutputLength;
    }

    public int doOutput(byte[] out, int outOff, int outLen) {
        if (this.diff != null) {
            if (!this.squeezing) {
                this.absorbBits(0, 2);
            }
            this.squeeze(out, outOff, (long)outLen * 8L);
            return outLen;
        }
        return super.doOutput(out, outOff, outLen);
    }

    public void reset() {
        super.reset();
        if (this.diff != null) {
            this.diffPadAndAbsorb();
        }
    }

    public byte[] getEncodedState() {
        byte[] encState;
        int sha3StateLength = this.state.length * 8 + this.dataQueue.length + 12 + 2;
        if (this.diff == null) {
            encState = new byte[sha3StateLength];
            super.getEncodedState(encState);
        } else {
            encState = new byte[sha3StateLength + this.diff.length];
            super.getEncodedState(encState);
            System.arraycopy(this.diff, 0, encState, sha3StateLength, this.diff.length);
        }
        return encState;
    }

    public Memoable copy() {
        return new CSHAKEDigest(this);
    }

    public void reset(Memoable other) {
        CSHAKEDigest d = (CSHAKEDigest)other;
        this.copyIn(d);
    }
}

