/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.mayo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pqc.crypto.mayo.MayoPublicKeyParameters;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.pqc.jcajce.interfaces.MayoKey;
import org.bouncycastle.pqc.jcajce.spec.MayoParameterSpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class BCMayoPublicKey
implements PublicKey,
MayoKey {
    private static final long serialVersionUID = 1L;
    private transient MayoPublicKeyParameters params;

    public BCMayoPublicKey(MayoPublicKeyParameters params) {
        this.params = params;
    }

    public BCMayoPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.params = (MayoPublicKeyParameters)PublicKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCMayoPublicKey) {
            BCMayoPublicKey otherKey = (BCMayoPublicKey)o;
            return Arrays.areEqual(this.params.getEncoded(), otherKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo pki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public MayoParameterSpec getParameterSpec() {
        return MayoParameterSpec.fromName(this.params.getParameters().getName());
    }

    MayoPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

